/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.menu.ContextualMenuFactory;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.swing.Toolbar;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.works.utils.IconManager;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.graph.GGraphAbstract;
import org.antlr.works.visualization.graphics.graph.GGraphGroup;
import org.antlr.works.visualization.graphics.panel.GView;
import org.antlr.works.visualization.skin.nfa.NFASkin;
import org.antlr.works.visualization.skin.syntaxdiagram.SDSkin;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;
import org.antlr.xjlib.foundation.notification.XJNotificationObserver;

public class GPanel
implements XJNotificationObserver {
    protected Container container;
    protected Box pathButtonSelectionBox;
    protected Toolbar controlPanel;
    protected JTextField errorLabel;
    protected GContext context;
    protected GView view;
    protected JScrollPane viewScrollPane;
    protected ElementRule rule;
    protected CEditorGrammar editor;

    public GPanel(CEditorGrammar cEditorGrammar, GContext gContext) {
        this.editor = cEditorGrammar;
        this.context = gContext;
        this.container = new JPanel(new BorderLayout());
        this.createNormalPanel();
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_CURRENT_PATH_DID_CHANGE");
    }

    public void close() {
        this.editor = null;
        this.context = null;
        XJNotificationCenter.defaultCenter().removeObserver(this);
    }

    public void setGraphs(List list) {
        this.view.setGraphs(list);
        this.view.refresh();
        this.updateCurrentAlternative();
    }

    public void setRule(ElementRule elementRule) {
        if (this.view != null) {
            this.view.setEnable(false);
        }
        this.rule = elementRule;
        this.createPanel();
        this.view.setEnable(true);
    }

    public void setPlaceholder(String string) {
        this.view.setPlaceholder(string);
    }

    public void update() {
        this.updateCurrentError();
    }

    public Container getContainer() {
        return this.container;
    }

    public GGraphAbstract getCurrentGraph() {
        return this.view.getCurrentGraph();
    }

    public BufferedImage getImageOfView() {
        return this.view.getImage();
    }

    public void createPanel() {
        if (this.rule == null) {
            return;
        }
        if (this.rule.hasErrors()) {
            this.createErrorPanel();
        } else {
            this.createNormalPanel();
        }
    }

    public void createNormalPanel() {
        this.container.removeAll();
        this.container.add((Component)this.createVisualizationPane(), "Center");
        this.container.add((Component)this.createControlPane(), "South");
        this.container.validate();
    }

    public void createErrorPanel() {
        this.container.removeAll();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createErrorPane(), "North");
        jPanel.add((Component)this.createVisualizationPane(), "Center");
        this.container.add((Component)jPanel, "Center");
        this.container.add((Component)this.createControlPane(), "South");
        this.container.validate();
    }

    private Container createVisualizationPane() {
        this.view = new CustomGView(this, this.context);
        this.viewScrollPane = new JScrollPane(this.view);
        this.viewScrollPane.setWheelScrollingEnabled(true);
        return this.viewScrollPane;
    }

    private Container createErrorPane() {
        this.controlPanel = Toolbar.createHorizontalToolbar();
        if (this.rule.errors.size() > 1) {
            this.controlPanel.addElement(this.createPrevErrorButton());
            this.controlPanel.addElement(this.createNextErrorButton());
            this.controlPanel.addGroupSeparator();
        }
        this.controlPanel.addElement(new JLabel(IconManager.shared().getIconWarning()));
        this.errorLabel = new JTextField();
        this.controlPanel.addElement(this.errorLabel);
        this.errorLabel.setBorder(null);
        this.errorLabel.setEditable(false);
        this.errorLabel.setBackground(this.getContainer().getBackground());
        this.controlPanel.add(Box.createHorizontalGlue());
        this.pathButtonSelectionBox = new Box(0);
        this.controlPanel.addElement(this.pathButtonSelectionBox);
        this.controlPanel.addGroupSeparator();
        this.controlPanel.addElement(this.createShowCrossLinksButton());
        return this.controlPanel;
    }

    private JButton createPrevErrorButton() {
        JButton jButton = new JButton(IconManager.shared().getIconBackward());
        jButton.setFocusable(false);
        jButton.setToolTipText("Show Previous Error");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GPanel.this.view.setPrevGraph()) {
                    GPanel.this.view.refresh();
                    GPanel.this.createPathSelectionButtons();
                    GPanel.this.updateCurrentError();
                }
            }
        });
        return jButton;
    }

    private JButton createNextErrorButton() {
        JButton jButton = new JButton(IconManager.shared().getIconForward());
        jButton.setFocusable(false);
        jButton.setToolTipText("Show Next Error");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GPanel.this.view.setNextGraph()) {
                    GPanel.this.view.refresh();
                    GPanel.this.createPathSelectionButtons();
                    GPanel.this.updateCurrentError();
                }
            }
        });
        return jButton;
    }

    private void updateCurrentAlternative() {
        if (this.view.getCurrentGraph() instanceof GGraphGroup && this.pathButtonSelectionBox != null && this.pathButtonSelectionBox.getComponentCount() == 0) {
            this.createPathSelectionButtons();
        }
    }

    private void updateCurrentError() {
        if (this.rule == null || !this.rule.hasErrors()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.view.getGraphs().size();
        int n2 = this.view.getCurrentGraphIndex();
        if (n > 1) {
            stringBuffer.append("(");
            stringBuffer.append(n2 + 1);
            stringBuffer.append("/");
            stringBuffer.append(n);
            stringBuffer.append(") ");
        }
        stringBuffer.append(this.rule.getErrorMessageString(n2));
        this.errorLabel.setText(stringBuffer.toString());
        this.controlPanel.revalidate();
    }

    private void createPathSelectionButtons() {
        this.pathButtonSelectionBox.removeAll();
        if (!(this.view.getCurrentGraph() instanceof GGraphGroup)) {
            return;
        }
        GGraphGroup gGraphGroup = (GGraphGroup)this.view.getCurrentGraph();
        int n = gGraphGroup.pathGroup.getNumberOfPaths();
        if (n <= 1) {
            this.pathButtonSelectionBox.add(new JLabel("Alternative:"));
        } else {
            this.pathButtonSelectionBox.add(new JLabel("Alternatives:"));
        }
        for (int i = 0; i < n; ++i) {
            this.pathButtonSelectionBox.add(this.createPathSelectionButton(i));
        }
    }

    private JCheckBox createPathSelectionButton(int n) {
        JCheckBox jCheckBox = new JCheckBox(String.valueOf(n + 1));
        jCheckBox.setName(String.valueOf(n));
        jCheckBox.setFocusable(false);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                GGraphGroup gGraphGroup = (GGraphGroup)GPanel.this.view.getCurrentGraph();
                gGraphGroup.pathGroup.setPathVisible(Integer.parseInt(jCheckBox.getName()), jCheckBox.isSelected());
                gGraphGroup.pathGroup.makeSureCurrentPathIsVisible();
                GPanel.this.view.cacheRerender();
                GPanel.this.view.repaint();
            }
        });
        GGraphGroup gGraphGroup = (GGraphGroup)this.view.getCurrentGraph();
        jCheckBox.setSelected(gGraphGroup.pathGroup.isPathVisible(n));
        return jCheckBox;
    }

    private JButton createShowCrossLinksButton() {
        JButton jButton = new JButton(IconManager.shared().getIconShowLinks());
        jButton.setFocusable(false);
        jButton.setToolTipText("Show links between rules");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Object e : GPanel.this.view.getGraphs()) {
                    GGraphGroup gGraphGroup = (GGraphGroup)e;
                    gGraphGroup.pathGroup.toggleShowRuleLinks();
                }
                GPanel.this.view.cacheRerender();
                GPanel.this.view.repaint();
            }
        });
        return jButton;
    }

    private Container createControlPane() {
        Toolbar toolbar = Toolbar.createHorizontalToolbar();
        toolbar.addElement(new JLabel("Zoom"));
        toolbar.addElement(this.createFactorSlider());
        toolbar.addElement(this.createShowNFAButton());
        return toolbar;
    }

    private JSlider createFactorSlider() {
        JSlider jSlider = new JSlider();
        jSlider.setFocusable(false);
        jSlider.setMinimum(1);
        jSlider.setMaximum(800);
        jSlider.setValue((int)(this.context.getFactor() * 40.0f));
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                GPanel.this.context.setFactor((float)jSlider.getValue() / 40.0f);
                GPanel.this.view.refreshSizeChanged(jSlider.getValueIsAdjusting());
            }
        });
        return jSlider;
    }

    private JCheckBox createShowNFAButton() {
        JCheckBox jCheckBox = new JCheckBox("Show NFA");
        jCheckBox.setFocusable(false);
        jCheckBox.setSelected(this.context.skin instanceof NFASkin);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatisticsAW.shared().recordEvent(135);
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                if (jCheckBox.isSelected()) {
                    GPanel.this.context.setSkin(new NFASkin());
                } else {
                    GPanel.this.context.setSkin(new SDSkin());
                }
                GPanel.this.view.refresh();
            }
        });
        return jCheckBox;
    }

    public void notificationFire(Object object, String string) {
        if (string.equals("NOTIF_CURRENT_PATH_DID_CHANGE")) {
            this.updateCurrentAlternative();
        }
    }

    protected class CustomGView
    extends GView {
        public CustomGView(GPanel gPanel2, GContext gContext) {
            super(gPanel2, gContext);
        }

        public JPopupMenu getContextualMenu() {
            ContextualMenuFactory contextualMenuFactory = new ContextualMenuFactory(GPanel.this.editor.editorMenu);
            contextualMenuFactory.addItem(111);
            contextualMenuFactory.addItem(110);
            return contextualMenuFactory.menu;
        }
    }
}

