/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.graph;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.antlr.analysis.NFAState;
import org.antlr.works.visualization.fa.FAState;
import org.antlr.works.visualization.fa.FATransition;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.graph.GGraph;
import org.antlr.works.visualization.graphics.graph.GGraphAbstract;
import org.antlr.works.visualization.graphics.path.GPath;
import org.antlr.works.visualization.graphics.path.GPathElement;
import org.antlr.works.visualization.graphics.path.GPathGroup;
import org.antlr.works.visualization.graphics.primitive.GDimension;
import org.antlr.works.visualization.graphics.shape.GNode;
import org.antlr.works.visualization.serializable.SSerializable;
import org.antlr.works.visualization.skin.syntaxdiagram.SDSkin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GGraphGroup
extends GGraphAbstract {
    public static final int TITLE_OFFSET = 100;
    public GDimension dimension = new GDimension();
    public List<GGraph> graphs = new ArrayList<GGraph>();
    public GPathGroup pathGroup = new GPathGroup();
    protected GContext defaultContext = new GContext();
    protected int pathIndex;

    public GGraphGroup() {
        this.defaultContext.setSkin(new SDSkin());
    }

    @Override
    public void setEnable(boolean bl) {
    }

    @Override
    public void setContext(GContext gContext) {
        super.setContext(gContext);
        for (GGraph gGraph : this.graphs) {
            gGraph.setContext(gContext);
        }
        this.pathGroup.setContext(gContext);
    }

    public void add(GGraph gGraph) {
        this.dimension.maxWidth(gGraph.dimension.width);
        this.dimension.addUp(gGraph.dimension.up);
        this.dimension.addDown(gGraph.dimension.down);
        if (this.graphs.size() > 0) {
            this.dimension.addDown("L");
        }
        this.graphs.add(gGraph);
    }

    @Override
    public float getHeight() {
        return this.getDimension().getPixelHeight(this.context);
    }

    @Override
    public float getWidth() {
        return this.getDimension().getPixelWidth(this.context) + 100.0f;
    }

    public List<FATransition> getTransitionsMatchingSkippedStates(List<FATransition> list, List list2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Object object : list2) {
            arrayList.add(((NFAState)object).stateNumber);
        }
        ArrayList arrayList2 = new ArrayList();
        for (FATransition fATransition : list) {
            if (fATransition.skippedStates == null || !fATransition.skippedStates.containsAll(arrayList)) continue;
            arrayList2.add(fATransition);
        }
        return arrayList2;
    }

    public FATransition getNodeTransitionToNextNonSkippedState(GNode gNode, List list) {
        if (gNode == null) {
            return null;
        }
        List<FATransition> list2 = new ArrayList<FATransition>(gNode.state.transitions);
        FATransition fATransition = null;
        int n = this.pathIndex;
        block4: while (this.pathIndex < list.size()) {
            list2 = this.getTransitionsMatchingSkippedStates(list2, list.subList(n, this.pathIndex + 1));
            switch (list2.size()) {
                case 0: {
                    break block4;
                }
                case 1: {
                    fATransition = list2.get(0);
                    break;
                }
                default: {
                    if (this.pathIndex + 1 >= list.size()) break;
                    NFAState nFAState = (NFAState)list.get(this.pathIndex + 1);
                    for (FATransition fATransition2 : list2) {
                        if (fATransition2.target.stateNumber != nFAState.stateNumber) continue;
                        ++this.pathIndex;
                        return fATransition2;
                    }
                }
            }
            ++this.pathIndex;
        }
        return fATransition;
    }

    public void addNextElementInSameRule(List<GPathElement> list, GNode gNode, GNode gNode2) {
        list.add(GPathElement.createElement(gNode));
        FATransition fATransition = gNode.state.getTransitionToStateNumber(gNode2.state.stateNumber);
        if (fATransition == null) {
            fATransition = gNode2.state.getTransitionToStateNumber(gNode.state.stateNumber);
            if (fATransition == null) {
                list.add(GPathElement.createLink(gNode, gNode2));
            } else {
                list.add(GPathElement.createElement(gNode2.getLink(fATransition)));
            }
        } else {
            list.add(GPathElement.createElement(gNode.getLink(fATransition)));
        }
    }

    public void addNextElementInOtherRule(List<GPathElement> list, GNode gNode, GNode gNode2, GNode gNode3, NFAState nFAState) {
        FATransition fATransition;
        if (gNode2 == null && gNode.state.getFirstTransition() != null) {
            fATransition = gNode.state.getTransitionToExternalStateRule(nFAState.getEnclosingRule());
            if (fATransition == null) {
                System.err.println("[GGraphGroup] No transition to external state " + nFAState.stateNumber + "[" + nFAState.getEnclosingRule() + "] - using first transition by default");
                fATransition = gNode.state.getFirstTransition();
            }
            gNode2 = this.findNodeForStateNumber(fATransition.target.stateNumber);
        }
        if (gNode2 == null) {
            list.add(GPathElement.createElement(gNode));
            list.add(GPathElement.createLink(gNode, gNode3));
        } else {
            list.add(GPathElement.createElement(gNode));
            fATransition = gNode.state.getTransitionToStateNumber(gNode2.state.stateNumber);
            list.add(GPathElement.createElement(gNode.getLink(fATransition)));
            list.add(GPathElement.createElement(gNode2));
            list.add(GPathElement.createLink(gNode2, gNode3));
        }
    }

    public void addPath(List list, boolean bl, Map<Integer, FAState> map) {
        ArrayList<GPathElement> arrayList = new ArrayList<GPathElement>();
        NFAState nFAState = null;
        GNode gNode = null;
        this.pathIndex = 0;
        while (this.pathIndex < list.size()) {
            block12: {
                GNode gNode2;
                NFAState nFAState2;
                SSerializable sSerializable;
                block13: {
                    FATransition fATransition;
                    block14: {
                        FAState fAState;
                        block15: {
                            block11: {
                                if (this.pathIndex != 0) break block11;
                                nFAState = (NFAState)list.get(this.pathIndex);
                                gNode = this.findNodeForStateNumber(nFAState.stateNumber);
                                if (gNode == null) {
                                    sSerializable = map.get(nFAState.stateNumber);
                                    if (sSerializable == null) {
                                        System.err.println("[GGraphGroup] Starting path state " + nFAState.stateNumber + "[" + nFAState.getEnclosingRule() + "] cannot be found in the graph");
                                        return;
                                    }
                                    gNode = this.findNodeForStateNumber(sSerializable.stateNumber);
                                }
                                break block12;
                            }
                            nFAState2 = nFAState;
                            gNode2 = gNode;
                            nFAState = (NFAState)list.get(this.pathIndex);
                            gNode = this.findNodeForStateNumber(nFAState.stateNumber);
                            sSerializable = null;
                            if (gNode != null) break block13;
                            fATransition = this.getNodeTransitionToNextNonSkippedState(gNode2, list);
                            if (fATransition != null) break block14;
                            fAState = map.get(nFAState.stateNumber);
                            if (fAState != null) break block15;
                            gNode = gNode2;
                            break block12;
                        }
                        gNode = this.findNodeForStateNumber(fAState.stateNumber);
                        break block13;
                    }
                    if (this.pathIndex >= list.size()) {
                        gNode = this.findNodeForStateNumber(fATransition.target.stateNumber);
                    } else {
                        nFAState = (NFAState)list.get(this.pathIndex);
                        if (fATransition.target.stateNumber == nFAState.stateNumber) {
                            gNode = this.findNodeForStateNumber(fATransition.target.stateNumber);
                        } else {
                            sSerializable = this.findNodeForStateNumber(fATransition.target.stateNumber);
                            gNode = this.findNodeForStateNumber(nFAState.stateNumber);
                        }
                    }
                }
                if (nFAState2 != null && gNode2 != null && gNode != null) {
                    if (nFAState2.getEnclosingRule().equals(nFAState.getEnclosingRule())) {
                        this.addNextElementInSameRule(arrayList, gNode2, gNode);
                    } else {
                        this.addNextElementInOtherRule(arrayList, gNode2, (GNode)sSerializable, gNode, nFAState);
                    }
                }
            }
            ++this.pathIndex;
        }
        if (gNode != null) {
            arrayList.add(GPathElement.createElement(gNode));
        }
        this.pathGroup.addPath(new GPath(arrayList, bl));
    }

    public void addUnreachableAlt(NFAState nFAState, Integer n) {
        ArrayList<GPathElement> arrayList = new ArrayList<GPathElement>();
        GNode gNode = this.findNodeForStateNumber(nFAState.stateNumber);
        if (gNode == null) {
            System.err.println("[GGraphGroup] Decision state " + nFAState.stateNumber + "[" + nFAState.getEnclosingRule() + "] cannot be found in the graph");
            return;
        }
        List<FATransition> list = gNode.state.transitions;
        int n2 = n - 1;
        if (n2 >= list.size()) {
            System.err.println("[GGraphGroup] Unreachable alt " + n2 + "[" + nFAState.getEnclosingRule() + "] is out of bounds: " + list.size());
            return;
        }
        FATransition fATransition = list.get(n2);
        arrayList.add(GPathElement.createElement(gNode));
        arrayList.add(GPathElement.createElement(gNode.getLink(fATransition)));
        GPath gPath = new GPath(arrayList, true);
        gPath.setVisible(true);
        gPath.setSelectable(false);
        this.pathGroup.addPath(gPath);
    }

    public GNode findNodeForStateNumber(int n) {
        for (GGraph gGraph : this.graphs) {
            GNode gNode = gGraph.findNodeForStateNumber(n);
            if (gNode == null) continue;
            return gNode;
        }
        return null;
    }

    @Override
    public GDimension getDimension() {
        return this.dimension;
    }

    @Override
    public void render(float f, float f2) {
        f += 100.0f;
        for (int i = 0; i < this.graphs.size(); ++i) {
            GGraph gGraph = this.graphs.get(i);
            gGraph.render(f, f2);
            if (i >= this.graphs.size() - 1) continue;
            f2 += gGraph.getHeight() + this.context.getPixelLineSpace();
        }
        this.setRendered(true);
    }

    @Override
    public void draw() {
        this.context.nodeColor = Color.black;
        this.context.linkColor = Color.black;
        this.context.setLineWidth(1.0f);
        for (GGraph gGraph : this.graphs) {
            gGraph.draw();
            this.context.setColor(Color.black);
            this.context.drawString(this.context.getRuleFont(), gGraph.name, 95.0f, gGraph.offsetY, 2);
        }
        this.pathGroup.draw();
        if (this.context.drawdimension) {
            this.context.setLineWidth(1.0f);
            this.context.setColor(Color.lightGray);
            float f = this.getDimension().getPixelWidth(this.context);
            float f2 = this.getDimension().getPixelUp(this.context);
            float f3 = this.getDimension().getPixelDown(this.context);
            if (f2 + f3 > 0.0f) {
                this.context.drawRect(0.0f, 0.0f, f, f2 + f3, false);
            }
        }
    }
}

