/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.graph;

import java.awt.Color;
import java.awt.Point;
import java.util.List;
import org.antlr.analysis.NFAState;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.graph.GGraphAbstract;
import org.antlr.works.visualization.graphics.primitive.GDimension;
import org.antlr.works.visualization.graphics.shape.GLink;
import org.antlr.works.visualization.graphics.shape.GNode;
import org.antlr.works.visualization.serializable.SEncoder;
import org.antlr.works.visualization.serializable.SSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GGraph
extends GGraphAbstract
implements SSerializable {
    public GDimension dimension;
    public List<GNode> nodes;
    public String name;
    public float offsetX = 0.0f;
    public float offsetY = 0.0f;

    @Override
    public void setEnable(boolean bl) {
    }

    @Override
    public void setContext(GContext gContext) {
        super.setContext(gContext);
        for (GNode gNode : this.nodes) {
            gNode.setContext(gContext);
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDimension(GDimension gDimension) {
        this.dimension = gDimension;
    }

    public void setNodes(List<GNode> list) {
        this.nodes = list;
    }

    @Override
    public GDimension getDimension() {
        return this.dimension;
    }

    @Override
    public float getHeight() {
        return Math.max(this.getDimension().getPixelHeight(this.context), this.context.getPixelArrowHeight());
    }

    @Override
    public float getWidth() {
        return this.getDimension().getPixelWidth(this.context);
    }

    @Override
    public void render(float f, float f2) {
        f2 += this.getDimension().getPixelUp(this.context);
        for (GNode gNode : this.nodes) {
            gNode.render(f, f2);
        }
        this.offsetX = f;
        this.offsetY = f2;
        this.setRendered(true);
    }

    @Override
    public void draw() {
        this.context.nodeColor = Color.black;
        this.context.linkColor = Color.black;
        this.context.setLineWidth(1.0f);
        for (GNode gNode : this.nodes) {
            gNode.drawNodeAndLink();
        }
        if (this.context.drawdimension) {
            this.context.setColor(Color.lightGray);
            float f = this.getDimension().getPixelWidth(this.context);
            float f2 = this.getDimension().getPixelUp(this.context);
            float f3 = this.getDimension().getPixelDown(this.context);
            if (f2 + f3 > 0.0f) {
                this.context.drawRect(this.offsetX, this.offsetY - f2, f, f2 + f3, false);
            }
        }
    }

    public GLink findLinkAtPosition(int n, int n2) {
        for (GNode gNode : this.nodes) {
            for (GLink gLink : gNode.links) {
                if (!gLink.containsPoint(new Point(n, n2)) || gLink.transition.label == null) continue;
                return gLink;
            }
        }
        return null;
    }

    public GNode findNodeForStateNumber(int n) {
        for (GNode gNode : this.nodes) {
            if (gNode.state.stateNumber != n) continue;
            return gNode;
        }
        return null;
    }

    public boolean containsAtLeastOneState(List list) {
        for (GNode gNode : this.nodes) {
            for (Object e : list) {
                NFAState nFAState = (NFAState)e;
                if (!gNode.containsStateNumber(nFAState.stateNumber)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void encode(SEncoder sEncoder) {
        sEncoder.write(this.dimension);
        for (GNode gNode : this.nodes) {
            sEncoder.write(gNode);
        }
    }
}

