/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.works.visualization.fa.FAAnalysis;
import org.antlr.works.visualization.fa.FAState;
import org.antlr.works.visualization.fa.FATransition;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.graph.GGraph;
import org.antlr.works.visualization.graphics.primitive.GDimension;
import org.antlr.works.visualization.graphics.primitive.GPoint;
import org.antlr.works.visualization.graphics.shape.GLink;
import org.antlr.works.visualization.graphics.shape.GNode;
import org.antlr.works.visualization.serializable.SSerializable;

public class GRenderer {
    protected List<GNode> graphicNodes = new ArrayList<GNode>();
    protected FAAnalysis analysis = new FAAnalysis();
    protected Map<FAState, GNode> nodes = new HashMap<FAState, GNode>();
    protected Map<FAState, EOAInfo> endOfAlternativeInfoMap = new HashMap<FAState, EOAInfo>();

    public synchronized GGraph render(FAState fAState) {
        GGraph gGraph = new GGraph();
        gGraph.setDimension(this.renderSize(fAState));
        this.renderPosition(fAState);
        GNode gNode = this.graphicNodes.get(this.graphicNodes.size() - 1);
        if (gNode != null) {
            gNode.lastNodeOfRule = true;
        }
        gGraph.setNodes((ArrayList)((ArrayList)this.graphicNodes).clone());
        return gGraph;
    }

    public void renderPosition(FAState fAState) {
        this.recursiveRenderPositionNode(fAState, null, new GPoint());
    }

    public void recursiveRenderPositionNode(FAState fAState, FAState fAState2, GPoint gPoint) {
        while (fAState != fAState2) {
            GNode gNode = this.getNode(fAState);
            if (gNode == null) {
                System.err.println("Cannot find SDNode associated with state \"" + fAState + "\"");
                return;
            }
            gNode.setPosition(gPoint);
            if (fAState.isAlternative()) {
                fAState = this.recursiveRenderPositionAlternative(fAState, gPoint);
                gPoint.addX(gNode.nodeDimension.width + gNode.linkDimension.width);
                continue;
            }
            if (fAState.isSingle()) {
                gPoint.addX(gNode.nodeDimension.width + gNode.linkDimension.width);
                fAState = fAState.getNextFirstState();
                continue;
            }
            fAState = null;
        }
    }

    public FAState recursiveRenderPositionAlternative(FAState fAState, GPoint gPoint) {
        FAState fAState2 = this.alternativeEndState(fAState);
        GPoint gPoint2 = new GPoint(gPoint);
        gPoint2.addX("mw");
        GDimension gDimension = null;
        for (int i = 0; i < fAState.getNumberOfTransitions(); ++i) {
            FATransition fATransition = fAState.transition(i);
            GLink gLink = this.getNode(fAState).getLink(fATransition);
            if (i == 0) {
                gDimension = gLink.branchDim;
            }
            if (i > 0 && !fATransition.loop) {
                gPoint2.addY("L");
                gPoint2.addY(gLink.branchDim.up);
            }
            if (fATransition.target == fAState2) {
                if (fATransition.loop) {
                    GPoint gPoint3 = new GPoint(gPoint);
                    gPoint3.subY(gDimension.up);
                    gPoint3.subY(gLink.branchDim.down);
                    this.getNode(fAState).getLink(fATransition).setVirtualPosition(gPoint3);
                    continue;
                }
                this.getNode(fAState).getLink(fATransition).setVirtualPosition(gPoint2);
                gPoint2.addY(gLink.branchDim.down);
                continue;
            }
            this.recursiveRenderPositionNode(fATransition.target, fAState2, new GPoint(gPoint2));
            gPoint2.addY(gLink.branchDim.down);
        }
        return fAState2;
    }

    public GDimension renderSize(FAState fAState) {
        this.graphicNodes.clear();
        this.nodes.clear();
        this.endOfAlternativeInfoMap.clear();
        this.analysis.analyze(fAState);
        return this.recursiveRenderSizeSingle(fAState, null);
    }

    public GDimension recursiveRenderSizeSingle(FAState fAState, FAState fAState2) {
        GDimension gDimension = new GDimension();
        gDimension.addUp("y");
        gDimension.addDown("z");
        while (fAState != fAState2) {
            SSerializable sSerializable;
            if (fAState.isAlternative()) {
                sSerializable = this.recursiveRenderSizeAlternative(fAState);
                gDimension.addWidth("m" + ((GDimension)sSerializable).width);
                gDimension.maxUp(((GDimension)sSerializable).up);
                gDimension.maxDown(((GDimension)sSerializable).down);
                fAState = this.alternativeEndState(fAState);
                continue;
            }
            if (fAState.isSingle()) {
                EOAInfo eOAInfo;
                sSerializable = this.createNode(fAState);
                FATransition fATransition = fAState.getFirstTransition();
                if (fATransition.isEpsilon()) {
                    ((GNode)sSerializable).linkDimension.width = "w";
                    ((GNode)sSerializable).linkDimension.up = "u";
                    ((GNode)sSerializable).linkDimension.down = "d";
                } else {
                    ((GNode)sSerializable).linkDimension.width = GContext.getBoxWidth(fATransition.label);
                    ((GNode)sSerializable).linkDimension.up = "U";
                    ((GNode)sSerializable).linkDimension.down = "D";
                }
                gDimension.addWidth("m" + ((GNode)sSerializable).linkDimension.width);
                gDimension.maxUp(((GNode)sSerializable).linkDimension.up);
                gDimension.maxDown(((GNode)sSerializable).linkDimension.down);
                fAState = fATransition.target;
                GNode gNode = this.createNode(fAState);
                GLink gLink = new GLink();
                gLink.transition = fATransition;
                gLink.target = gNode;
                ((GNode)sSerializable).addLink(gLink);
                if (fAState != fAState2 || (eOAInfo = this.endOfAlternativeInfoMap.get(fAState)) == null) continue;
                gLink.setLast(eOAInfo.last);
                continue;
            }
            gDimension.addWidth("m");
            fAState = null;
        }
        return gDimension;
    }

    public GDimension recursiveRenderSizeAlternative(FAState fAState) {
        FAState fAState2 = this.alternativeEndState(fAState);
        GNode gNode = this.createNode(fAState);
        GDimension gDimension = gNode.linkDimension;
        gDimension.addWidth("w");
        GDimension gDimension2 = null;
        for (int i = 0; i < fAState.getNumberOfTransitions(); ++i) {
            GDimension gDimension3;
            boolean bl;
            FATransition fATransition = fAState.transition(i);
            GLink gLink = new GLink();
            gLink.transition = fATransition;
            gLink.target = this.createNode(fATransition.target);
            gNode.addLink(gLink);
            boolean bl2 = bl = i == fAState.getNumberOfTransitions() - 1;
            if (i == fAState.getNumberOfTransitions() - 2 && fAState.transition((int)(i + 1)).loop) {
                bl = true;
            }
            gLink.setLast(bl);
            if (fATransition.target == fAState2) {
                gDimension3 = new GDimension();
                gDimension3.addUp("u");
                gDimension3.addDown("d");
                if (fATransition.loop) {
                    gDimension3.addDown("L");
                }
                if (fATransition.loop) {
                    gLink.setBranchDimension(gDimension3);
                    gDimension.maxUp(gDimension2.up + gDimension3.up + gDimension3.down);
                    continue;
                }
                gLink.setBranchDimension(gDimension3);
                if (i == 0) {
                    gDimension2 = gDimension3;
                }
                gDimension.addDown(gDimension3.up);
                gDimension.addDown(gDimension3.down);
                continue;
            }
            this.endOfAlternativeInfoMap.put(fAState2, new EOAInfo(bl));
            gDimension3 = this.recursiveRenderSizeSingle(fATransition.target, fAState2);
            if ((i > 0 || i == 0 && !fAState.transition((int)1).loop) && !bl) {
                gDimension.addDown("L");
            }
            gLink.setBranchDimension(gDimension3);
            gDimension3.addWidth("w");
            gDimension.maxWidth(gDimension3.width);
            if (i == 0) {
                gDimension2 = gDimension3;
                gDimension.maxUp(gDimension3.up);
                gDimension.addDown(gDimension3.down);
                continue;
            }
            gDimension.addDown(gDimension3.up);
            gDimension.addDown(gDimension3.down);
        }
        return gDimension;
    }

    public GNode createNode(FAState fAState) {
        GNode gNode = this.getNode(fAState);
        if (gNode == null) {
            gNode = new GNode();
            gNode.setState(fAState);
            this.graphicNodes.add(gNode);
            this.nodes.put(fAState, gNode);
        }
        return gNode;
    }

    public GNode getNode(FAState fAState) {
        return this.nodes.get(fAState);
    }

    public FAState alternativeEndState(FAState fAState) {
        FATransition fATransition;
        int n = fAState.getNumberOfTransitions() - 1;
        FAState fAState2 = fAState;
        while ((fATransition = fAState2.getFirstTransition()) != null && (this.analysis.numberOfIncomingTransition(fAState2 = fATransition.target) <= 1 || (n -= this.analysis.numberOfIncomingTransition(fAState2) - 1) > 0)) {
            if (!fAState2.isAlternative()) continue;
            n += fAState2.getNumberOfTransitions() - 1;
        }
        return fAState2;
    }

    private class EOAInfo {
        public boolean last = false;

        public EOAInfo(boolean bl) {
            this.last = bl;
        }
    }
}

