/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.analysis.NFAState;
import org.antlr.tool.Grammar;
import org.antlr.works.grammar.EngineGrammar;
import org.antlr.works.grammar.EngineGrammarError;
import org.antlr.works.utils.Console;
import org.antlr.works.visualization.fa.FAFactory;
import org.antlr.works.visualization.fa.FAState;
import org.antlr.works.visualization.graphics.GRenderer;
import org.antlr.works.visualization.graphics.graph.GGraph;
import org.antlr.works.visualization.graphics.graph.GGraphGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GFactory {
    protected GRenderer renderer = new GRenderer();
    protected boolean optimize = true;
    protected Console console = null;

    public void setOptimize(boolean bl) {
        this.optimize = bl;
    }

    public void toggleNFAOptimization() {
        this.optimize = !this.optimize;
    }

    public void setConsole(Console console) {
        this.console = console;
    }

    public List buildGraphsForRule(EngineGrammar engineGrammar, String string, List<EngineGrammarError> list) throws Exception {
        if (engineGrammar == null) {
            return null;
        }
        if (list == null || list.size() == 0) {
            return Collections.singletonList(this.buildGraphsForRule(engineGrammar, string));
        }
        return this.buildGraphsForErrors(engineGrammar, string, list);
    }

    public GGraph buildGraphsForRule(EngineGrammar engineGrammar, String string) throws Exception {
        NFAState nFAState = engineGrammar.getRuleStartState(string);
        if (nFAState == null) {
            return null;
        }
        FAState fAState = new FAFactory(engineGrammar.getGrammarForRule(string)).buildNFA(nFAState, this.optimize);
        GGraph gGraph = this.renderer.render(fAState);
        gGraph.setName(string);
        return gGraph;
    }

    public List<GGraphGroup> buildGraphsForErrors(EngineGrammar engineGrammar, String string, List<EngineGrammarError> list) throws Exception {
        ArrayList<GGraphGroup> arrayList = new ArrayList<GGraphGroup>();
        for (EngineGrammarError engineGrammarError : list) {
            arrayList.add(this.buildGraphGroup(engineGrammar.getGrammarForRule(string), engineGrammarError));
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private GGraphGroup buildGraphGroup(Grammar grammar, EngineGrammarError engineGrammarError) {
        void var6_9;
        Object object;
        ArrayList<GGraph> arrayList = new ArrayList<GGraph>();
        FAFactory fAFactory = new FAFactory(grammar);
        for (String object3 : engineGrammarError.rules) {
            NFAState nFAState = grammar.getRuleStartState(object3);
            object = fAFactory.buildNFA(nFAState, this.optimize);
            GGraph gGraph = this.renderer.render((FAState)object);
            gGraph.setName(object3);
            arrayList.add(gGraph);
        }
        GGraphGroup gGraphGroup = new GGraphGroup();
        for (GGraph gGraph : arrayList) {
            if (!gGraph.containsAtLeastOneState(engineGrammarError.states)) continue;
            gGraphGroup.add(gGraph);
        }
        boolean bl = false;
        while (var6_9 < engineGrammarError.paths.size()) {
            List list = (List)engineGrammarError.paths.get((int)var6_9);
            object = engineGrammarError.pathsDisabled.get((int)var6_9);
            try {
                gGraphGroup.addPath(list, (Boolean)object, fAFactory.getSkippedStatesMap());
            }
            catch (Exception exception) {
                if (this.console == null) {
                    exception.printStackTrace();
                }
                this.console.print(exception);
            }
            ++var6_9;
        }
        for (Object[] objectArray : engineGrammarError.unreachableAlts) {
            gGraphGroup.addUnreachableAlt((NFAState)objectArray[0], (Integer)objectArray[1]);
        }
        if (engineGrammarError.paths.size() > 0) {
            gGraphGroup.pathGroup.setPathVisible(0, true);
        }
        return gGraphGroup;
    }
}

