/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.QuadCurve2D;
import org.antlr.works.visualization.graphics.GEngine;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.shape.SLinkArc;

public class GEngineGraphics
extends GEngine {
    SLinkArc link_arc = new SLinkArc();

    public Graphics2D getG2D() {
        return this.context.getGraphics2D();
    }

    public void setColor(Color color) {
        this.getG2D().setColor(color);
    }

    public Color getColor() {
        return this.getG2D().getColor();
    }

    public void setLineWidth(float f) {
        this.getG2D().setStroke(new BasicStroke(f));
    }

    public float getStringPixelWidth(Font font, String string) {
        this.getG2D().setFont(font);
        TextLayout textLayout = new TextLayout(string, this.getG2D().getFont(), this.getG2D().getFontRenderContext());
        return (float)textLayout.getBounds().getWidth();
    }

    public void drawLine(float f, float f2, float f3, float f4) {
        this.getG2D().drawLine((int)f, (int)f2, (int)f3, (int)f4);
    }

    public void drawArc(float f, float f2, float f3, float f4, int n, int n2) {
        this.getG2D().drawArc((int)f, (int)f2, (int)f3, (int)f4, n, n2);
    }

    public void drawCircle(float f, float f2, float f3) {
        this.getG2D().drawArc((int)(f - f3), (int)(f2 - f3), (int)(2.0f * f3), (int)(2.0f * f3), 0, 360);
    }

    public void drawRect(float f, float f2, float f3, float f4) {
        this.getG2D().drawRect((int)f, (int)f2, (int)f3, (int)f4);
    }

    public void drawRoundRect(float f, float f2, float f3, float f4, float f5, float f6) {
        this.getG2D().drawRoundRect((int)f, (int)f2, (int)f3, (int)f4, (int)f5, (int)f6);
    }

    public void drawOval(float f, float f2, float f3, float f4) {
        this.getG2D().drawOval((int)f, (int)f2, (int)f3, (int)f4);
    }

    public void fillRect(float f, float f2, float f3, float f4) {
        this.getG2D().fillRect((int)f, (int)f2, (int)f3, (int)f4);
    }

    public void fillOval(float f, float f2, float f3, float f4) {
        this.getG2D().fillOval((int)f, (int)f2, (int)f3, (int)f4);
    }

    public void fillCircle(float f, float f2, float f3) {
        this.getG2D().fillArc((int)(f - f3), (int)(f2 - f3), (int)(2.0f * f3), (int)(2.0f * f3), 0, 360);
    }

    public void drawRightArrow(float f, float f2, float f3, float f4) {
        int[] nArray = new int[]{(int)(f - f3), (int)f, (int)(f - f3)};
        int[] nArray2 = new int[]{(int)(f2 - f4), (int)f2, (int)(f2 + f4)};
        this.getG2D().drawPolygon(nArray, nArray2, 3);
        this.getG2D().fillPolygon(nArray, nArray2, 3);
    }

    public void drawUpArrow(float f, float f2, float f3, float f4) {
        int[] nArray = new int[]{(int)(f - f4), (int)f, (int)(f + f4)};
        int[] nArray2 = new int[]{(int)(f2 + f3), (int)f2, (int)(f2 + f3)};
        this.getG2D().drawPolygon(nArray, nArray2, 3);
        this.getG2D().fillPolygon(nArray, nArray2, 3);
    }

    public void drawDownArrow(float f, float f2, float f3, float f4) {
        int[] nArray = new int[]{(int)(f - f4), (int)f, (int)(f + f4)};
        int[] nArray2 = new int[]{(int)(f2 - f3), (int)f2, (int)(f2 - f3)};
        this.getG2D().drawPolygon(nArray, nArray2, 3);
        this.getG2D().fillPolygon(nArray, nArray2, 3);
    }

    public void drawString(Font font, String string, float f, float f2, int n) {
        this.getG2D().setFont(font);
        TextLayout textLayout = new TextLayout(string, font, this.getG2D().getFontRenderContext());
        float f3 = Float.MIN_VALUE;
        float f4 = Float.MIN_VALUE;
        switch (n) {
            case 0: {
                f3 = (float)((double)f - textLayout.getBounds().getWidth() * 0.5);
                f4 = (float)((double)f2 + textLayout.getBounds().getHeight() * 0.5);
                break;
            }
            case 1: {
                f3 = (float)((double)f - textLayout.getBounds().getWidth() * 0.5);
                f4 = f2;
                break;
            }
            case 2: {
                f3 = (float)((double)f - textLayout.getBounds().getWidth());
                f4 = (float)((double)f2 + textLayout.getBounds().getHeight() * 0.5);
            }
        }
        textLayout.draw(this.getG2D(), f3, f4 - 1.0f);
    }

    public void drawSpline(float f, float f2, float f3, float f4, float f5, float f6, float f7, boolean bl) {
        this.link_arc.setStart(f, f2);
        this.link_arc.setEnd(f3, f4);
        this.link_arc.setStartTangentOffset(f5);
        this.link_arc.setEndTangentOffset(f6);
        this.link_arc.setFlateness(f7);
        this.link_arc.setArrowVisible(bl);
        this.link_arc.update();
        this.link_arc.setColor(this.getG2D().getColor());
        this.link_arc.draw(this.getG2D());
    }

    public void drawArcConnector(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, boolean bl) {
        if (f > f3) {
            f7 *= -1.0f;
            f8 *= -1.0f;
        }
        float f9 = f3 - f7;
        float f10 = f9 - f8;
        Vector2D vector2D = new Vector2D(f9, f2);
        Vector2D vector2D2 = new Vector2D(f3, f4);
        Vector2D vector2D3 = vector2D.add(vector2D2.sub(vector2D).setLength(Math.abs(f8)));
        this.drawLine(f + f5, f2, f10, f2);
        this.drawSpline((float)vector2D3.x, (float)vector2D3.y, f3, f4, 0.0f, f6, 0.0f, bl);
        QuadCurve2D.Float float_ = new QuadCurve2D.Float();
        float_.setCurve(f10, f2, f9, f2, (float)vector2D3.x, (float)vector2D3.y);
        this.getG2D().draw(float_);
    }
}

