/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Stack;
import org.antlr.works.visualization.graphics.GContextProvider;
import org.antlr.works.visualization.graphics.GEngine;
import org.antlr.works.visualization.graphics.GObject;
import org.antlr.works.visualization.graphics.primitive.GLiteral;
import org.antlr.works.visualization.graphics.shape.GLink;
import org.antlr.works.visualization.graphics.shape.GNode;
import org.antlr.works.visualization.skin.Skin;

public class GContext {
    public static final String EPSILON_WIDTH = "w";
    public static final String EPSILON_UP = "u";
    public static final String EPSILON_DOWN = "d";
    public static final String BOX_WIDTH = "W";
    public static final String BOX_UP = "U";
    public static final String BOX_DOWN = "D";
    public static final String NODE_WIDTH = "m";
    public static final String NODE_UP = "y";
    public static final String NODE_DOWN = "z";
    public static final String CHAR_WIDTH = "c";
    public static final String LINE_SPACE = "L";
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_CENTER_UP = 1;
    public static final int ALIGN_RIGHT = 2;
    public Container container;
    public GContextProvider provider;
    public GEngine engine;
    public Skin skin;
    protected float value_factor = 3.2f;
    public int offsetX = 0;
    public int offsetY = 0;
    public boolean drawnode = false;
    public boolean drawdimension = false;
    public Stack<Color> colorStack = new Stack();
    public Color nodeColor = Color.black;
    public Color linkColor = Color.black;
    public Font boxFont = null;
    public Font titleFont = null;
    public Graphics2D g2d = null;

    public void setProvider(GContextProvider gContextProvider) {
        this.provider = gContextProvider;
    }

    public void clearCache() {
        this.boxFont = null;
        this.titleFont = null;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void setEngine(GEngine gEngine) {
        this.engine = gEngine;
        this.engine.setContext(this);
    }

    public void setGraphics2D(Graphics2D graphics2D) {
        this.g2d = graphics2D;
    }

    public Graphics2D getGraphics2D() {
        return this.g2d;
    }

    public void setSkin(Skin skin) {
        this.skin = skin;
    }

    public float getStartOffset() {
        return this.skin.getStartOffset(this);
    }

    public float getEndOffset() {
        return this.skin.getEndOffset(this);
    }

    public void setFactor(float f) {
        this.value_factor = f;
        this.clearCache();
    }

    public float getFactor() {
        return this.value_factor;
    }

    public float getPixelEpsilonUp() {
        return this.getPixelValue(EPSILON_UP);
    }

    public float getPixelEpsilonDown() {
        return this.getPixelValue(EPSILON_DOWN);
    }

    public float getPixelBoxWidth() {
        return this.getPixelValue(BOX_WIDTH);
    }

    public float getPixelBoxUp() {
        return this.getPixelValue(BOX_UP);
    }

    public float getPixelBoxDown() {
        return this.getPixelValue(BOX_DOWN);
    }

    public float getPixelBoxEdge() {
        return this.getPixelBoxWidth() / 6.0f;
    }

    public float getPixelLineSpace() {
        return this.getPixelValue(LINE_SPACE);
    }

    public float getPixelNodeWidth() {
        return this.getPixelValue(NODE_WIDTH);
    }

    public float getPixelArrowWidth() {
        return this.getPixelBoxWidth() / 8.0f;
    }

    public float getPixelArrowHeight() {
        return (this.getPixelBoxUp() + this.getPixelBoxDown()) / 10.0f;
    }

    public Font getBoxFont() {
        if (this.boxFont == null) {
            this.boxFont = new Font("Monospaced", 1, (int)(4.0f * this.value_factor));
        }
        return this.boxFont;
    }

    public Font getRuleFont() {
        if (this.titleFont == null) {
            this.titleFont = new Font("Monospaced", 1, (int)(4.0f * this.value_factor));
        }
        return this.titleFont;
    }

    public static String getBoxWidth(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length() + 2; ++i) {
            stringBuffer.append(CHAR_WIDTH);
        }
        return GLiteral.max(stringBuffer.toString(), BOX_WIDTH);
    }

    public float getPixelValue(String string) {
        if (string == null || string.length() == 0) {
            return 0.0f;
        }
        return GLiteral.evaluate(string, this.skin.getValuesMap()) * this.value_factor;
    }

    public void setColor(Color color) {
        this.engine.setColor(color);
    }

    public void pushColor(Color color) {
        this.colorStack.push(this.engine.getColor());
        this.setColor(color);
    }

    public void popColor() {
        this.setColor(this.colorStack.pop());
    }

    public Color getColorForLabel(String string) {
        if (this.provider == null) {
            return Color.black;
        }
        return this.provider.contextGetColorForLabel(string);
    }

    public void setLineWidth(float f) {
        this.engine.setLineWidth(f);
    }

    public void repaint() {
        this.container.repaint();
    }

    public void drawLine(float f, float f2, float f3, float f4) {
        this.engine.drawLine(f + (float)this.offsetX, f2 + (float)this.offsetY, f3 + (float)this.offsetX, f4 + (float)this.offsetY);
    }

    public void drawArc(float f, float f2, float f3, float f4, int n, int n2) {
        this.engine.drawArc(f + (float)this.offsetX, f2 + (float)this.offsetY, f3, f4, n, n2);
    }

    public void drawCircle(float f, float f2, float f3, boolean bl) {
        if (bl) {
            this.pushColor(Color.white);
            this.fillCircle(f, f2, f3);
            this.popColor();
        }
        this.engine.drawCircle(f + (float)this.offsetX, f2 + (float)this.offsetY, f3);
    }

    public void drawRect(float f, float f2, float f3, float f4, boolean bl) {
        if (bl) {
            this.pushColor(Color.white);
            this.fillRect(f, f2, f3, f4);
            this.popColor();
        }
        this.engine.drawRect(f + (float)this.offsetX, f2 + (float)this.offsetY, f3, f4);
    }

    public void drawRoundRect(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        if (bl) {
            this.pushColor(Color.white);
            this.fillRect(f, f2, f3, f4);
            this.popColor();
        }
        this.engine.drawRoundRect(f + (float)this.offsetX, f2 + (float)this.offsetY, f3, f4, f5, f6);
    }

    public void drawOval(float f, float f2, float f3, float f4, boolean bl) {
        if (bl) {
            this.pushColor(Color.white);
            this.fillOval(f, f2, f3, f4);
            this.popColor();
        }
        this.engine.drawOval(f + (float)this.offsetX, f2 + (float)this.offsetY, f3, f4);
    }

    public void fillRect(float f, float f2, float f3, float f4) {
        this.engine.fillRect(f + (float)this.offsetX, f2 + (float)this.offsetY, f3, f4);
    }

    public void fillOval(float f, float f2, float f3, float f4) {
        this.engine.fillOval(f + (float)this.offsetX, f2 + (float)this.offsetY, f3, f4);
    }

    public void fillCircle(float f, float f2, float f3) {
        this.engine.fillCircle(f + (float)this.offsetX, f2 + (float)this.offsetY, f3);
    }

    public void drawRightArrow(float f, float f2, float f3, float f4) {
        this.engine.drawRightArrow(f + (float)this.offsetX, f2 + (float)this.offsetY, f3, f4);
    }

    public void drawUpArrow(float f, float f2, float f3, float f4) {
        this.engine.drawUpArrow(f + (float)this.offsetX, f2 + (float)this.offsetY, f3, f4);
    }

    public void drawDownArrow(float f, float f2, float f3, float f4) {
        this.engine.drawDownArrow(f + (float)this.offsetX, f2 + (float)this.offsetY, f3, f4);
    }

    public void drawString(Font font, String string, float f, float f2, int n) {
        this.engine.drawString(font, string, f + (float)this.offsetX, f2 + (float)this.offsetY, n);
    }

    public void drawSpline(float f, float f2, float f3, float f4, float f5, float f6, float f7, boolean bl) {
        this.engine.drawSpline(f + (float)this.offsetX, f2 + (float)this.offsetY, f3 + (float)this.offsetX, f4 + (float)this.offsetY, f5, f6, f7, bl);
    }

    public void drawArcConnector(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, boolean bl) {
        this.engine.drawArcConnector(f + (float)this.offsetX, f2 + (float)this.offsetY, f3 + (float)this.offsetX, f4 + (float)this.offsetY, f5, f6, f7, f8, bl);
    }

    public void drawNode(GNode gNode) {
        this.skin.drawNode(gNode);
    }

    public void drawLink(GLink gLink) {
        this.skin.drawLink(gLink);
    }

    public boolean isObjectVisible(GObject gObject) {
        if (gObject instanceof GNode) {
            return this.skin.isNodeVisible();
        }
        if (gObject instanceof GLink) {
            return this.skin.isLinkVisible();
        }
        return false;
    }

    public boolean objectContainsPoint(GObject gObject, Point point) {
        if (!this.isObjectVisible(gObject)) {
            return false;
        }
        return this.skin.objectContainsPoint(gObject, new Point(point.x - this.offsetX, point.y - this.offsetY));
    }
}

