/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.fa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.analysis.NFAState;
import org.antlr.works.visualization.fa.FATransition;
import org.antlr.works.visualization.serializable.SEncoder;
import org.antlr.works.visualization.serializable.SSerializable;

public class FAState
implements SSerializable {
    public int stateNumber = -1;
    public boolean acceptedState = false;
    public String enclosingRuleName = null;
    public List<FATransition> transitions = new ArrayList<FATransition>();
    public String externalRuleRefName = null;
    public boolean loop = false;

    public FAState(int n) {
        this.stateNumber = n;
    }

    public FAState(NFAState nFAState) {
        this.stateNumber = nFAState.stateNumber;
        this.acceptedState = nFAState.isAcceptState();
        this.enclosingRuleName = nFAState.getEnclosingRule();
    }

    public FAState(String string) {
        this.externalRuleRefName = string;
    }

    public void addTransition(FATransition fATransition) {
        fATransition.setSourceState(this);
        this.transitions.add(fATransition);
        this.sortTransitions();
    }

    public void addTransition(FATransition fATransition, boolean bl) {
        fATransition.setSourceState(this);
        fATransition.setLoop(bl);
        this.transitions.add(fATransition);
        this.sortTransitions();
    }

    private void sortTransitions() {
        if (this.transitions.size() <= 1) {
            return;
        }
        for (int i = 0; i < this.transitions.size(); ++i) {
            FATransition fATransition = this.transitions.get(i);
            if (!fATransition.loop || i >= this.transitions.size() - 1) continue;
            Collections.swap(this.transitions, i, this.transitions.size() - 1);
            break;
        }
    }

    public FATransition getFirstTransition() {
        if (this.transitions.isEmpty()) {
            return null;
        }
        return this.transitions.get(0);
    }

    public FATransition transition(int n) {
        return this.transitions.get(n);
    }

    public int getNumberOfTransitions() {
        return this.transitions.size();
    }

    public FAState getNextFirstState() {
        return this.getFirstTransition().target;
    }

    public FATransition getTransitionToStateNumber(int n) {
        for (FATransition fATransition : this.transitions) {
            if (fATransition.target.stateNumber != n) continue;
            return fATransition;
        }
        return null;
    }

    public FATransition getTransitionToExternalStateRule(String string) {
        for (FATransition fATransition : this.transitions) {
            if (fATransition.target == null) continue;
            for (FATransition fATransition2 : fATransition.target.transitions) {
                if (fATransition2.label == null || !fATransition2.label.equals(string)) continue;
                return fATransition;
            }
        }
        return null;
    }

    public boolean isAlternative() {
        return this.getNumberOfTransitions() > 1;
    }

    public boolean isSingle() {
        return this.getNumberOfTransitions() == 1;
    }

    public int hashCode() {
        return this.stateNumber;
    }

    public boolean equals(Object object) {
        if (object instanceof FAState) {
            FAState fAState = (FAState)object;
            return this.stateNumber == fAState.stateNumber;
        }
        return false;
    }

    public String toString() {
        if (this.externalRuleRefName == null) {
            return String.valueOf(this.stateNumber);
        }
        return "<" + this.externalRuleRefName + ">";
    }

    public void encode(SEncoder sEncoder) {
        sEncoder.write(this.stateNumber);
        sEncoder.write(this.acceptedState);
        sEncoder.write(this.enclosingRuleName);
        for (FATransition fATransition : this.transitions) {
            sEncoder.write(fATransition);
        }
        sEncoder.write(this.externalRuleRefName);
        sEncoder.write(this.loop);
    }
}

