/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.fa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.Transition;
import org.antlr.tool.Grammar;
import org.antlr.works.visualization.fa.FAAnalysis;
import org.antlr.works.visualization.fa.FAState;
import org.antlr.works.visualization.fa.FATransition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FAFactory {
    protected Grammar g;
    protected boolean optimize;
    protected FAAnalysis analysis = new FAAnalysis();
    protected Map<NFAState, FAState> processedStates = new HashMap<NFAState, FAState>();
    protected Map<Integer, FAState> skippedStatesMap = new HashMap<Integer, FAState>();
    protected int newStateNumber = -2;

    public FAFactory(Grammar grammar) {
        this.g = grammar;
    }

    public FAState buildNFA(NFAState nFAState, boolean bl) {
        this.optimize = bl;
        return this.build(nFAState);
    }

    public Map<Integer, FAState> getSkippedStatesMap() {
        return this.skippedStatesMap;
    }

    public FAState build(NFAState nFAState) {
        this.processedStates.clear();
        this.analysis.analyze(nFAState);
        return this.buildRecursiveState(nFAState, new HashSet<NFAState>());
    }

    public FAState buildRecursiveState(NFAState nFAState, Set<NFAState> set) {
        if (this.processedStates.get(nFAState) != null) {
            FAState fAState = this.processedStates.get(nFAState);
            if (set.contains(nFAState)) {
                fAState.loop = true;
            }
            return fAState;
        }
        FAState fAState = new FAState(nFAState);
        this.processedStates.put(nFAState, fAState);
        set.add(nFAState);
        if (nFAState.isAcceptState()) {
            return fAState;
        }
        for (int i = 0; i < nFAState.getNumberOfTransitions(); ++i) {
            FAState fAState2 = fAState;
            Transition transition = nFAState.transition(i);
            NFAState nFAState2 = (NFAState)transition.target;
            if (this.targetStateIsInAnotherRule(transition)) {
                nFAState2 = this.targetStateOfTransition(transition);
                fAState2 = this.createRuleReferenceState(fAState2, transition, null);
            }
            if (transition.isEpsilon()) {
                this.buildRecursiveSkipState(fAState2, nFAState2, new HashSet<NFAState>(set), new ArrayList<Integer>());
                continue;
            }
            FAState fAState3 = this.buildRecursiveState(nFAState2, new HashSet<NFAState>(set));
            if (fAState3.loop) {
                fAState3.addTransition(new FATransition(transition.label.toString(this.g), fAState2), true);
                fAState3.loop = false;
                continue;
            }
            fAState2.addTransition(new FATransition(transition.label.toString(this.g), fAState3));
        }
        return fAState;
    }

    public void buildRecursiveSkipState(FAState fAState, NFAState nFAState, Set<NFAState> set, List<Integer> list) {
        if (this.canBeSkipped(nFAState)) {
            Integer n = nFAState.stateNumber;
            list.add(n);
            this.skippedStatesMap.put(n, fAState);
            for (int i = 0; i < nFAState.getNumberOfTransitions(); ++i) {
                Transition transition = nFAState.transition(i);
                if (this.targetStateIsInAnotherRule(transition)) {
                    NFAState nFAState2 = this.targetStateOfTransition(transition);
                    FAState fAState2 = this.createRuleReferenceState(fAState, transition, list);
                    this.buildRecursiveSkipState(fAState2, nFAState2, set, new ArrayList<Integer>(list));
                    continue;
                }
                this.buildRecursiveSkipState(fAState, (NFAState)transition.target, set, new ArrayList<Integer>(list));
            }
        } else {
            FAState fAState3 = this.buildRecursiveState(nFAState, set);
            if (fAState3.loop) {
                fAState3.addTransition(new FATransition(fAState, list), true);
                fAState3.loop = false;
            } else {
                fAState.addTransition(new FATransition(fAState3, list));
            }
        }
    }

    public boolean targetStateIsInAnotherRule(Transition transition) {
        return transition instanceof RuleClosureTransition;
    }

    public String nameOfExternalReferencedRule(Transition transition) {
        if (transition instanceof RuleClosureTransition) {
            RuleClosureTransition ruleClosureTransition = (RuleClosureTransition)transition;
            String string = this.g.getRuleName(ruleClosureTransition.getRuleIndex());
            return string;
        }
        return null;
    }

    public FAState createRuleReferenceState(FAState fAState, Transition transition, List<Integer> list) {
        FAState fAState2 = new FAState(this.newStateNumber--);
        fAState2.enclosingRuleName = fAState.enclosingRuleName;
        FATransition fATransition = new FATransition(fAState2, list);
        fAState.addTransition(fATransition);
        FAState fAState3 = new FAState(this.newStateNumber--);
        fAState3.enclosingRuleName = fAState.enclosingRuleName;
        FATransition fATransition2 = new FATransition(this.nameOfExternalReferencedRule(transition), fAState3);
        fATransition2.setExternalRuleRef(true);
        fAState2.addTransition(fATransition2);
        return fAState3;
    }

    public NFAState targetStateOfTransition(Transition transition) {
        NFAState nFAState;
        if (transition instanceof RuleClosureTransition) {
            RuleClosureTransition ruleClosureTransition = (RuleClosureTransition)transition;
            nFAState = ruleClosureTransition.getFollowState();
        } else {
            nFAState = (NFAState)transition.target;
        }
        return nFAState;
    }

    public boolean canBeSkipped(NFAState nFAState) {
        if (!this.optimize) {
            return false;
        }
        if (nFAState.stateNumber == 0) {
            return false;
        }
        if (nFAState.isAcceptState()) {
            return false;
        }
        if (nFAState.getDecisionNumber() > 0) {
            return false;
        }
        if (nFAState.endOfBlockStateNumber != -1) {
            return false;
        }
        if (this.analysis.numberOfIncomingTransition(nFAState) > 1) {
            return false;
        }
        return this.hasOneOrMoreEpsilonTransitionOnly(nFAState);
    }

    public boolean hasOneEpsilonTransitionOnly(NFAState nFAState) {
        return nFAState.getNumberOfTransitions() == 1 && nFAState.transition(0).isEpsilon();
    }

    public boolean hasOneOrMoreEpsilonTransitionOnly(NFAState nFAState) {
        for (int i = 0; i < nFAState.getNumberOfTransitions(); ++i) {
            Transition transition = nFAState.transition(i);
            if (transition.isEpsilon()) continue;
            return false;
        }
        return nFAState.getNumberOfTransitions() > 0;
    }

    public boolean hasMoreThanOneEpsilonTransitionOnly(NFAState nFAState) {
        for (int i = 0; i < nFAState.getNumberOfTransitions(); ++i) {
            Transition transition = nFAState.transition(i);
            if (transition.isEpsilon()) continue;
            return false;
        }
        return nFAState.getNumberOfTransitions() > 1;
    }

    public boolean isAlternativeTransitionEndingAtSameState(NFAState nFAState) {
        NFAState nFAState2 = this.endStateOfAlternative((NFAState)nFAState.transition((int)0).target);
        for (int i = 1; i < nFAState.getNumberOfTransitions(); ++i) {
            Transition transition = nFAState.transition(i);
            NFAState nFAState3 = this.endStateOfAlternative((NFAState)transition.target);
            if (nFAState2.equals(nFAState3)) continue;
            return false;
        }
        return true;
    }

    public NFAState endStateOfAlternative(NFAState nFAState) {
        int n = nFAState.endOfBlockStateNumber;
        NFAState nFAState2 = nFAState;
        while (nFAState2.stateNumber != n) {
            nFAState2 = (NFAState)nFAState2.transition((int)0).target;
        }
        return nFAState2;
    }
}

