/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.fa;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.Transition;
import org.antlr.works.visualization.fa.FAState;
import org.antlr.works.visualization.fa.FATransition;

public class FAAnalysis {
    private Set processedStates = new HashSet();
    private Map stateIncomingTransitionCount = new HashMap();

    public void reset() {
        this.processedStates.clear();
        this.stateIncomingTransitionCount.clear();
    }

    public void analyze(FAState fAState) {
        this.reset();
        this.recursiveAnalysis(fAState);
    }

    public void analyze(NFAState nFAState) {
        this.reset();
        this.recursiveAnalysis(nFAState);
    }

    public void recursiveAnalysis(NFAState nFAState) {
        if (this.processedStates.contains(nFAState)) {
            return;
        }
        this.processedStates.add(nFAState);
        for (int i = 0; i < nFAState.getNumberOfTransitions(); ++i) {
            Transition transition = nFAState.transition(i);
            this.addIncomingTransitionToState((NFAState)transition.target);
            this.recursiveAnalysis((NFAState)transition.target);
        }
    }

    public void recursiveAnalysis(FAState fAState) {
        if (this.processedStates.contains(fAState)) {
            return;
        }
        this.processedStates.add(fAState);
        for (int i = 0; i < fAState.getNumberOfTransitions(); ++i) {
            FATransition fATransition = fAState.transition(i);
            this.addIncomingTransitionToState(fATransition.target);
            this.recursiveAnalysis(fATransition.target);
        }
    }

    public void addIncomingTransitionToState(Object object) {
        Integer n = (Integer)this.stateIncomingTransitionCount.get(object);
        int n2 = 0;
        if (n != null) {
            n2 = n;
        }
        this.stateIncomingTransitionCount.put(object, new Integer(n2 + 1));
    }

    public int numberOfIncomingTransition(Object object) {
        Integer n = (Integer)this.stateIncomingTransitionCount.get(object);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (NFAState nFAState : this.stateIncomingTransitionCount.keySet()) {
            Integer n = (Integer)this.stateIncomingTransitionCount.get(nFAState);
            stringBuffer.append(nFAState.stateNumber + " = " + n + "\n");
        }
        return stringBuffer.toString();
    }
}

