/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.analysis.NFAState;
import org.antlr.works.ate.syntax.misc.ATEThread;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.works.utils.ErrorListener;
import org.antlr.works.visualization.Visual;
import org.antlr.works.visualization.graphics.GFactory;

public class VisualDrawing
extends ATEThread {
    protected Visual visual;
    protected GFactory factory = new GFactory();
    protected String text;
    protected ElementRule rule;
    protected String threadText;
    protected ElementRule threadRule;
    protected ElementRule threadLastProcessedRule;
    protected Map<ElementRule, List> cacheGraphs = new HashMap<ElementRule, List>();

    public VisualDrawing(Visual visual) {
        this.visual = visual;
        this.start();
    }

    public void stop() {
        super.stop();
        this.visual = null;
    }

    public void toggleNFAOptimization() {
        this.factory.toggleNFAOptimization();
        this.clearCacheGraphs();
    }

    public synchronized void setText(String string) {
        this.text = string;
        this.awakeThread(500);
    }

    public synchronized void setRule(ElementRule elementRule, boolean bl) {
        this.rule = elementRule;
        this.awakeThread(bl ? 0 : 500);
    }

    public synchronized void clearCacheGraphs() {
        this.cacheGraphs.clear();
    }

    public synchronized boolean refresh() {
        List list = this.cacheGraphs.get(this.threadLastProcessedRule);
        if (list == null || list.isEmpty()) {
            return false;
        }
        this.visual.panel.setRule(this.threadLastProcessedRule);
        this.visual.panel.setGraphs(list);
        this.visual.panel.update();
        return true;
    }

    public synchronized boolean threadShouldProcess() {
        return this.text != null || this.rule != null;
    }

    public synchronized void threadPrepareProcess() {
        this.threadText = this.text;
        this.threadRule = this.rule;
        this.text = null;
        this.rule = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadProcessText() {
        if (this.threadText == null) {
            return;
        }
        ErrorListener.getThreadInstance().setPrintToConsole(false);
        try {
            this.visual.getEngineGrammar().createGrammars();
        }
        catch (Exception exception) {
        }
        finally {
            this.clearCacheGraphs();
        }
    }

    private void threadProcessRule() throws Exception {
        if (this.threadRule == null) {
            return;
        }
        String string = null;
        ErrorListener.getThreadInstance().setPrintToConsole(false);
        if (this.visual.getEngineGrammar().hasGrammar()) {
            NFAState nFAState = null;
            try {
                nFAState = this.visual.getEngineGrammar().getRuleStartState(this.threadRule.name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (nFAState == null) {
                string = "Cannot display rule \"" + this.threadRule + "\" because start state not found";
            }
        } else {
            string = "Cannot display rule \"" + this.threadRule + "\" because grammar cannot be generated";
        }
        if (string != null) {
            this.visual.setPlaceholder(string);
            return;
        }
        this.createGraphsForRule(this.threadRule);
        this.threadLastProcessedRule = this.threadRule;
        this.refresh();
    }

    protected synchronized void createGraphsForRule(ElementRule elementRule) throws Exception {
        List list = this.cacheGraphs.get(elementRule);
        if (list == null) {
            this.factory.setOptimize(!AWPrefs.getDebugDontOptimizeNFA());
            this.factory.setConsole(this.visual.getConsole());
            list = this.factory.buildGraphsForRule(this.visual.getEngineGrammar(), elementRule.name, elementRule.errors);
            if (list != null) {
                this.cacheGraphs.put(elementRule, list);
            }
        }
    }

    public void threadReportException(Exception exception) {
        this.visual.getConsole().print(exception);
    }

    public void threadRun() throws Exception {
        this.visual.getConsole().setMode(2);
        if (this.threadShouldProcess()) {
            this.threadPrepareProcess();
            this.threadProcessText();
            this.threadProcessRule();
        }
    }
}

