/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.image.BufferedImage;
import org.antlr.works.Console;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.editor.EditorTab;
import org.antlr.works.grammar.EngineGrammar;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.syntax.GrammarSyntaxEngine;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.works.visualization.VisualDrawing;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.GContextProvider;
import org.antlr.works.visualization.graphics.GEngineGraphics;
import org.antlr.works.visualization.graphics.graph.GGraphAbstract;
import org.antlr.works.visualization.graphics.panel.GPanel;
import org.antlr.works.visualization.skin.Skin;
import org.antlr.works.visualization.skin.syntaxdiagram.SDSkin;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJFileChooser;

public class Visual
extends EditorTab
implements GContextProvider {
    protected CEditorGrammar editor;
    protected VisualDrawing drawing;
    protected GContext context;
    protected Skin skin;
    protected GPanel panel;
    protected boolean enable = true;

    public Visual(CEditorGrammar cEditorGrammar) {
        this.editor = cEditorGrammar;
        this.skin = new SDSkin();
        this.context = new GContext();
        this.context.setEngine(new GEngineGraphics());
        this.context.setSkin(this.skin);
        this.context.setProvider(this);
        this.panel = new GPanel(cEditorGrammar, this.context);
        this.drawing = new VisualDrawing(this);
    }

    public org.antlr.works.utils.Console getConsole() {
        return this.editor.getConsole();
    }

    public void close() {
        this.panel.close();
        this.drawing.stop();
        long l = System.currentTimeMillis();
        while (this.drawing.isRunning() && System.currentTimeMillis() - l < 5000L) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.editor = null;
        this.context.setProvider(null);
    }

    public void setEnable(boolean bl) {
        this.enable = bl;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void toggleNFAOptimization() {
        this.drawing.toggleNFAOptimization();
    }

    public Color contextGetColorForLabel(String string) {
        if (string.charAt(0) == '\'' || string.charAt(0) == '\"') {
            return AWPrefs.getSyntaxColor("PREF_SYNTAX_STRING");
        }
        if (ATEToken.isLexerName(string)) {
            return GrammarSyntaxEngine.COLOR_LEXER;
        }
        return GrammarSyntaxEngine.COLOR_PARSER;
    }

    public void setText(String string, String string2) {
        if (this.isEnable()) {
            this.drawing.setText(string);
        }
    }

    public void setRule(ElementRule elementRule, boolean bl) {
        if (this.isEnable()) {
            this.drawing.setRule(elementRule, bl);
        }
    }

    public void setPlaceholder(String string) {
        this.panel.setPlaceholder(string);
        this.panel.setGraphs(null);
    }

    public void cancelDrawingProcess() {
        this.drawing.skip();
    }

    public void clearCacheGraphs() {
        this.drawing.clearCacheGraphs();
    }

    public void createGraphsForRule(ElementRule elementRule) throws Exception {
        this.drawing.createGraphsForRule(elementRule);
    }

    public boolean update() {
        this.panel.createPanel();
        return this.drawing.refresh();
    }

    public EngineGrammar getEngineGrammar() {
        return this.editor.getEngineGrammar();
    }

    public Container getContainer() {
        return this.panel.getContainer();
    }

    public GGraphAbstract getCurrentGraph() {
        return this.panel.getCurrentGraph();
    }

    public boolean canSaveImage() {
        return this.getImage() != null;
    }

    public BufferedImage getImage() {
        return this.panel.getImageOfView();
    }

    public boolean canExportToBitmap() {
        return true;
    }

    public boolean canExportToEPS() {
        return true;
    }

    public String getTabName() {
        return "Syntax Diagram";
    }

    public Component getTabComponent() {
        return this.getContainer();
    }

    public void serializeSyntaxDiagram() {
        XJFileChooser xJFileChooser = XJFileChooser.shared();
        if (xJFileChooser.displaySaveDialog((Component)this.editor.getJavaContainer(), "txt", "XML representation", false)) {
            String[] stringArray = new String[]{"-f", this.editor.getFilePath(), "-serialize", xJFileChooser.getSelectedFilePath(), "-verbose"};
            try {
                Console.main(stringArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                XJAlert.display(this.editor.getJavaContainer(), "Serialize Syntax Diagram", exception.toString());
            }
        }
    }
}

