/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.grammar.EngineGrammar;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.syntax.GrammarSyntaxEngine;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.GContextProvider;
import org.antlr.works.visualization.graphics.GEngineGraphics;
import org.antlr.works.visualization.graphics.GEnginePS;
import org.antlr.works.visualization.graphics.GFactory;
import org.antlr.works.visualization.graphics.graph.GGraph;
import org.antlr.works.visualization.serializable.SEncoder;
import org.antlr.works.visualization.skin.syntaxdiagram.SDSkin;
import org.antlr.xjlib.foundation.XJUtils;

public class SDGenerator
implements GContextProvider {
    public EngineGrammar engineGrammar;
    public GContext context;

    public SDGenerator(EngineGrammar engineGrammar) {
        this.engineGrammar = engineGrammar;
        this.context = new GContext();
        this.context.setSkin(new SDSkin());
        this.context.setProvider(this);
    }

    public void serializeRule(String string, SEncoder sEncoder) throws Exception {
        GGraph gGraph = this.createGraph(string);
        sEncoder.write(gGraph);
    }

    public void renderRuleToEPSFile(String string, String string2) throws Exception {
        GGraph gGraph = this.createGraph(string);
        GEnginePS gEnginePS = new GEnginePS();
        this.context.setEngine(gEnginePS);
        gGraph.draw();
        XJUtils.writeStringToFile(gEnginePS.getPSText(), string2);
    }

    public void renderRuleToBitmapFile(String string, String string2, String string3) throws Exception {
        GGraph gGraph = this.createGraph(string);
        int n = (int)(gGraph.getWidth() + 1.0f);
        int n2 = (int)(gGraph.getHeight() + 1.0f);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.context.setEngine(new GEngineGraphics());
        this.context.setGraphics2D(graphics2D);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        gGraph.draw();
        graphics2D.dispose();
        ImageIO.write((RenderedImage)bufferedImage, string2, new File(string3));
    }

    private GGraph createGraph(String string) throws Exception {
        GGraph gGraph = new GFactory().buildGraphsForRule(this.engineGrammar, string);
        gGraph.setContext(this.context);
        gGraph.render(0.0f, 0.0f);
        return gGraph;
    }

    public Color contextGetColorForLabel(String string) {
        if (string.charAt(0) == '\'' || string.charAt(0) == '\"') {
            return AWPrefs.getSyntaxColor("PREF_SYNTAX_STRING");
        }
        if (ATEToken.isLexerName(string)) {
            return GrammarSyntaxEngine.COLOR_LEXER;
        }
        return GrammarSyntaxEngine.COLOR_PARSER;
    }
}

