/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.utils;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import org.antlr.works.utils.TextPaneDelegate;

public class TextPane
extends JTextPane {
    protected TextPaneDelegate delegate = null;
    protected boolean wrap = false;

    public void setDelegate(TextPaneDelegate textPaneDelegate) {
        this.delegate = textPaneDelegate;
    }

    public void setWordWrap(boolean bl) {
        this.wrap = bl;
    }

    public boolean getWordWrap() {
        return this.wrap;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (!this.wrap) {
            Container container = this.getParent();
            return container == null || this.getUI().getPreferredSize((JComponent)this).width < container.getSize().width;
        }
        return super.getScrollableTracksViewportWidth();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (!this.wrap) {
            Dimension dimension = this.getPreferredSize();
            super.setBounds(n, n2, Math.max(dimension.width, n3), Math.max(dimension.height, n4));
        } else {
            super.setBounds(n, n2, n3, n4);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.delegate != null) {
            this.delegate.textPaneDidPaint(graphics);
        }
    }

    public int getTextIndexAtLocation(Point point) {
        int n = this.viewToModel(point);
        try {
            Rectangle rectangle = this.modelToView(n);
            if (point.x <= rectangle.x) {
                return n - 1;
            }
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
        return n;
    }
}

