/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.antlr.works.utils.StreamWatcherDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamWatcher
extends Thread {
    protected InputStream is;
    protected String type;
    protected StreamWatcherDelegate delegate;
    protected List<String> lines;

    public StreamWatcher(InputStream inputStream, String string, StreamWatcherDelegate streamWatcherDelegate) {
        this.is = inputStream;
        this.type = string;
        this.delegate = streamWatcherDelegate;
        this.lines = new ArrayList<String>();
    }

    public List<String> getLines() {
        return this.lines;
    }

    @Override
    public void run() {
        try {
            String string;
            if (this.delegate != null) {
                this.delegate.streamWatcherDidStarted();
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.is));
            while ((string = bufferedReader.readLine()) != null) {
                this.lines.add(string);
                if (this.delegate == null) continue;
                this.delegate.streamWatcherDidReceiveString(string + "\n");
            }
        }
        catch (IOException iOException) {
            if (this.delegate != null) {
                this.delegate.streamWatcherException(iOException);
            }
            iOException.printStackTrace();
        }
    }
}

