/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.utils;

import java.awt.Container;
import java.io.IOException;
import java.util.Calendar;
import org.antlr.works.dialog.DialogReports;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.Localizable;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.update.XJUpdateManager;
import org.antlr.xjlib.appkit.utils.BrowserLauncher;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.foundation.XJSystem;
import org.antlr.xjlib.foundation.XJUtils;
import org.antlr.xjlib.foundation.timer.XJScheduledTimerDelegate;

public class HelpManager
implements XJScheduledTimerDelegate {
    public void scheduledTimerFired(boolean bl) {
        HelpManager.checkUpdatesAuto(bl);
    }

    public static void submitStats(Container container) {
        new DialogReports(container, true).runModal();
    }

    public static void sendFeedback(Container container) {
        StringBuffer stringBuffer = new StringBuffer(Localizable.getLocalizedString("FeedbackURL"));
        stringBuffer.append("?ANTLRVersion=");
        stringBuffer.append(XJUtils.encodeToURL("3.0.1"));
        stringBuffer.append("&StringTemplateVersion=");
        stringBuffer.append(XJUtils.encodeToURL("3.1b1"));
        stringBuffer.append("&ANTLRWorksVersion=");
        stringBuffer.append(XJUtils.encodeToURL(XJApplication.getAppVersionShort()));
        stringBuffer.append("&OS=");
        stringBuffer.append(XJUtils.encodeToURL(XJSystem.getOSName()));
        stringBuffer.append("&JavaVersion=");
        stringBuffer.append(XJUtils.encodeToURL(XJSystem.getJavaRuntimeVersion()));
        try {
            BrowserLauncher.openURL(stringBuffer.toString());
        }
        catch (IOException iOException) {
            XJAlert.display(container, "Error", "Cannot display the feedback page because:\n" + iOException + "\n\nTo report a feedback, go to " + stringBuffer + ".");
        }
    }

    public static void checkUpdates(Container container, boolean bl) {
        String string = XJSystem.isMacOS() ? Localizable.getLocalizedString("UpdateOSXXMLURL") : Localizable.getLocalizedString("UpdateXMLURL");
        XJUpdateManager xJUpdateManager = new XJUpdateManager(container, null);
        xJUpdateManager.checkForUpdates(Localizable.getLocalizedString("AppVersionShort"), string, AWPrefs.getDownloadPath(), bl);
    }

    public static void checkUpdatesAuto(boolean bl) {
        int n = AWPrefs.getUpdateType();
        boolean bl2 = false;
        if (n == 0) {
            bl2 = false;
        } else if (n == 1 && bl) {
            bl2 = true;
        } else {
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = AWPrefs.getUpdateNextDate();
            if (calendar2 == null || calendar.equals(calendar2) || calendar.after(calendar2)) {
                switch (n) {
                    case 2: {
                        bl2 = calendar2 != null;
                        calendar.add(5, 1);
                        AWPrefs.setUpdateNextDate(calendar);
                        break;
                    }
                    case 3: {
                        bl2 = calendar2 != null;
                        calendar.add(5, 7);
                        AWPrefs.setUpdateNextDate(calendar);
                    }
                }
            }
        }
        if (bl2) {
            HelpManager.checkUpdates(null, true);
        }
    }
}

