/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.utils;

import java.util.LinkedList;
import java.util.List;
import org.antlr.analysis.DecisionProbe;
import org.antlr.tool.ANTLRErrorListener;
import org.antlr.tool.Message;
import org.antlr.tool.ToolMessage;
import org.antlr.works.editor.EditorConsole;

public class ErrorListener
implements ANTLRErrorListener {
    private static ThreadLocal<ErrorListener> threadLocalListener = new ThreadLocal();
    public List<String> infos = new LinkedList<String>();
    public List<Message> errors = new LinkedList<Message>();
    public List<Message> warnings = new LinkedList<Message>();
    public boolean printToConsole = true;
    public ErrorListener forwardListener = null;

    public static synchronized ErrorListener getThreadInstance() {
        if (threadLocalListener.get() == null) {
            threadLocalListener.set(new ErrorListener());
        }
        return threadLocalListener.get();
    }

    public void setPrintToConsole(boolean bl) {
        this.printToConsole = bl;
    }

    public void setForwardListener(ErrorListener errorListener) {
        this.forwardListener = errorListener;
    }

    public void clear() {
        this.infos.clear();
        this.errors.clear();
        this.warnings.clear();
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    public String getFirstErrorMessage() {
        if (this.hasErrors()) {
            return this.errors.get(0).toString();
        }
        return null;
    }

    public void info(String string) {
        this.infos.add(string);
        if (this.forwardListener != null) {
            this.forwardListener.info(string);
        }
        this.print(string, 0);
    }

    public void error(Message message) {
        this.errors.add(message);
        if (this.forwardListener != null) {
            this.forwardListener.error(message);
        }
        this.print(message.toString(), 2);
    }

    public void warning(Message message) {
        this.warnings.add(message);
        if (this.forwardListener != null) {
            this.forwardListener.warning(message);
        }
        this.print(message.toString(), 1);
    }

    public void error(ToolMessage toolMessage) {
        this.errors.add(toolMessage);
        if (this.forwardListener != null) {
            this.forwardListener.error(toolMessage);
        }
        this.print(toolMessage.toString(), 2);
    }

    public void print(String string, int n) {
        if (!this.printToConsole) {
            return;
        }
        boolean bl = DecisionProbe.verbose;
        DecisionProbe.verbose = false;
        try {
            EditorConsole.getCurrent().println(string, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        DecisionProbe.verbose = bl;
    }
}

