/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.tooltip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextLayout;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.antlr.works.tooltip.ToolTipListDelegate;

public class ToolTipList
extends JPanel {
    protected static final int VISIBLE_TIPS = 10;
    protected static final Color BACKGROUND_COLOR = new Color(1.0f, 1.0f, 0.6f, 0.8f);
    protected DefaultListModel tipsModel;
    protected JList tipsList;
    protected JScrollPane tipsScrollPane;
    protected ToolTipListDelegate delegate;

    public ToolTipList(ToolTipListDelegate toolTipListDelegate) {
        super(new BorderLayout());
        this.delegate = toolTipListDelegate;
        this.tipsModel = new DefaultListModel();
        this.tipsList = new JList(this.tipsModel);
        this.tipsList.setSelectionMode(0);
        this.tipsList.setBackground(BACKGROUND_COLOR);
        this.tipsList.setSelectionForeground(Color.black);
        this.tipsList.setSelectionBackground(BACKGROUND_COLOR);
        this.tipsList.setPrototypeCellValue("This is a rule name g");
        this.tipsList.addKeyListener(new MyListKeyAdapter());
        this.tipsList.setFocusable(false);
        this.tipsScrollPane = new JScrollPane(this.tipsList, 20, 31);
        this.tipsScrollPane.setFocusable(false);
        this.tipsScrollPane.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.addMouseListener(new MyMouseAdapter());
        this.add((Component)this.tipsScrollPane, "Center");
    }

    protected void notifyHide() {
        if (this.delegate != null) {
            this.delegate.toolTipListHide();
        }
    }

    public void clear() {
        this.tipsModel.clear();
    }

    public void setText(String string) {
        String[] stringArray = string.split("\n");
        this.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addLine(stringArray[i]);
        }
    }

    public void addLine(String string) {
        this.tipsModel.addElement(string);
    }

    public void selectFirstLine() {
        this.tipsList.setSelectedIndex(0);
    }

    public void resize() {
        int n = this.tipsList.getFixedCellHeight();
        int n2 = this.tipsModel.size();
        if (n2 > 0) {
            int n3 = 0;
            for (int i = 0; i < this.tipsModel.size(); ++i) {
                String string = (String)this.tipsModel.getElementAt(i);
                TextLayout textLayout = new TextLayout(string, this.tipsList.getFont(), ((Graphics2D)this.tipsList.getGraphics()).getFontRenderContext());
                n3 = Math.max(n3, (int)textLayout.getBounds().getWidth());
            }
            n = n * Math.min(10, n2) + 5;
            Dimension dimension = new Dimension(n3 + 10, n);
            this.setSize(dimension);
            this.tipsList.setSize(dimension);
            this.tipsScrollPane.setSize(dimension);
        }
    }

    protected class MyListKeyAdapter
    extends KeyAdapter {
        protected MyListKeyAdapter() {
        }

        public void selectNextListElement(int n) {
            int n2 = ToolTipList.this.tipsList.getSelectedIndex();
            n2 += n;
            n2 = Math.min(Math.max(0, n2), ToolTipList.this.tipsModel.size() - 1);
            ToolTipList.this.tipsList.setSelectedIndex(n2);
            ToolTipList.this.tipsList.scrollRectToVisible(ToolTipList.this.tipsList.getCellBounds(n2, n2));
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            switch (keyEvent.getKeyCode()) {
                case 10: 
                case 27: {
                    ToolTipList.this.notifyHide();
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    this.selectNextListElement(-1);
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    this.selectNextListElement(1);
                    keyEvent.consume();
                }
            }
        }
    }

    protected class MyMouseAdapter
    extends MouseAdapter {
        protected MyMouseAdapter() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ToolTipList.this.notifyHide();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ToolTipList.this.notifyHide();
        }
    }
}

