/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.tips;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.antlr.works.tooltip.ToolTipList;
import org.antlr.works.tooltip.ToolTipListDelegate;
import org.antlr.works.utils.OverlayObject;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TipsOverlay
extends OverlayObject
implements ToolTipListDelegate {
    protected ToolTipList toolTip;
    protected Point location;

    public TipsOverlay(XJFrameInterface xJFrameInterface, JComponent jComponent) {
        super(xJFrameInterface, jComponent);
    }

    public void setTips(List<String> list) {
        this.toolTip.clear();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.toolTip.addLine(iterator.next());
        }
        this.toolTip.selectFirstLine();
    }

    public void setLocation(Point point) {
        this.location = point;
        this.resize();
    }

    @Override
    public JComponent overlayCreateInterface() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.toolTip = new ToolTipList(this);
        jPanel.add((Component)this.toolTip, "Center");
        return jPanel;
    }

    @Override
    public void resize() {
        this.toolTip.resize();
        if (this.location != null) {
            this.content.setBounds(this.location.x, this.location.y, this.toolTip.getWidth(), this.toolTip.getHeight());
        }
    }

    @Override
    public boolean overlayWillDisplay() {
        return true;
    }

    @Override
    public void toolTipListHide() {
        this.hide();
    }
}

