/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.tips;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.antlr.works.tips.TipsOverlay;
import org.antlr.works.tips.TipsProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TipsManager {
    protected List<TipsProvider> providers = new ArrayList<TipsProvider>();
    protected TipsOverlay overlay;
    protected int lastPosition;
    protected boolean enabled = true;

    public void setOverlay(TipsOverlay tipsOverlay) {
        this.overlay = tipsOverlay;
    }

    public void addProvider(TipsProvider tipsProvider) {
        this.providers.add(tipsProvider);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!this.enabled) {
            this.hide();
        }
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void displayAnyTipsAvailable(int n, Point point) {
        if (!this.enabled) {
            return;
        }
        if (point == null) {
            this.hide();
            return;
        }
        if (n == this.lastPosition) {
            return;
        }
        this.lastPosition = n;
        List<String> list = this.generateTips(n);
        if (list == null || list.isEmpty()) {
            this.hide();
        } else {
            this.overlay.setTips(list);
            this.overlay.setLocation(point);
            this.overlay.display();
        }
    }

    public void hide() {
        this.overlay.hide();
        this.lastPosition = -1;
    }

    public List<String> generateTips(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TipsProvider tipsProvider : this.providers) {
            List<String> list = tipsProvider.tipsProviderGetTips(n);
            if (list == null || list.isEmpty()) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public void close() {
        this.overlay.close();
    }
}

