/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.syntax.element;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.antlr.works.ate.breakpoint.ATEBreakpointEntity;
import org.antlr.works.ate.folding.ATEFoldingEntity;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.editor.EditorPersistentObject;
import org.antlr.works.grammar.EngineGrammarError;
import org.antlr.works.syntax.GrammarSyntaxParser;
import org.antlr.works.syntax.element.ElementAction;
import org.antlr.works.syntax.element.ElementBlock;
import org.antlr.works.syntax.element.ElementReference;
import org.antlr.works.syntax.element.ElementScopable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementRule
extends ElementScopable
implements Comparable,
EditorPersistentObject,
ATEFoldingEntity,
ATEBreakpointEntity {
    public String name;
    public ATEToken start;
    public ATEToken colon;
    public ATEToken end;
    public boolean ignored = false;
    public boolean expanded = true;
    public boolean breakpoint = false;
    public boolean lexer = false;
    public boolean hasLeftRecursion = false;
    public boolean leftRecursionAnalyzed = false;
    public Set leftRecursiveRulesSet;
    public List<EngineGrammarError> errors;
    public boolean needsToBuildErrors = true;
    protected GrammarSyntaxParser parser;
    protected int refsStartIndex = -1;
    protected int refsEndIndex = -1;
    protected int blocksStartIndex = -1;
    protected int blocksEndIndex = -1;
    protected int actionsStartIndex = -1;
    protected int actionsEndIndex = -1;

    public ElementRule(String string) {
        this.name = string;
        this.lexer = ATEToken.isLexerName(string);
    }

    public ElementRule(GrammarSyntaxParser grammarSyntaxParser, String string, ATEToken aTEToken, ATEToken aTEToken2, ATEToken aTEToken3) {
        this.parser = grammarSyntaxParser;
        this.name = string;
        this.start = aTEToken;
        this.colon = aTEToken2;
        this.end = aTEToken3;
        this.lexer = ATEToken.isLexerName(string);
    }

    public void completed() {
        this.leftRecursionAnalyzed = false;
    }

    public void setReferencesIndexes(int n, int n2) {
        this.refsStartIndex = Math.max(0, n);
        this.refsEndIndex = n2;
    }

    public List<ElementReference> getReferences() {
        if (this.refsStartIndex != -1 && this.refsEndIndex != -1) {
            return this.parser.references.subList(this.refsStartIndex, this.refsEndIndex + 1);
        }
        return null;
    }

    public void setBlocksIndexes(int n, int n2) {
        this.blocksStartIndex = Math.max(0, n);
        this.blocksEndIndex = n2;
    }

    public List<ElementBlock> getBlocks() {
        if (this.blocksStartIndex != -1 && this.blocksEndIndex != -1) {
            return this.parser.blocks.subList(this.blocksStartIndex, this.blocksEndIndex + 1);
        }
        return null;
    }

    public void setActionsIndexes(int n, int n2) {
        this.actionsStartIndex = Math.max(0, n);
        this.actionsEndIndex = n2;
    }

    public List<ElementAction> getActions() {
        if (this.actionsStartIndex != -1 && this.actionsEndIndex != -1) {
            return this.parser.actions.subList(this.actionsStartIndex, this.actionsEndIndex + 1);
        }
        return null;
    }

    public int getStartIndex() {
        return this.start.getStartIndex();
    }

    public int getEndIndex() {
        return this.end.getEndIndex();
    }

    public int getLength() {
        return this.getEndIndex() - this.getStartIndex();
    }

    public int getInternalTokensStartIndex() {
        Iterator<ATEToken> iterator = this.getTokens().iterator();
        while (iterator.hasNext()) {
            ATEToken aTEToken = iterator.next();
            if (!aTEToken.getAttribute().equals(":")) continue;
            aTEToken = iterator.next();
            return aTEToken.getStartIndex();
        }
        return -1;
    }

    public int getInternalTokensEndIndex() {
        ATEToken aTEToken = this.parser.getTokens().get(this.end.index - 1);
        return aTEToken.getEndIndex();
    }

    public List<ATEToken> getTokens() {
        ArrayList<ATEToken> arrayList = new ArrayList<ATEToken>();
        for (int i = this.start.index; i < this.end.index; ++i) {
            arrayList.add(this.parser.getTokens().get(i));
        }
        return arrayList;
    }

    public List<List<ATEToken>> getAlternatives() {
        ArrayList<List<ATEToken>> arrayList = new ArrayList<List<ATEToken>>();
        ArrayList<ATEToken> arrayList2 = null;
        boolean bl = true;
        int n = 0;
        for (ATEToken aTEToken : this.getTokens()) {
            if (bl) {
                if (!aTEToken.getAttribute().equals(":")) continue;
                bl = false;
                arrayList2 = new ArrayList<ATEToken>();
                continue;
            }
            if (aTEToken.getAttribute().equals("(")) {
                ++n;
            } else if (aTEToken.getAttribute().equals(")")) {
                --n;
            } else if (n == 0 && aTEToken.getAttribute().equals("|")) {
                arrayList.add(arrayList2);
                arrayList2 = new ArrayList();
                continue;
            }
            arrayList2.add(aTEToken);
        }
        if (arrayList2 != null && !arrayList2.isEmpty()) {
            arrayList.add((List<ATEToken>)arrayList2);
        }
        return arrayList;
    }

    public void setErrors(List<EngineGrammarError> list) {
        this.errors = list;
    }

    public List<EngineGrammarError> getErrors() {
        return this.errors;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setLeftRecursiveRulesSet(Set set) {
        this.leftRecursiveRulesSet = set;
    }

    public Set getLeftRecursiveRulesSet() {
        return this.leftRecursiveRulesSet;
    }

    public boolean hasLeftRecursion() {
        if (!this.leftRecursionAnalyzed) {
            this.leftRecursionAnalyzed = true;
            this.hasLeftRecursion = this.detectLeftRecursion();
        }
        return this.hasLeftRecursion;
    }

    public boolean detectLeftRecursion() {
        for (List<ATEToken> list : this.getAlternatives()) {
            ATEToken aTEToken;
            if (list.isEmpty() || !(aTEToken = list.get(0)).getAttribute().equals(this.name)) continue;
            return true;
        }
        return false;
    }

    public String getTextRuleAfterRemovingLeftRecursion() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (List<ATEToken> list : this.getAlternatives()) {
            int n;
            int n2;
            ATEToken aTEToken = list.get(0);
            if (aTEToken.getAttribute().equals(this.name)) {
                if (list.size() <= 1) continue;
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(" | ");
                }
                n2 = list.get(1).getStartIndex();
                n = list.get(list.size() - 1).getEndIndex();
                stringBuffer2.append(aTEToken.getText().substring(n2, n));
                continue;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" | ");
            }
            n2 = aTEToken.getStartIndex();
            n = list.get(list.size() - 1).getEndIndex();
            stringBuffer.append(aTEToken.getText().substring(n2, n));
        }
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append("(");
        stringBuffer3.append(stringBuffer);
        stringBuffer3.append(")");
        if (stringBuffer2.length() > 0) {
            stringBuffer3.append(" (");
            stringBuffer3.append(stringBuffer2);
            stringBuffer3.append(")*");
        }
        return stringBuffer3.toString();
    }

    public boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }

    public void setNeedsToBuildErrors(boolean bl) {
        this.needsToBuildErrors = bl;
    }

    public boolean needsToBuildErrors() {
        return this.needsToBuildErrors;
    }

    public String getErrorMessageString(int n) {
        EngineGrammarError engineGrammarError = this.errors.get(n);
        return engineGrammarError.messageText;
    }

    public String getErrorMessageHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        Iterator<EngineGrammarError> iterator = this.errors.iterator();
        while (iterator.hasNext()) {
            EngineGrammarError engineGrammarError = iterator.next();
            stringBuffer.append(engineGrammarError.messageText);
            if (!iterator.hasNext()) continue;
            stringBuffer.append("<br>");
        }
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.name;
    }

    public boolean containsIndex(int n) {
        return n >= this.getStartIndex() && n <= this.getEndIndex();
    }

    public int compareTo(Object object) {
        ElementRule elementRule = (ElementRule)object;
        return this.name.compareTo(elementRule.name);
    }

    public int getUniqueIdentifier() {
        return this.name.hashCode();
    }

    public boolean canBeCollapsed() {
        return this.colon.startLineNumber <= this.end.startLineNumber - 1;
    }

    @Override
    public void foldingEntitySetExpanded(boolean bl) {
        this.setExpanded(bl);
    }

    @Override
    public boolean foldingEntityIsExpanded() {
        return this.isExpanded();
    }

    @Override
    public boolean foldingEntityCanBeCollapsed() {
        return this.canBeCollapsed();
    }

    @Override
    public int foldingEntityGetStartParagraphIndex() {
        return this.getStartIndex();
    }

    @Override
    public int foldingEntityGetStartIndex() {
        return this.colon.getStartIndex();
    }

    @Override
    public int foldingEntityGetEndIndex() {
        return this.getEndIndex();
    }

    @Override
    public int foldingEntityGetStartLine() {
        return this.colon.startLineNumber;
    }

    @Override
    public int foldingEntityGetEndLine() {
        return this.end.endLineNumber;
    }

    @Override
    public String foldingEntityPlaceholderString() {
        return ": ... ;";
    }

    @Override
    public String foldingEntityID() {
        return String.valueOf(this.getUniqueIdentifier());
    }

    @Override
    public int foldingEntityLevel() {
        return 0;
    }

    @Override
    public int breakpointEntityUniqueID() {
        return this.getUniqueIdentifier();
    }

    @Override
    public int breakpointEntityIndex() {
        return this.getStartIndex();
    }

    @Override
    public int breakpointEntityLine() {
        return this.start.startLineNumber;
    }

    @Override
    public void breakpointEntitySetBreakpoint(boolean bl) {
        this.breakpoint = bl;
    }

    @Override
    public boolean breakpointEntityIsBreakpoint() {
        return this.breakpoint;
    }

    @Override
    public Object getPersistentID() {
        return this.getUniqueIdentifier();
    }

    @Override
    public void persistentAssign(EditorPersistentObject editorPersistentObject) {
        ElementRule elementRule = (ElementRule)editorPersistentObject;
        this.ignored = elementRule.ignored;
        this.expanded = elementRule.expanded;
        this.breakpoint = elementRule.breakpoint;
        this.leftRecursiveRulesSet = elementRule.leftRecursiveRulesSet;
    }
}

