/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.syntax.element;

import java.util.ArrayList;
import java.util.List;
import org.antlr.works.ate.folding.ATEFoldingEntity;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.editor.EditorPersistentObject;
import org.antlr.works.syntax.GrammarSyntaxParser;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.works.syntax.element.ElementScopable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementAction
extends ElementScopable
implements EditorPersistentObject,
ATEFoldingEntity {
    public ElementRule rule;
    public ATEToken start;
    public ATEToken end;
    public int actionNum;
    private boolean expanded = true;
    private GrammarSyntaxParser parser;

    public ElementAction(GrammarSyntaxParser grammarSyntaxParser, ElementRule elementRule, ATEToken aTEToken) {
        this.parser = grammarSyntaxParser;
        this.rule = elementRule;
        this.start = aTEToken;
    }

    public boolean containsIndex(int n) {
        return n >= this.start.getStartIndex() && n <= this.end.getEndIndex();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ElementAction) {
            return this.getUniqueIdentifier() == ((ElementAction)object).getUniqueIdentifier();
        }
        return false;
    }

    public List<ATEToken> getTokens() {
        ArrayList<ATEToken> arrayList = new ArrayList<ATEToken>();
        for (int i = this.start.index; i < this.end.index; ++i) {
            arrayList.add(this.parser.getTokens().get(i));
        }
        return arrayList;
    }

    public int getUniqueIdentifier() {
        String string = this.start.getText().substring(this.start.start, this.end.end);
        return (this.rule.name + string + this.actionNum).hashCode();
    }

    @Override
    public void foldingEntitySetExpanded(boolean bl) {
        this.expanded = bl;
    }

    @Override
    public boolean foldingEntityIsExpanded() {
        return this.expanded;
    }

    @Override
    public boolean foldingEntityCanBeCollapsed() {
        return true;
    }

    @Override
    public int foldingEntityGetStartParagraphIndex() {
        return this.start.getStartIndex();
    }

    @Override
    public int foldingEntityGetStartIndex() {
        return this.start.getStartIndex();
    }

    @Override
    public int foldingEntityGetEndIndex() {
        return this.end.getEndIndex();
    }

    @Override
    public int foldingEntityGetStartLine() {
        return this.start.startLineNumber;
    }

    @Override
    public int foldingEntityGetEndLine() {
        return this.end.endLineNumber;
    }

    @Override
    public String foldingEntityPlaceholderString() {
        return "{ ... }";
    }

    @Override
    public String foldingEntityID() {
        return String.valueOf(this.getUniqueIdentifier());
    }

    @Override
    public int foldingEntityLevel() {
        return 1;
    }

    @Override
    public Object getPersistentID() {
        return this.getUniqueIdentifier();
    }

    @Override
    public void persistentAssign(EditorPersistentObject editorPersistentObject) {
        ElementAction elementAction = (ElementAction)editorPersistentObject;
        this.expanded = elementAction.expanded;
    }
}

