/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.syntax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.works.ate.syntax.generic.ATESyntaxParser;
import org.antlr.works.ate.syntax.misc.ATEScope;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.syntax.element.ElementAction;
import org.antlr.works.syntax.element.ElementArgumentBlock;
import org.antlr.works.syntax.element.ElementBlock;
import org.antlr.works.syntax.element.ElementGrammarName;
import org.antlr.works.syntax.element.ElementGroup;
import org.antlr.works.syntax.element.ElementReference;
import org.antlr.works.syntax.element.ElementRewriteBlock;
import org.antlr.works.syntax.element.ElementRewriteFunction;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.works.syntax.element.ElementToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarSyntaxParser
extends ATESyntaxParser {
    private static final ElementRewriteBlock REWRITE_BLOCK = new ElementRewriteBlock();
    private static final ElementArgumentBlock ARGUMENT_BLOCK = new ElementArgumentBlock();
    private static final ElementRewriteFunction REWRITE_FUNCTION = new ElementRewriteFunction();
    public static final String BEGIN_GROUP = "// $<";
    public static final String END_GROUP = "// $>";
    public static final String TOKENS_BLOCK_NAME = "tokens";
    public static final String OPTIONS_BLOCK_NAME = "options";
    public static final String PARSER_HEADER_BLOCK_NAME = "@header";
    public static final String LEXER_HEADER_BLOCK_NAME = "@lexer::header";
    public static final String PARSER_MEMBERS_BLOCK_NAME = "@members";
    public static final String LEXER_MEMBERS_BLOCK_NAME = "@lexer::members";
    public static final List<String> blockIdentifiers = new ArrayList<String>();
    public static final List<String> ruleModifiers;
    public static final List<String> keywords;
    public static final List<String> predefinedReferences;
    public List<ElementRule> rules = new ArrayList<ElementRule>();
    public List<ElementGroup> groups = new ArrayList<ElementGroup>();
    public List<ElementBlock> blocks = new ArrayList<ElementBlock>();
    public List<ElementAction> actions = new ArrayList<ElementAction>();
    public List<ElementReference> references = new ArrayList<ElementReference>();
    public List<ATEToken> decls = new ArrayList<ATEToken>();
    public ElementGrammarName name;
    private LabelTable labels = new LabelTable();
    private List<ATEToken> unresolvedReferences = new ArrayList<ATEToken>();
    private Set<String> declaredReferenceNames = new HashSet<String>();
    private Map<ATEToken, ElementRule> refsToRules = new HashMap<ATEToken, ElementRule>();
    private ElementRule currentRule;

    @Override
    public void close() {
        super.close();
        this.clear();
    }

    @Override
    public void parseTokens() {
        this.clear();
        if (!this.nextToken()) {
            return;
        }
        while (this.matchName() || this.matchScope() || this.matchBlock() || this.matchRule() || this.matchRuleGroup() || this.matchSingleComment(0) || this.matchComplexComment(0) || this.nextToken()) {
        }
        this.resolveReferences();
    }

    private void clear() {
        this.rules.clear();
        this.groups.clear();
        this.blocks.clear();
        this.actions.clear();
        this.references.clear();
        this.decls.clear();
        this.currentRule = null;
        this.declaredReferenceNames.clear();
        this.unresolvedReferences.clear();
        this.refsToRules.clear();
    }

    public void resolveReferencesWithExternalNames(Set<String> set) {
        for (int i = this.unresolvedReferences.size() - 1; i >= 0; --i) {
            ATEToken aTEToken = this.unresolvedReferences.get(i);
            if (!set.contains(aTEToken.getAttribute())) continue;
            aTEToken.type = 100;
            this.references.add(new ElementReference(this.refsToRules.get(aTEToken), aTEToken));
            this.unresolvedReferences.remove(i);
        }
    }

    private void resolveReferences() {
        for (int i = this.unresolvedReferences.size() - 1; i >= 0; --i) {
            ATEToken aTEToken = this.unresolvedReferences.get(i);
            if (!this.declaredReferenceNames.contains(aTEToken.getAttribute())) continue;
            aTEToken.type = 100;
            this.references.add(new ElementReference(this.refsToRules.get(aTEToken), aTEToken));
            this.unresolvedReferences.remove(i);
        }
    }

    private boolean matchName() {
        if (!this.isID(0)) {
            return false;
        }
        this.mark();
        if (this.tryMatchName()) {
            return true;
        }
        this.rewind();
        return false;
    }

    private boolean tryMatchName() {
        ATEToken aTEToken = this.T(0);
        if (ElementGrammarName.isKnownType(aTEToken.getAttribute()) && !this.nextToken()) {
            return false;
        }
        if (!this.matchID(0, "grammar")) {
            return false;
        }
        ATEToken aTEToken2 = this.T(0);
        if (!this.nextToken()) {
            return false;
        }
        if (!this.matchSEMI(0)) {
            return false;
        }
        this.name = new ElementGrammarName(aTEToken2, aTEToken, this.T(-1), aTEToken);
        return true;
    }

    private boolean matchScope() {
        if (!this.isID(0, "scope")) {
            return false;
        }
        this.mark();
        ATEToken aTEToken = this.T(0);
        if (!this.matchID(0, "scope")) {
            return false;
        }
        this.matchID(0);
        if (this.isOpenBLOCK(0)) {
            ATEToken aTEToken2 = this.T(0);
            if (this.matchBalancedToken(9, 10, null, true)) {
                aTEToken2.type = 103;
                this.T((int)-1).type = 103;
                aTEToken.type = 102;
                return true;
            }
        } else if (this.matchSEMI(0)) {
            return true;
        }
        this.rewind();
        return false;
    }

    private boolean matchBlock() {
        return this.matchBlock(null);
    }

    private boolean matchBlock(String string) {
        if (string == null && !this.isID(0)) {
            return false;
        }
        if (string != null && !this.isID(0, string)) {
            return false;
        }
        this.mark();
        ATEToken aTEToken = this.T(0);
        int n = this.getPosition();
        if (string == null ? !this.matchID(0) : !this.matchID(0, string)) {
            return false;
        }
        ElementBlock elementBlock = new ElementBlock(aTEToken.getAttribute().toLowerCase(), aTEToken);
        ATEToken aTEToken2 = this.T(0);
        if (this.matchBalancedToken(9, 10, elementBlock, true)) {
            aTEToken2.type = 103;
            this.T((int)-1).type = 103;
            aTEToken.type = 102;
            this.blocks.add(elementBlock);
            elementBlock.end = this.T(-1);
            elementBlock.internalTokens = new ArrayList<ATEToken>(this.getTokens().subList(n, this.getPosition()));
            elementBlock.parse();
            if (elementBlock.isTokenBlock) {
                List<ATEToken> list = elementBlock.getDeclaredTokens();
                for (ATEToken aTEToken3 : list) {
                    aTEToken3.type = 105;
                    this.addDeclaration(aTEToken3);
                }
            }
            return true;
        }
        this.rewind();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchRule() {
        this.mark();
        try {
            if (this.tryMatchRule()) {
                boolean bl = true;
                return bl;
            }
            this.rewind();
            boolean bl = false;
            return bl;
        }
        finally {
            this.currentRule = null;
        }
    }

    private boolean tryMatchRule() {
        ATEToken aTEToken = this.T(0);
        if (aTEToken == null) {
            return false;
        }
        if (ruleModifiers.contains(aTEToken.getAttribute()) && !this.nextToken()) {
            return false;
        }
        ElementToken elementToken = (ElementToken)this.T(0);
        String string = elementToken.getAttribute();
        if (!this.matchID(0)) {
            return false;
        }
        this.matchArguments();
        if (this.matchID(0, "returns")) {
            this.matchArguments();
        }
        this.matchChar(0, "!");
        while (this.matchScope() || this.matchBlock() || this.matchSingleComment(0) || this.matchComplexComment(0)) {
        }
        if (!this.isCOLON(0)) {
            return false;
        }
        this.nextToken();
        ATEToken aTEToken2 = this.T(-1);
        int n = this.references.size();
        int n2 = this.blocks.size();
        int n3 = this.actions.size();
        this.currentRule = new ElementRule(this, string, aTEToken, aTEToken2, null);
        this.labels.clear();
        do {
            if (!this.matchEndOfRule(elementToken, n, n2, n3)) continue;
            return true;
        } while (this.matchBlock(OPTIONS_BLOCK_NAME) || this.matchRewriteTemplate() || this.matchAssignment(this.labels) || this.matchInternalRefInRule() || this.matchAction() || this.nextToken());
        return false;
    }

    private boolean matchEndOfRule(ElementToken elementToken, int n, int n2, int n3) {
        if (!this.matchSEMI(0)) {
            return false;
        }
        this.matchRuleExceptionGroup();
        this.currentRule.end = this.T(-1);
        elementToken.type = 105;
        this.addDeclaration(elementToken);
        if (this.references.size() > n) {
            this.currentRule.setReferencesIndexes(n, this.references.size() - 1);
        }
        if (this.blocks.size() > n2) {
            this.currentRule.setBlocksIndexes(n2, this.blocks.size() - 1);
        }
        if (this.actions.size() > n3) {
            this.currentRule.setActionsIndexes(n3, this.actions.size() - 1);
        }
        this.currentRule.completed();
        this.rules.add(this.currentRule);
        return true;
    }

    private boolean matchInternalRefInRule() {
        if (!this.matchID(0)) {
            return false;
        }
        ATEToken aTEToken = this.T(-1);
        while (this.isChar(0, ".") && this.isID(1)) {
            if (this.skip(2)) continue;
            return false;
        }
        this.matchArguments();
        this.addReference(aTEToken, false);
        return true;
    }

    private boolean matchAction() {
        if (!this.isOpenBLOCK(0)) {
            return false;
        }
        ATEToken aTEToken = this.T(0);
        ElementAction elementAction = new ElementAction(this, this.currentRule, aTEToken);
        if (this.matchBalancedToken(9, 10, elementAction, true)) {
            aTEToken.type = 103;
            this.T((int)-1).type = 103;
            elementAction.end = this.T(-1);
            elementAction.actionNum = this.actions.size();
            elementAction.setScope(this.currentRule);
            this.actions.add(elementAction);
            return true;
        }
        return false;
    }

    private boolean matchAssignment(LabelTable labelTable) {
        this.mark();
        ATEToken aTEToken = this.T(0);
        if (this.matchID(0)) {
            if (this.matchChar(0, "=")) {
                aTEToken.type = 101;
                labelTable.add(aTEToken.getAttribute());
                return true;
            }
            if (this.isChar(0, "+") && this.isChar(1, "=")) {
                aTEToken.type = 101;
                labelTable.add(aTEToken.getAttribute());
                this.skip(2);
                return true;
            }
        }
        this.rewind();
        return false;
    }

    private boolean matchRewriteTemplate() {
        if (!this.isTokenType(0, 104)) {
            return false;
        }
        if (!this.nextToken()) {
            return false;
        }
        this.matchComplexComment(0);
        if (this.matchAction() && !this.matchChar(0, "?")) {
            return true;
        }
        if (this.isID(0, "template")) {
            if (!this.matchRewriteTemplateHead()) {
                return false;
            }
            if (this.matchDoubleQuotedString()) {
                return true;
            }
            if (this.matchDoubleAngleString()) {
                return true;
            }
        } else if (!(this.matchRewriteTemplateHead() || this.matchRewriteIndirectTemplateHead() || this.matchAction())) {
            return true;
        }
        return true;
    }

    private boolean matchRewriteIndirectTemplateHead() {
        if (!this.isLPAREN(0)) {
            return false;
        }
        this.mark();
        if (this.tryMatchRewriteIndirectTemplateHead()) {
            return true;
        }
        this.rewind();
        return false;
    }

    private boolean tryMatchRewriteIndirectTemplateHead() {
        if (!this.matchLPAREN(0)) {
            return false;
        }
        if (!this.matchAction()) {
            return false;
        }
        if (!this.matchRPAREN(0)) {
            return false;
        }
        if (!this.matchLPAREN(0)) {
            return false;
        }
        if (!this.matchRewriteTemplateArgs()) {
            return false;
        }
        return this.matchRPAREN(0);
    }

    private boolean matchRewriteTemplateHead() {
        if (!this.isID(0)) {
            return false;
        }
        this.mark();
        if (this.tryMatchRewriteTemplateHead()) {
            return true;
        }
        this.rewind();
        return false;
    }

    private boolean tryMatchRewriteTemplateHead() {
        if (!this.matchID(0)) {
            return false;
        }
        if (!this.matchLPAREN(0)) {
            return false;
        }
        if (!this.matchRewriteTemplateArgs()) {
            return false;
        }
        return this.matchRPAREN(0);
    }

    private boolean matchRewriteTemplateArgs() {
        if (this.matchRewriteTemplateArg()) {
            while (this.matchChar(0, ",")) {
                this.matchSingleComment(0);
                this.matchComplexComment(0);
                if (this.matchRewriteTemplateArg()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean matchRewriteTemplateArg() {
        if (!this.isID(0) && !this.isChar(1, "=")) {
            return false;
        }
        this.mark();
        if (this.tryMatchRewriteTemplateArg()) {
            return true;
        }
        this.rewind();
        return false;
    }

    private boolean tryMatchRewriteTemplateArg() {
        if (!this.matchID(0)) {
            return false;
        }
        if (!this.matchChar(0, "=")) {
            return false;
        }
        return this.matchBalancedToken(9, 10, REWRITE_FUNCTION, true);
    }

    private boolean matchDoubleQuotedString() {
        if (this.isTokenType(0, 2)) {
            this.T((int)0).scope = REWRITE_BLOCK;
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchDoubleAngleString() {
        return this.matchBalancedToken(106, 107, REWRITE_BLOCK, false);
    }

    private boolean matchArguments() {
        return this.matchBalancedToken(11, 12, ARGUMENT_BLOCK, true);
    }

    private void matchRuleExceptionGroup() {
        while (this.matchID(0, "catch")) {
            this.matchArguments();
            this.matchAction();
        }
        if (this.matchID(0, "finally")) {
            this.matchAction();
        }
    }

    private boolean matchRuleGroup() {
        if (!this.isSingleComment(0)) {
            return false;
        }
        ATEToken aTEToken = this.T(0);
        String string = aTEToken.getAttribute();
        if (string.startsWith(BEGIN_GROUP)) {
            this.groups.add(new ElementGroup(string.substring(BEGIN_GROUP.length(), string.length() - 1), this.rules.size() - 1, aTEToken));
            this.nextToken();
            return true;
        }
        if (string.startsWith(END_GROUP)) {
            this.groups.add(new ElementGroup(this.rules.size() - 1, aTEToken));
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean addReference(ATEToken aTEToken, boolean bl) {
        this.refsToRules.put(aTEToken, this.currentRule);
        if (this.labels.lookup(aTEToken.getAttribute())) {
            aTEToken.type = 101;
            return true;
        }
        if (!bl) {
            aTEToken.type = 100;
            this.references.add(new ElementReference(this.refsToRules.get(aTEToken), aTEToken));
        }
        return false;
    }

    private void addDeclaration(ATEToken aTEToken) {
        this.decls.add(aTEToken);
        this.declaredReferenceNames.add(aTEToken.getAttribute());
    }

    private boolean matchBalancedToken(int n, int n2, ATEScope aTEScope, boolean bl) {
        if (this.T(0) == null || this.T((int)0).type != n) {
            return false;
        }
        this.mark();
        int n3 = 0;
        while (true) {
            this.T((int)0).scope = aTEScope;
            if (this.T((int)0).type == n) {
                ++n3;
            } else if (this.T((int)0).type == n2 && --n3 == 0) {
                this.nextToken();
                return true;
            }
            if (!this.nextToken()) break;
            this.matchInternalRefInBalancedToken(bl);
        }
        this.rewind();
        return false;
    }

    private void matchInternalRefInBalancedToken(boolean bl) {
        if (bl && this.isChar(0, "$") && this.isID(1)) {
            this.T((int)0).type = 108;
            ATEToken aTEToken = this.T(1);
            if (!this.addReference(aTEToken, true)) {
                this.unresolvedReferences.add(aTEToken);
            }
        }
    }

    private boolean matchChar(int n, String string) {
        if (this.isChar(n, string)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchID(int n) {
        if (this.isID(n)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchID(int n, String string) {
        if (this.isID(n, string)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchSEMI(int n) {
        if (this.isSEMI(n)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchLPAREN(int n) {
        if (this.isLPAREN(n)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchRPAREN(int n) {
        if (this.isRPAREN(n)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean isLPAREN(int n) {
        return this.isTokenType(n, 7);
    }

    private boolean isRPAREN(int n) {
        return this.isTokenType(n, 8);
    }

    private boolean isSEMI(int n) {
        return this.isTokenType(n, 14);
    }

    private boolean isCOLON(int n) {
        return this.isTokenType(n, 13);
    }

    private boolean isOpenBLOCK(int n) {
        return this.isTokenType(n, 9);
    }

    static {
        blockIdentifiers.add(OPTIONS_BLOCK_NAME);
        blockIdentifiers.add(TOKENS_BLOCK_NAME);
        blockIdentifiers.add(PARSER_HEADER_BLOCK_NAME);
        blockIdentifiers.add(LEXER_HEADER_BLOCK_NAME);
        blockIdentifiers.add(PARSER_MEMBERS_BLOCK_NAME);
        blockIdentifiers.add(LEXER_MEMBERS_BLOCK_NAME);
        ruleModifiers = new ArrayList<String>();
        ruleModifiers.add("protected");
        ruleModifiers.add("public");
        ruleModifiers.add("private");
        ruleModifiers.add("fragment");
        keywords = new ArrayList<String>();
        keywords.addAll(blockIdentifiers);
        keywords.addAll(ruleModifiers);
        keywords.add("returns");
        keywords.add("init");
        predefinedReferences = new ArrayList<String>();
        predefinedReferences.add("EOF");
    }

    private static class LabelTable {
        Set<String> labels = new HashSet<String>();

        private LabelTable() {
        }

        public void clear() {
            this.labels.clear();
        }

        public void add(String string) {
            this.labels.add(string);
        }

        public boolean lookup(String string) {
            return this.labels.contains(string);
        }
    }
}

