/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.syntax;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.antlr.works.ate.syntax.generic.ATESyntaxLexer;
import org.antlr.works.ate.syntax.generic.ATESyntaxParser;
import org.antlr.works.ate.syntax.language.ATELanguageSyntaxEngine;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.syntax.GrammarSyntaxLexer;
import org.antlr.works.syntax.GrammarSyntaxParser;
import org.antlr.works.syntax.element.ElementAction;
import org.antlr.works.syntax.element.ElementBlock;
import org.antlr.works.syntax.element.ElementGrammarName;
import org.antlr.works.syntax.element.ElementGroup;
import org.antlr.works.syntax.element.ElementReference;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.works.syntax.element.ElementToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarSyntaxEngine
extends ATELanguageSyntaxEngine {
    public static final Color COLOR_PARSER = new Color(0.42f, 0.0f, 0.42f);
    public static final Color COLOR_LEXER = new Color(0.0f, 0.0f, 0.5f);
    protected List<ElementRule> rules;
    protected List<ElementGroup> groups;
    protected List<ElementBlock> blocks;
    protected List<ElementAction> actions;
    protected List<ElementReference> references;
    protected List<ATEToken> decls;
    protected ElementGrammarName name;
    protected SimpleAttributeSet parserRefAttr = new SimpleAttributeSet();
    protected SimpleAttributeSet lexerRefAttr = new SimpleAttributeSet();
    protected SimpleAttributeSet labelAttr = new SimpleAttributeSet();
    protected SimpleAttributeSet actionRefAttr = new SimpleAttributeSet();
    protected SimpleAttributeSet blockLabelAttr = new SimpleAttributeSet();

    @Override
    public void close() {
        super.close();
        if (this.name != null) {
            this.name.close();
        }
        if (this.rules != null) {
            this.rules.clear();
        }
        if (this.groups != null) {
            this.groups.clear();
        }
        if (this.blocks != null) {
            this.blocks.clear();
        }
        if (this.actions != null) {
            this.actions.clear();
        }
        if (this.references != null) {
            this.references.clear();
        }
        if (this.decls != null) {
            this.decls.clear();
        }
    }

    @Override
    public void applyCommentAttribute(SimpleAttributeSet simpleAttributeSet) {
        this.applyAttribute(simpleAttributeSet, "PREF_SYNTAX_COMMENT");
    }

    @Override
    public void applyStringAttribute(SimpleAttributeSet simpleAttributeSet) {
        this.applyAttribute(simpleAttributeSet, "PREF_SYNTAX_STRING");
    }

    @Override
    public void applyKeywordAttribute(SimpleAttributeSet simpleAttributeSet) {
        this.applyAttribute(simpleAttributeSet, "PREF_SYNTAX_KEYWORD");
    }

    public void applyAttribute(SimpleAttributeSet simpleAttributeSet, String string) {
        StyleConstants.setForeground(simpleAttributeSet, AWPrefs.getSyntaxColor(string));
        StyleConstants.setBold(simpleAttributeSet, AWPrefs.getSyntaxBold(string));
        StyleConstants.setItalic(simpleAttributeSet, AWPrefs.getSyntaxItalic(string));
    }

    @Override
    public ATESyntaxLexer createLexer() {
        return new GrammarSyntaxLexer();
    }

    @Override
    public ATESyntaxParser createParser() {
        return new GrammarSyntaxParser();
    }

    @Override
    public void refreshColoring() {
        super.refreshColoring();
        this.applyAttribute(this.parserRefAttr, "PREF_SYNTAX_PARSER");
        this.applyAttribute(this.lexerRefAttr, "PREF_SYNTAX_LEXER");
        this.applyAttribute(this.labelAttr, "PREF_SYNTAX_LABEL");
        this.applyAttribute(this.actionRefAttr, "PREF_SYNTAX_REFS");
        StyleConstants.setBold(this.blockLabelAttr, true);
    }

    @Override
    public AttributeSet getAttributeForToken(ATEToken aTEToken) {
        AttributeSet attributeSet = super.getAttributeForToken(aTEToken);
        switch (aTEToken.type) {
            case 100: 
            case 105: {
                if (((ElementToken)aTEToken).lexer) {
                    attributeSet = this.lexerRefAttr;
                    break;
                }
                attributeSet = this.parserRefAttr;
                break;
            }
            case 101: {
                attributeSet = this.labelAttr;
                break;
            }
            case 102: 
            case 103: {
                attributeSet = this.blockLabelAttr;
                break;
            }
            case 108: {
                attributeSet = this.actionRefAttr;
            }
        }
        return attributeSet;
    }

    public static void setDelay(int n) {
        delay = n;
    }

    public synchronized List<ElementRule> getRules() {
        return this.rules;
    }

    public synchronized List<ElementGroup> getGroups() {
        return this.groups;
    }

    public synchronized List<ElementBlock> getBlocks() {
        return this.blocks;
    }

    public synchronized List<ElementAction> getActions() {
        return this.actions;
    }

    public synchronized List<ElementReference> getReferences() {
        return this.references;
    }

    public synchronized List<ATEToken> getDecls() {
        return this.decls;
    }

    public synchronized ElementGrammarName getName() {
        return this.name;
    }

    public synchronized List<String> getDeclaredTokenNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.blocks != null) {
            for (ElementBlock elementBlock : this.blocks) {
                if (!elementBlock.isTokenBlock) continue;
                arrayList.addAll(elementBlock.getDeclaredTokensAsString());
            }
        }
        return arrayList;
    }

    public List<String> getPredefinedReferences() {
        return GrammarSyntaxParser.predefinedReferences;
    }

    public synchronized String getTokenVocab() {
        if (this.blocks == null) {
            return null;
        }
        for (ElementBlock elementBlock : this.blocks) {
            if (!elementBlock.isOptionsBlock) continue;
            return elementBlock.getTokenVocab();
        }
        return null;
    }

    public synchronized List<String> getRuleNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.rules != null) {
            for (ElementRule elementRule : this.rules) {
                arrayList.add(elementRule.name);
            }
        }
        return arrayList;
    }

    public synchronized ElementRule getRuleAtIndex(int n) {
        if (n < 0 || n >= this.rules.size()) {
            return null;
        }
        return this.rules.get(n);
    }

    @Override
    protected synchronized void parserDidRun(ATESyntaxParser aTESyntaxParser) {
        GrammarSyntaxParser grammarSyntaxParser = (GrammarSyntaxParser)aTESyntaxParser;
        this.rules = new ArrayList<ElementRule>(grammarSyntaxParser.rules);
        this.groups = new ArrayList<ElementGroup>(grammarSyntaxParser.groups);
        this.blocks = new ArrayList<ElementBlock>(grammarSyntaxParser.blocks);
        this.actions = new ArrayList<ElementAction>(grammarSyntaxParser.actions);
        this.references = new ArrayList<ElementReference>(grammarSyntaxParser.references);
        this.decls = new ArrayList<ATEToken>(grammarSyntaxParser.decls);
        this.name = grammarSyntaxParser.name;
    }
}

