/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.syntax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.antlr.works.ate.syntax.generic.ATESyntaxParser;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.syntax.GrammarSyntaxDelegate;
import org.antlr.works.syntax.GrammarSyntaxEngine;
import org.antlr.works.syntax.GrammarSyntaxLexer;
import org.antlr.works.syntax.element.ElementReference;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarSyntax {
    private List<ElementRule> duplicateRules = new ArrayList<ElementRule>();
    private List<ElementReference> undefinedReferences = new ArrayList<ElementReference>();
    private List<ElementRule> hasLeftRecursionRules = new ArrayList<ElementRule>();
    private Set<String> tokenVocabNames = new HashSet<String>();
    private String tokenVocabName;
    private GrammarSyntaxDelegate delegate;

    public GrammarSyntax(GrammarSyntaxDelegate grammarSyntaxDelegate) {
        this.delegate = grammarSyntaxDelegate;
    }

    public void close() {
        this.delegate = null;
    }

    public GrammarSyntaxEngine getParserEngine() {
        if (this.delegate != null) {
            return this.delegate.getParserEngine();
        }
        return null;
    }

    public int getNumberOfRulesWithErrors() {
        int n = 0;
        if (this.getParserEngine().getRules() != null) {
            for (ElementRule elementRule : this.getParserEngine().getRules()) {
                if (!elementRule.hasErrors()) continue;
                ++n;
            }
        }
        return n;
    }

    public int getNumberOfErrors() {
        int n = 0;
        if (this.getParserEngine().getRules() != null) {
            for (ElementRule elementRule : this.getParserEngine().getRules()) {
                if (!elementRule.hasErrors()) continue;
                n += elementRule.getErrors().size();
            }
        }
        return n;
    }

    public List<ElementRule> getDuplicateRules() {
        return this.duplicateRules;
    }

    public List<ElementReference> getUndefinedReferences() {
        return this.undefinedReferences;
    }

    public void resetTokenVocab() {
        this.tokenVocabName = null;
        this.tokenVocabNames.clear();
    }

    public Set<String> getTokenVocabNames() {
        String string = this.getParserEngine().getTokenVocab();
        if (string == null) {
            this.tokenVocabName = null;
            this.tokenVocabNames.clear();
            return this.tokenVocabNames;
        }
        if (this.tokenVocabName != null && this.tokenVocabName.equals(string)) {
            return this.tokenVocabNames;
        }
        this.tokenVocabName = string;
        this.tokenVocabNames.clear();
        try {
            String string2 = this.delegate.getTokenVocabFile(this.tokenVocabName + ".tokens");
            if (string2 != null) {
                GrammarSyntax.readTokenVocabFromFile(string2, this.tokenVocabNames);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this.tokenVocabNames;
    }

    public static boolean readTokenVocabFromFile(String string, Set<String> set) throws IOException {
        List<ATEToken> list = GrammarSyntax.parsePropertiesString(XJUtils.getStringFromFile(string));
        for (ATEToken aTEToken : list) {
            set.add(aTEToken.getAttribute());
        }
        return true;
    }

    private static List<ATEToken> parsePropertiesString(String string) {
        GrammarSyntaxLexer grammarSyntaxLexer = new GrammarSyntaxLexer();
        grammarSyntaxLexer.tokenize(string);
        class ParseProperties
        extends ATESyntaxParser {
            public List<ATEToken> propertiesTokens;

            ParseProperties() {
            }

            public void parseTokens() {
                this.propertiesTokens = new ArrayList<ATEToken>();
                while (this.nextToken()) {
                    if (this.T((int)0).type != 5 || !this.isChar(1, "=") && !this.isChar(1, "\n")) continue;
                    this.propertiesTokens.add(this.T(0));
                }
            }
        }
        ParseProperties parseProperties = new ParseProperties();
        parseProperties.parse(grammarSyntaxLexer.getTokens());
        return parseProperties.propertiesTokens;
    }

    public void rebuildHasLeftRecursionRulesList() {
        GrammarSyntaxEngine grammarSyntaxEngine = this.getParserEngine();
        if (grammarSyntaxEngine == null) {
            return;
        }
        if (grammarSyntaxEngine.getRules() == null) {
            return;
        }
        this.hasLeftRecursionRules.clear();
        for (ElementRule elementRule : grammarSyntaxEngine.getRules()) {
            if (!elementRule.hasLeftRecursion()) continue;
            this.hasLeftRecursionRules.add(elementRule);
        }
    }

    public void rebuildDuplicateRulesList() {
        GrammarSyntaxEngine grammarSyntaxEngine = this.getParserEngine();
        if (grammarSyntaxEngine == null) {
            return;
        }
        List<ElementRule> list = grammarSyntaxEngine.getRules();
        if (list == null) {
            return;
        }
        ArrayList<ElementRule> arrayList = Collections.list(Collections.enumeration(list));
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        ElementRule elementRule = null;
        this.duplicateRules.clear();
        while (iterator.hasNext()) {
            ElementRule elementRule2 = (ElementRule)iterator.next();
            if (elementRule != null && elementRule.name.equals(elementRule2.name) && !this.duplicateRules.contains(elementRule)) {
                this.duplicateRules.add(elementRule);
                this.duplicateRules.add(elementRule2);
            }
            elementRule = elementRule2;
        }
    }

    public void rebuildUndefinedReferencesList() {
        GrammarSyntaxEngine grammarSyntaxEngine = this.getParserEngine();
        if (grammarSyntaxEngine == null) {
            return;
        }
        List<String> list = grammarSyntaxEngine.getRuleNames();
        list.addAll(grammarSyntaxEngine.getDeclaredTokenNames());
        list.addAll(grammarSyntaxEngine.getPredefinedReferences());
        Set<String> set = this.getTokenVocabNames();
        list.addAll(set);
        this.delegate.getParser().resolveReferencesWithExternalNames(set);
        this.undefinedReferences.clear();
        List<ElementReference> list2 = grammarSyntaxEngine.getReferences();
        if (list2 == null) {
            return;
        }
        for (ElementReference elementReference : list2) {
            if (list.contains(elementReference.token.getAttribute())) continue;
            this.undefinedReferences.add(elementReference);
        }
    }

    public void rebuildAll() {
        this.rebuildDuplicateRulesList();
        this.rebuildUndefinedReferencesList();
        this.rebuildHasLeftRecursionRulesList();
    }

    public void parserDidParse() {
        this.rebuildAll();
    }
}

