/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.swing.DetachablePanelDelegate;
import org.antlr.works.utils.IconManager;
import org.antlr.xjlib.appkit.frame.XJDialog;

public class DetachablePanel
extends JPanel {
    protected DetachablePanelDelegate delegate;
    protected JPanel mainPanel;
    protected TitlePanel titlePanel;
    protected String title;
    protected boolean detached = false;
    protected JButton detach;
    protected XJDialog window;
    protected int tag;
    private PropertyChangeListener pcl;
    private ActionListener al;
    private Point previousPosition;
    private Dimension previousSize;

    public DetachablePanel(String string, DetachablePanelDelegate detachablePanelDelegate) {
        super(new BorderLayout());
        this.delegate = detachablePanelDelegate;
        this.title = string;
        this.createTitleBar(string);
        this.mainPanel = new JPanel(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("focusOwner") && propertyChangeEvent.getNewValue() != null) {
                    Component component = (Component)propertyChangeEvent.getNewValue();
                    if (DetachablePanel.this.isParentOf(component)) {
                        DetachablePanel.this.focusGained();
                    } else {
                        DetachablePanel.this.focusLost();
                    }
                }
            }
        };
        keyboardFocusManager.addPropertyChangeListener(this.pcl);
    }

    public void close() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.pcl);
        this.detach.removeActionListener(this.al);
        this.delegate = null;
        this.window = null;
    }

    public void createTitleBar(String string) {
        Box box = Box.createHorizontalBox();
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(jLabel.getFont().deriveFont(11.0f));
        jLabel.setForeground(Color.white);
        box.add(Box.createHorizontalStrut(2));
        box.add(jLabel);
        box.add(Box.createHorizontalGlue());
        this.detach = this.createDetachButton();
        box.add(this.detach);
        this.titlePanel = new TitlePanel();
        this.titlePanel.setMinimumSize(new Dimension(0, 15));
        this.titlePanel.setMaximumSize(new Dimension(0, 15));
        this.titlePanel.setPreferredSize(new Dimension(0, 15));
        this.titlePanel.add(box);
        super.add((Component)this.titlePanel, "North");
    }

    public JButton createDetachButton() {
        JButton jButton = new JButton(IconManager.shared().getIconDetach());
        jButton.setBorder(null);
        jButton.setBorderPainted(false);
        jButton.setOpaque(false);
        jButton.setFocusable(false);
        jButton.setVerticalAlignment(0);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        this.al = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DetachablePanel.this.detached) {
                    DetachablePanel.this.attach();
                } else {
                    DetachablePanel.this.detach();
                }
            }
        };
        jButton.addActionListener(this.al);
        return jButton;
    }

    public boolean isParentOf(Component component) {
        Container container = component.getParent();
        return container != null && (container == this || this.isParentOf(container));
    }

    public void focusGained() {
        this.titlePanel.setFocused(true);
    }

    public void focusLost() {
        this.titlePanel.setFocused(false);
    }

    public void setTag(int n) {
        this.tag = n;
    }

    public int getTag() {
        return this.tag;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.detached) {
            this.window.setVisible(bl);
        }
    }

    public boolean isDetached() {
        return this.detached;
    }

    public void detach() {
        this.detached = true;
        Point point = this.getLocationOnScreen();
        this.delegate.panelDoDetach(this);
        this.detach.setIcon(IconManager.shared().getIconAttach());
        this.window = AWPrefs.getDetachableChildren() ? new DetachableWindow(this.delegate.panelParentContainer()) : new DetachableWindow(null);
        this.window.setTitle(this.title);
        if (this.previousPosition == null) {
            this.window.setPosition(point.x, point.y);
        } else {
            this.window.setPosition(this.previousPosition);
        }
        if (this.previousSize == null) {
            this.window.setSize(this.getWidth(), this.getHeight());
        } else {
            this.window.setSize(this.previousSize);
        }
        this.window.getContentPane().add(this);
        this.window.setVisible(true);
    }

    public void attach() {
        this.detached = false;
        this.previousPosition = this.window.getPosition();
        this.previousSize = this.window.getSize();
        this.window.getContentPane().remove(0);
        this.window.close();
        this.detach.setIcon(IconManager.shared().getIconDetach());
        this.delegate.panelDoAttach(this);
    }

    public class DetachableWindow
    extends XJDialog {
        public DetachableWindow(Container container) {
            super(container, false);
        }

        public void dialogWillCloseCancel() {
            if (DetachablePanel.this.detached) {
                DetachablePanel.this.setVisible(false);
                DetachablePanel.this.delegate.panelDoClose(DetachablePanel.this);
            }
        }
    }

    public static class TitlePanel
    extends JPanel {
        public boolean focused = false;

        public TitlePanel() {
            super(new BorderLayout());
        }

        public void setFocused(boolean bl) {
            this.focused = bl;
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            Color color;
            Color color2;
            if (this.focused) {
                color2 = new Color(0.1f, 0.6f, 0.9f);
                color = new Color(0.8f, 0.9f, 1.0f);
            } else {
                color2 = new Color(0.7f, 0.7f, 0.7f);
                color = new Color(0.9f, 0.9f, 0.9f);
            }
            int n = this.getVisibleRect().width;
            int n2 = this.getVisibleRect().height;
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color2, n, n2, color);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(0, 0, n, n2);
        }
    }
}

