/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.JToggleButton;

public class CustomToggleButton
extends JToggleButton {
    public int tag;
    public final int round = 4;
    public final int height = 22;
    public final float fontSize = 12.0f;

    public CustomToggleButton(String string) {
        super(string);
        this.setBorderPainted(false);
        this.setMaximumSize(new Dimension(0, 22));
        this.setFont(this.getFont().deriveFont(12.0f));
    }

    public void setTag(int n) {
        this.tag = n;
    }

    public int getTag() {
        return this.tag;
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintButton((Graphics2D)graphics, 0, 0, this.getWidth() - 2, this.getHeight() - 1, this.isSelected());
    }

    public void paintButton(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl) {
        Color color;
        Color color2;
        Color color3;
        Color color4;
        Color color5 = new Color(0.95f, 0.95f, 0.95f);
        if (bl) {
            color4 = new Color(0.7f, 0.9f, 1.0f);
            color3 = new Color(0.5f, 0.7f, 1.0f);
            color2 = new Color(0.1f, 0.6f, 0.9f);
            color = new Color(0.8f, 0.9f, 1.0f);
        } else {
            color4 = new Color(0.99f, 0.99f, 0.99f);
            color3 = new Color(0.9f, 0.9f, 0.9f);
            color2 = new Color(0.85f, 0.85f, 0.85f);
            color = new Color(0.99f, 0.99f, 0.99f);
        }
        GradientPaint gradientPaint = new GradientPaint(n, n2, color4, n, n2 + n4 / 2, color3);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(n, n2, n3, n4 / 2);
        graphics2D.setColor(color5);
        graphics2D.drawLine(n, n2 + 1, n + n3, n2 + 1);
        gradientPaint = new GradientPaint(n, n2 + n4 / 2, color2, n, n2 + n4, color);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(n, n2 + n4 / 2, n3, n4 / 2);
        if (bl) {
            graphics2D.setColor(Color.darkGray);
        } else {
            graphics2D.setColor(Color.gray);
        }
        graphics2D.drawRoundRect(n, n2, n3, n4, 4, 4);
        TextLayout textLayout = new TextLayout(this.getText(), graphics2D.getFont(), graphics2D.getFontRenderContext());
        Rectangle2D rectangle2D = textLayout.getBounds();
        float f = (float)((double)((float)n3 * 0.5f) - rectangle2D.getWidth() * 0.5);
        float f2 = (float)((double)((float)n4 * 0.5f) + rectangle2D.getHeight() * 0.5);
        graphics2D.setColor(Color.black);
        textLayout.draw(graphics2D, f, f2);
    }
}

