/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class CustomSplitPanel
extends JPanel {
    public static final int LEFT_INDEX = 0;
    public static final int MIDDLE_INDEX = 1;
    public static final int RIGHT_INDEX = 2;
    public JSplitPane leftSplitPane;
    public JSplitPane rightSplitPane;
    public Component left;
    public Component middle;
    public Component right;
    public Map<Component, Float> widths = new HashMap<Component, Float>();

    public CustomSplitPanel() {
        super(new BorderLayout());
        this.leftSplitPane = this.createSplitPane();
        this.rightSplitPane = this.createSplitPane();
    }

    public void close() {
        this.left = null;
        this.middle = null;
        this.right = null;
        this.widths.clear();
    }

    public JSplitPane createSplitPane() {
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setBorder(null);
        jSplitPane.setOrientation(1);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setOneTouchExpandable(true);
        return jSplitPane;
    }

    public void setComponents(Component component, Component component2, Component component3) {
        this.left = component;
        this.leftSplitPane.setLeftComponent(this.left);
        this.middle = component2;
        this.leftSplitPane.setRightComponent(this.middle);
        this.rightSplitPane.setLeftComponent(this.leftSplitPane);
        this.right = component3;
        this.rightSplitPane.setRightComponent(this.right);
        this.add((Component)this.rightSplitPane, "Center");
        this.resize();
    }

    public void setComponentWidth(Component component, float f) {
        this.widths.put(component, Float.valueOf(f));
    }

    public void resize() {
        if (this.left != null && this.middle != null && this.right != null) {
            this.setDividerLocationToComponentWidth(this.rightSplitPane, this.getWidth(this.left) + this.getWidth(this.middle));
            this.setDividerLocationToComponentWidth(this.leftSplitPane, this.getWidth(this.left));
        } else if (this.left != null && this.middle != null) {
            this.setDividerLocationToComponentWidth(this.rightSplitPane, this.getWidth(this.left));
        } else if (this.left != null && this.right != null) {
            this.setDividerLocationToComponentWidth(this.rightSplitPane, this.getWidth(this.left));
        } else if (this.middle != null && this.right != null) {
            this.setDividerLocationToComponentWidth(this.rightSplitPane, this.getWidth(this.middle));
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CustomSplitPanel.this.left != null && CustomSplitPanel.this.middle != null && CustomSplitPanel.this.right != null) {
                    CustomSplitPanel.this.setDividerLocationToComponentWidth(CustomSplitPanel.this.rightSplitPane, CustomSplitPanel.this.getWidth(CustomSplitPanel.this.left) + CustomSplitPanel.this.getWidth(CustomSplitPanel.this.middle));
                    CustomSplitPanel.this.setDividerLocationToComponentWidth(CustomSplitPanel.this.leftSplitPane, CustomSplitPanel.this.getWidth(CustomSplitPanel.this.left));
                } else if (CustomSplitPanel.this.left != null && CustomSplitPanel.this.middle != null) {
                    CustomSplitPanel.this.setDividerLocationToComponentWidth(CustomSplitPanel.this.rightSplitPane, CustomSplitPanel.this.getWidth(CustomSplitPanel.this.left));
                } else if (CustomSplitPanel.this.left != null && CustomSplitPanel.this.right != null) {
                    CustomSplitPanel.this.setDividerLocationToComponentWidth(CustomSplitPanel.this.rightSplitPane, CustomSplitPanel.this.getWidth(CustomSplitPanel.this.left));
                } else if (CustomSplitPanel.this.middle != null && CustomSplitPanel.this.right != null) {
                    CustomSplitPanel.this.setDividerLocationToComponentWidth(CustomSplitPanel.this.rightSplitPane, CustomSplitPanel.this.getWidth(CustomSplitPanel.this.middle));
                }
            }
        });
    }

    public void setDividerLocationToComponentWidth(JSplitPane jSplitPane, int n) {
        jSplitPane.setDividerLocation(n);
    }

    public int getWidth(Component component) {
        Float f = this.widths.get(component);
        if (f != null) {
            return (int)f.floatValue();
        }
        return 0;
    }

    public void setComponent(Component component, int n) {
        switch (n) {
            case 0: {
                this.setLeftComponent(component);
                break;
            }
            case 1: {
                this.setMiddleComponent(component);
                break;
            }
            case 2: {
                this.setRightComponent(component);
            }
        }
    }

    public Component getComponentAtIndex(int n) {
        switch (n) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.middle;
            }
            case 2: {
                return this.right;
            }
        }
        return null;
    }

    public void setLeftComponent(Component component) {
        if (component == null) {
            this.removeLeftComponent();
            return;
        }
        if (this.middle != null && this.right != null) {
            this.rightSplitPane.setLeftComponent(null);
            this.leftSplitPane.setLeftComponent(component);
            this.leftSplitPane.setRightComponent(this.middle);
            this.rightSplitPane.setLeftComponent(this.leftSplitPane);
        } else if (this.middle != null) {
            this.remove(this.middle);
            this.rightSplitPane.setLeftComponent(component);
            this.rightSplitPane.setRightComponent(this.middle);
            this.add(this.rightSplitPane);
        } else if (this.right != null) {
            this.remove(this.right);
            this.rightSplitPane.setLeftComponent(component);
            this.rightSplitPane.setRightComponent(this.right);
            this.add(this.rightSplitPane);
        } else if (this.left == null) {
            this.add(component);
        }
        this.left = component;
        this.resize();
    }

    public void removeLeftComponent() {
        if (this.middle != null && this.right != null) {
            this.leftSplitPane.setLeftComponent(null);
            this.leftSplitPane.setRightComponent(null);
            this.rightSplitPane.setLeftComponent(this.middle);
        } else if (this.middle != null) {
            this.rightSplitPane.setLeftComponent(null);
            this.rightSplitPane.setRightComponent(null);
            this.remove(this.rightSplitPane);
            this.add(this.middle);
        } else if (this.right != null) {
            this.rightSplitPane.setLeftComponent(null);
            this.rightSplitPane.setRightComponent(null);
            this.remove(this.rightSplitPane);
            this.add(this.right);
        }
        this.left = null;
        this.resize();
    }

    public void setMiddleComponent(Component component) {
        if (component == null) {
            this.removeMiddleComponent();
            return;
        }
        if (this.left != null && this.right != null) {
            this.rightSplitPane.setLeftComponent(this.leftSplitPane);
            this.leftSplitPane.setLeftComponent(this.left);
            this.leftSplitPane.setRightComponent(component);
        } else if (this.left != null) {
            this.remove(this.left);
            this.rightSplitPane.setLeftComponent(this.left);
            this.rightSplitPane.setRightComponent(component);
            this.add(this.rightSplitPane);
        } else if (this.right != null) {
            this.remove(this.right);
            this.rightSplitPane.setLeftComponent(component);
            this.rightSplitPane.setRightComponent(this.right);
            this.add(this.rightSplitPane);
        } else if (this.middle == null) {
            this.add(component);
        }
        this.middle = component;
        this.resize();
    }

    public void removeMiddleComponent() {
        if (this.left != null && this.right != null) {
            this.leftSplitPane.setLeftComponent(null);
            this.leftSplitPane.setRightComponent(null);
            this.rightSplitPane.setLeftComponent(this.left);
        } else if (this.left != null) {
            this.rightSplitPane.setLeftComponent(null);
            this.rightSplitPane.setRightComponent(null);
            this.remove(this.rightSplitPane);
            this.add(this.left);
        } else if (this.right != null) {
            this.rightSplitPane.setLeftComponent(null);
            this.rightSplitPane.setRightComponent(null);
            this.remove(this.rightSplitPane);
            this.add(this.right);
        }
        this.middle = null;
        this.resize();
    }

    public void setRightComponent(Component component) {
        if (component == null) {
            this.removeRightComponent();
            return;
        }
        if (this.left != null && this.middle != null) {
            this.rightSplitPane.setLeftComponent(null);
            this.rightSplitPane.setRightComponent(null);
            this.leftSplitPane.setLeftComponent(this.left);
            this.leftSplitPane.setRightComponent(this.middle);
            this.rightSplitPane.setLeftComponent(this.leftSplitPane);
            this.rightSplitPane.setRightComponent(component);
        } else if (this.left != null) {
            this.remove(this.left);
            this.rightSplitPane.setLeftComponent(this.left);
            this.rightSplitPane.setRightComponent(component);
            this.add(this.rightSplitPane);
        } else if (this.middle != null) {
            this.remove(this.middle);
            this.rightSplitPane.setLeftComponent(this.middle);
            this.rightSplitPane.setRightComponent(component);
            this.add(this.rightSplitPane);
        } else if (this.right == null) {
            this.add(component);
        }
        this.right = component;
        this.resize();
    }

    public void removeRightComponent() {
        if (this.left != null && this.middle != null) {
            this.leftSplitPane.setLeftComponent(null);
            this.leftSplitPane.setRightComponent(null);
            this.rightSplitPane.setLeftComponent(this.left);
            this.rightSplitPane.setRightComponent(this.middle);
        } else if (this.left != null) {
            this.rightSplitPane.setLeftComponent(null);
            this.rightSplitPane.setRightComponent(null);
            this.remove(this.rightSplitPane);
            this.add(this.left);
        } else if (this.middle != null) {
            this.rightSplitPane.setLeftComponent(null);
            this.rightSplitPane.setRightComponent(null);
            this.remove(this.rightSplitPane);
            this.add(this.middle);
        }
        this.right = null;
        this.resize();
    }
}

