/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.stats;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsManager;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.foundation.XJUtils;

public class StatisticsReporter {
    public static final String URL_REGISTER = "http://www.antlr.org/stats/register?";
    public static final String URL_SEND_STATS = "http://www.antlr.org/stats/notify?";
    public static final String TYPE_GUI = "antlrworks";
    public static final String TYPE_GRAMMAR = "grammar";
    public static final String TYPE_RUNTIME = "runtime";
    protected String error = null;
    protected boolean cancel = false;

    public String getError() {
        return this.error;
    }

    public String fetchIDFromServer() {
        String string;
        BufferedReader bufferedReader;
        URLConnection uRLConnection;
        HashMap hashMap = AWPrefs.getPersonalInfo();
        if (hashMap == null) {
            System.err.println("No personal info available. Sending blank data to request a new ID from ANTLR's server.");
            hashMap = new HashMap();
        }
        StringBuffer stringBuffer = new StringBuffer(URL_REGISTER);
        stringBuffer.append("who=");
        stringBuffer.append(hashMap.get("who"));
        stringBuffer.append("&sector=");
        stringBuffer.append(hashMap.get("sector"));
        stringBuffer.append("&devtool=");
        stringBuffer.append(hashMap.get("devtool"));
        stringBuffer.append("&yearslang=");
        stringBuffer.append(hashMap.get("yearslang"));
        stringBuffer.append("&yearsprog=");
        stringBuffer.append(hashMap.get("yearsprog"));
        stringBuffer.append("&residing=");
        stringBuffer.append(XJUtils.encodeToURL((String)hashMap.get("residing"), "-"));
        stringBuffer.append("&caffeine=");
        stringBuffer.append(XJUtils.encodeToURL((String)hashMap.get("caffeine"), "-"));
        stringBuffer.append("&version=");
        stringBuffer.append(XJUtils.encodeToURL(XJApplication.getAppVersionShort(), "-"));
        try {
            URL uRL = new URL(stringBuffer.toString());
            uRLConnection = uRL.openConnection();
        }
        catch (Exception exception) {
            this.error = exception.toString();
            return null;
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        }
        catch (IOException iOException) {
            this.error = iOException.toString();
            return null;
        }
        try {
            string = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.error = iOException.toString();
            return null;
        }
        return string;
    }

    public String getID() {
        String string = AWPrefs.getServerID();
        if (string == null || string.length() == 0) {
            string = this.fetchIDFromServer();
            if (string == null || string.length() == 0) {
                return null;
            }
            AWPrefs.setServerID(string);
        }
        return string;
    }

    public void cancel() {
        this.cancel = true;
    }

    public boolean submitStats(StatisticsManager statisticsManager) {
        this.cancel = false;
        for (int i = 0; i < statisticsManager.getStatsCount(); ++i) {
            if (!this.submitStats(this.getID(), statisticsManager.type, statisticsManager.getRawString(i))) {
                return false;
            }
            if (!this.cancel) continue;
            return true;
        }
        return true;
    }

    protected boolean submitStats(String string, String string2, String string3) {
        if (string == null) {
            this.error = "cannot submit stat with a null id";
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(URL_SEND_STATS);
        stringBuffer.append("ID=");
        stringBuffer.append(string);
        stringBuffer.append("&type=");
        stringBuffer.append(string2);
        stringBuffer.append("&data=");
        stringBuffer.append(XJUtils.encodeToURL(string3));
        boolean bl = false;
        try {
            URL uRL = new URL(stringBuffer.toString());
            URLConnection uRLConnection = uRL.openConnection();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            bl = bufferedReader.readLine().equalsIgnoreCase("OK");
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.error = iOException.toString();
        }
        return bl;
    }
}

