/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.stats;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.debug.Profiler;
import org.antlr.tool.GrammarReport;
import org.antlr.works.stats.StatisticsAW;

public class StatisticsManager {
    public static final int MAX_REPORTS = 1000;
    protected String type;
    protected List<String> rawLines = new ArrayList<String>();

    public StatisticsManager(String string) {
        this.type = string;
        this.load();
    }

    public int getStatsCount() {
        return this.rawLines.size();
    }

    public String getReadableString(int n) {
        if (n < 0 || n >= this.rawLines.size()) {
            return null;
        }
        String string = this.rawLines.get(n);
        if (this.type.equals("grammar")) {
            return GrammarReport.toString(string);
        }
        if (this.type.equals("runtime")) {
            return Profiler.toString(string);
        }
        return StatisticsAW.shared().getReadableString();
    }

    public String getRawString(int n) {
        if (n < 0 || n >= this.rawLines.size()) {
            return null;
        }
        return this.rawLines.get(n);
    }

    public boolean load() {
        this.rawLines.clear();
        if (this.type.equals("grammar")) {
            return this.loadGrammar();
        }
        if (this.type.equals("runtime")) {
            return this.loadRuntime();
        }
        if (this.type.equals("antlrworks")) {
            return this.loadGUI();
        }
        return false;
    }

    protected boolean loadGUI() {
        this.addRawLine(StatisticsAW.shared().getRawString());
        return true;
    }

    protected boolean loadGrammar() {
        return this.loadFromFile(StatisticsManager.getAbsoluteFileName("grammar.stats"));
    }

    protected boolean loadRuntime() {
        return this.loadFromFile(StatisticsManager.getAbsoluteFileName("runtime.stats"));
    }

    protected boolean loadFromFile(String string) {
        if (string == null) {
            return false;
        }
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((string2 = bufferedReader.readLine()) != null) {
                this.addRawLine(string2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    protected void addRawLine(String string) {
        this.rawLines.add(string);
        if (this.rawLines.size() > 1000) {
            this.rawLines.remove(0);
        }
    }

    public void reset() {
        StatisticsManager.reset(this.type);
    }

    public static void reset(String string) {
        if (string.equals("grammar")) {
            String string2 = StatisticsManager.getAbsoluteFileName("grammar.stats");
            new File(string2).delete();
        } else if (string.equals("runtime")) {
            String string3 = StatisticsManager.getAbsoluteFileName("runtime.stats");
            new File(string3).delete();
        } else if (string.equals("antlrworks")) {
            StatisticsAW.shared().reset();
        }
    }

    public static String getAbsoluteFileName(String string) {
        return System.getProperty("user.home") + File.separator + "antlrworks" + File.separator + string;
    }
}

