/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.scm.p4;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.scm.SCM;
import org.antlr.works.scm.SCMDelegate;
import org.antlr.works.utils.Console;

public class P4
implements SCM {
    protected static final int CMD_EDIT = 1;
    protected static final int CMD_ADD = 2;
    protected static final int CMD_REVERT = 3;
    protected static final int CMD_DELETE = 4;
    protected static final int CMD_SUBMIT = 5;
    protected static final int CMD_SYNC = 6;
    protected static final int CMD_FSTAT = 7;
    protected SCMDelegate delegate = null;
    protected String fileStatus = null;
    protected P4Scheduler scheduler = new P4Scheduler();
    protected P4CommandCompletion lastCompletion = null;
    protected Console console;
    private final Object lock = new Object();

    public P4(SCMDelegate sCMDelegate, Console console) {
        this.delegate = sCMDelegate;
        this.console = console;
    }

    public synchronized void queryFileStatus(String string) {
        this.runCommand(new P4Command(7, new String[]{"fstat", string}, null));
    }

    public synchronized void editFile(String string) {
        this.scheduleCommand(new P4Command(1, new String[]{"edit", string}, null));
        this.queryFileStatus(string);
    }

    public synchronized void addFile(String string) {
        this.scheduleCommand(new P4Command(2, new String[]{"add", string}, null));
        this.queryFileStatus(string);
    }

    public synchronized void deleteFile(String string) {
        this.scheduleCommand(new P4Command(4, new String[]{"delete", string}, null));
        this.queryFileStatus(string);
    }

    public synchronized void revertFile(String string) {
        this.scheduleCommand(new P4Command(3, new String[]{"revert", string}, null));
        this.queryFileStatus(string);
    }

    public synchronized void submitFile(String string, String string2, boolean bl) {
        this.scheduleCommand(new P4Command(7, new String[]{"fstat", string}, null));
        this.scheduleCommand(new P4CommandSubmit(string, string2, bl));
        this.queryFileStatus(string);
    }

    public synchronized void sync() {
        this.runCommand(new P4Command(6, new String[]{"sync"}, null));
    }

    public synchronized boolean isFileWritable() {
        if (this.fileStatus == null) {
            return true;
        }
        return this.fileStatus.equals("edit");
    }

    public synchronized String getFileStatus() {
        return this.fileStatus;
    }

    public synchronized boolean hasErrors() {
        if (this.lastCompletion == null) {
            return false;
        }
        return this.lastCompletion.hasErrors();
    }

    public synchronized String getErrorsDescription() {
        if (this.lastCompletion == null) {
            return "";
        }
        return this.lastCompletion.errorsDescription();
    }

    public void resetErrors() {
        this.lastCompletion = null;
    }

    protected void runCommand(P4Command p4Command) {
        this.scheduleCommand(p4Command);
        this.scheduleLaunch();
    }

    protected void scheduleCommand(P4Command p4Command) {
        this.scheduler.scheduleCommand(p4Command);
    }

    protected synchronized void scheduleLaunch() {
        if (!this.scheduler.isRunning()) {
            this.scheduler.start();
        }
    }

    protected class StreamWatcher
    extends Thread {
        public InputStream is;
        public String type;
        public StreamWatcherDelegate delegate;

        public StreamWatcher(InputStream inputStream, String string, StreamWatcherDelegate streamWatcherDelegate) {
            this.is = inputStream;
            this.type = string;
            this.delegate = streamWatcherDelegate;
        }

        public void run() {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.is));
                while ((string = bufferedReader.readLine()) != null) {
                    if (this.delegate == null) continue;
                    this.delegate.streamWatcherDidReceiveText(this, string);
                }
            }
            catch (IOException iOException) {
                P4.this.console.print(iOException);
            }
            if (this.delegate != null) {
                this.delegate.streamWatcherDidEnd(this);
            }
        }
    }

    protected static interface StreamWatcherDelegate {
        public void streamWatcherDidReceiveText(StreamWatcher var1, String var2);

        public void streamWatcherDidEnd(StreamWatcher var1);
    }

    protected class P4CommandCompletion
    implements StreamWatcherDelegate {
        public P4Results results;
        public int commandID;
        public P4CommandCompletionDelegate delegate;
        public StreamWatcher errorStreamWatcher;
        public StreamWatcher inputStreamWatcher;
        public int processExitCode;
        public boolean processTerminated;

        public P4CommandCompletion(Process process, int n, P4CommandCompletionDelegate p4CommandCompletionDelegate) {
            this.results = new P4Results();
            this.commandID = 0;
            this.delegate = null;
            this.errorStreamWatcher = null;
            this.inputStreamWatcher = null;
            this.processExitCode = 0;
            this.processTerminated = false;
            this.results.reset();
            this.commandID = n;
            this.delegate = p4CommandCompletionDelegate;
            this.errorStreamWatcher = new StreamWatcher(process.getErrorStream(), "error", this);
            this.errorStreamWatcher.start();
            this.inputStreamWatcher = new StreamWatcher(process.getInputStream(), "input", this);
            this.inputStreamWatcher.start();
        }

        public boolean hasErrors() {
            return this.results.get(0).size() > 0;
        }

        public String errorsDescription() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.results.get(0).iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
            }
            return stringBuffer.toString();
        }

        public String getObjectForKey(int n, String string) {
            for (String string2 : this.results.get(n)) {
                if (!string2.startsWith(string)) continue;
                return string2.substring(string.length() + 1).trim();
            }
            return null;
        }

        public synchronized void processTerminated() {
            this.processTerminated = true;
            this.notifyIfCommandCompleted();
        }

        public synchronized void notifyIfCommandCompleted() {
            if (this.errorStreamWatcher == null && this.inputStreamWatcher == null && this.processTerminated && this.delegate != null) {
                this.delegate.commandDidComplete(this);
            }
        }

        public synchronized void streamWatcherDidReceiveText(StreamWatcher streamWatcher, String string) {
            if (P4.this.delegate != null) {
                P4.this.delegate.scmLog(string);
            }
            int n = string.indexOf(58);
            String string2 = string;
            if (n != -1) {
                string2 = string.substring(n + 1);
            }
            if (string.startsWith("error:")) {
                this.results.add(0, string2);
            } else if (string.startsWith("warning:")) {
                this.results.add(1, string2);
            } else if (string.startsWith("text:")) {
                this.results.add(2, string2);
            } else if (string.startsWith("info:")) {
                this.results.add(3, string2);
            } else if (string.startsWith("exit:")) {
                this.results.add(4, string2);
            } else {
                this.results.add(5, string2);
            }
        }

        public synchronized void streamWatcherDidEnd(StreamWatcher streamWatcher) {
            if (streamWatcher == this.errorStreamWatcher) {
                this.errorStreamWatcher = null;
            }
            if (streamWatcher == this.inputStreamWatcher) {
                this.inputStreamWatcher = null;
            }
            this.notifyIfCommandCompleted();
        }
    }

    protected static interface P4CommandCompletionDelegate {
        public void commandDidComplete(P4CommandCompletion var1);
    }

    protected class P4Results {
        public static final int ERROR = 0;
        public static final int WARNING = 1;
        public static final int TEXT = 2;
        public static final int INFO = 3;
        public static final int EXIT = 4;
        public static final int OTHER = 5;
        protected List[] texts = new List[6];

        public P4Results() {
            for (int i = 0; i < this.texts.length; ++i) {
                this.texts[i] = new ArrayList();
            }
        }

        public void reset() {
            for (int i = 0; i < this.texts.length; ++i) {
                this.texts[i].clear();
            }
        }

        public void add(int n, String string) {
            this.texts[n].add(string.trim());
        }

        public List get(int n) {
            return this.texts[n];
        }
    }

    protected class P4CommandSubmit
    extends P4Command {
        public String file;
        public String description;
        public boolean remainOpen;

        public P4CommandSubmit(String string, String string2, boolean bl) {
            super(5, null, null);
            this.file = string;
            this.description = string2;
            this.remainOpen = bl;
        }

        public void run(P4Command p4Command, P4CommandCompletionDelegate p4CommandCompletionDelegate) {
            String string = p4Command.completion.getObjectForKey(5, "depotFile");
            if (string != null) {
                String[] stringArray = this.remainOpen ? new String[]{"submit", "-r", "-i"} : new String[]{"submit", "-i"};
                this.runCommand(5, stringArray, new String[]{"Change: new", "Client: " + AWPrefs.getP4Client(), "User: " + AWPrefs.getP4User(), "Description:\n\t" + this.description, "Files:\n\t" + string}, p4CommandCompletionDelegate);
            }
        }
    }

    protected class P4Command {
        public int commandID;
        public String[] commands;
        public String[] inputArguments;
        public P4CommandCompletion completion = null;

        public P4Command(int n, String[] stringArray, String[] stringArray2) {
            this.commandID = n;
            this.commands = stringArray;
            this.inputArguments = stringArray2;
        }

        public void run(P4Command p4Command, P4CommandCompletionDelegate p4CommandCompletionDelegate) {
            this.runCommand(this.commandID, this.commands, this.inputArguments, p4CommandCompletionDelegate);
        }

        protected boolean runCommand(int n, String[] stringArray, String[] stringArray2, P4CommandCompletionDelegate p4CommandCompletionDelegate) {
            String[] stringArray3 = this.buildCommand(stringArray);
            boolean bl = false;
            try {
                Process process = Runtime.getRuntime().exec(stringArray3);
                this.completion = new P4CommandCompletion(process, n, p4CommandCompletionDelegate);
                if (stringArray2 != null) {
                    OutputStream outputStream = process.getOutputStream();
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                    BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                    for (int i = 0; i < stringArray2.length; ++i) {
                        bufferedWriter.write(stringArray2[i]);
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                bl = (this.completion.processExitCode = process.waitFor()) == 0;
                this.completion.processTerminated();
            }
            catch (Exception exception) {
                P4.this.console.print(exception);
            }
            return bl;
        }

        protected String[] buildCommand(String[] stringArray) {
            String[] stringArray2 = new String[10 + stringArray.length];
            int n = 0;
            stringArray2[n++] = AWPrefs.getP4ExecPath();
            stringArray2[n++] = "-s";
            stringArray2[n++] = "-p";
            stringArray2[n++] = AWPrefs.getP4Port();
            stringArray2[n++] = "-u";
            stringArray2[n++] = AWPrefs.getP4User();
            stringArray2[n++] = "-P";
            stringArray2[n++] = AWPrefs.getP4Password();
            stringArray2[n++] = "-c";
            stringArray2[n++] = AWPrefs.getP4Client();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[n++] = stringArray[i];
            }
            return stringArray2;
        }
    }

    protected class P4Scheduler
    implements Runnable,
    P4CommandCompletionDelegate {
        protected List<P4Command> scheduledCommands = new ArrayList<P4Command>();
        protected P4Command runningCommand = null;

        protected P4Scheduler() {
        }

        public void start() {
            new Thread(this).start();
        }

        public void run() {
            this.scheduleRun(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void scheduleCommand(P4Command p4Command) {
            Object object = P4.this.lock;
            synchronized (object) {
                this.scheduledCommands.add(p4Command);
            }
        }

        protected synchronized boolean isRunning() {
            return this.runningCommand != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void scheduleRun(P4Command p4Command) {
            if (this.runningCommand != null && this.runningCommand != p4Command) {
                return;
            }
            Object object = P4.this.lock;
            synchronized (object) {
                if (this.scheduledCommands.isEmpty()) {
                    this.runningCommand = null;
                } else {
                    this.runningCommand = this.scheduledCommands.get(0);
                    this.scheduledCommands.remove(0);
                }
            }
            if (this.runningCommand == null) {
                this.schedulerDidComplete();
            } else {
                this.runningCommand.run(p4Command, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandDidComplete(P4CommandCompletion p4CommandCompletion) {
            if (p4CommandCompletion.commandID == 7) {
                P4.this.fileStatus = p4CommandCompletion.getObjectForKey(5, "action");
                if (P4.this.fileStatus == null) {
                    P4.this.fileStatus = p4CommandCompletion.hasErrors() ? "?" : "closed";
                }
                if (P4.this.delegate != null) {
                    P4.this.delegate.scmFileStatusDidChange(P4.this.fileStatus);
                }
            }
            P4.this.lastCompletion = p4CommandCompletion;
            if (p4CommandCompletion.hasErrors()) {
                Object object = P4.this.lock;
                synchronized (object) {
                    this.scheduledCommands.clear();
                    this.runningCommand = null;
                    P4.this.delegate.scmCommandsDidComplete();
                }
            } else {
                this.scheduleRun(this.runningCommand);
            }
        }

        public void schedulerDidComplete() {
            if (P4.this.delegate != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        P4.this.delegate.scmCommandsDidComplete();
                    }
                });
            }
        }
    }
}

