/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.project;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.antlr.works.components.project.CContainerProject;

public class ProjectToolbar {
    public static final int CUSTOM_TOOLBAR_INDEX = 1;
    public Box toolbar;
    public JButton clean;
    public JButton buildFile;
    public JButton buildAll;
    public JButton run;
    public JPanel customToolbar;
    public CContainerProject project;

    public ProjectToolbar(CContainerProject cContainerProject) {
        this.project = cContainerProject;
        this.createInterface();
        this.addActions();
    }

    public JComponent getToolbar() {
        return this.toolbar;
    }

    public void createInterface() {
        this.customToolbar = new JPanel();
        this.toolbar = Box.createHorizontalBox();
        this.toolbar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
        this.toolbar.add(Box.createHorizontalStrut(5));
        this.toolbar.add(this.customToolbar);
        this.toolbar.add(Box.createHorizontalGlue());
        this.clean = (JButton)this.createNewButton("Clean", "Clean Project Directory");
        this.toolbar.add(this.clean);
        this.buildFile = (JButton)this.createNewButton("Build File", "Build Current File");
        this.toolbar.add(this.buildFile);
        this.buildAll = (JButton)this.createNewButton("Build All", "Build Project");
        this.toolbar.add(this.buildAll);
        this.run = (JButton)this.createNewButton("Run", "Run Project");
        this.toolbar.add(this.run);
    }

    public void setCustomToolbar(JComponent jComponent) {
        if (jComponent != null) {
            if (jComponent.getBorder() != null) {
                jComponent.setBorder(null);
            }
            this.toolbar.remove(1);
            this.toolbar.add((Component)jComponent, 1);
        } else {
            this.toolbar.remove(1);
            this.toolbar.add((Component)this.customToolbar, 1);
        }
        this.toolbar.revalidate();
        this.toolbar.repaint();
    }

    public void addActions() {
        this.clean.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectToolbar.this.project.clean();
            }
        });
        this.buildFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectToolbar.this.project.buildFile();
            }
        });
        this.buildAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectToolbar.this.project.buildAll();
            }
        });
        this.run.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectToolbar.this.project.run();
            }
        });
    }

    public AbstractButton createNewButton(String string, String string2) {
        JButton jButton = new JButton(string);
        jButton.setToolTipText(string2);
        jButton.setFocusable(false);
        return jButton;
    }

    public AbstractButton createNewButton(ImageIcon imageIcon, String string, boolean bl) {
        AbstractButton abstractButton = bl ? new JToggleButton(imageIcon) : new JButton(imageIcon);
        abstractButton.setToolTipText(string);
        Dimension dimension = new Dimension(32, 32);
        abstractButton.setMinimumSize(dimension);
        abstractButton.setMaximumSize(dimension);
        abstractButton.setPreferredSize(dimension);
        abstractButton.setFocusable(false);
        return abstractButton;
    }
}

