/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.project;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import org.antlr.works.components.ComponentContainer;
import org.antlr.works.components.project.CContainerProject;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFileItem
implements Comparable {
    public static final String FILE_GRAMMAR_EXTENSION = ".g";
    public static final String FILE_JAVA_EXTENSION = ".java";
    public static final String FILE_STG_EXTENSION = ".stg";
    public static final String FILE_ST_EXTENSION = ".st";
    public static final String FILE_MANTRA_EXTENSION = ".om";
    public static final String FILE_TEXT_EXTENSION = ".txt";
    public static final String FILE_TYPE_GRAMMAR = "FILE_TYPE_GRAMMAR";
    public static final String FILE_TYPE_JAVA = "FILE_TYPE_JAVA";
    public static final String FILE_TYPE_STG = "FILE_TYPE_STG";
    public static final String FILE_TYPE_ST = "FILE_TYPE_ST";
    public static final String FILE_TYPE_MANTRA = "FILE_TYPE_MANTRA";
    public static final String FILE_TYPE_TEXT = "FILE_TYPE_TEXT";
    public static final String FILE_TYPE_UNKNOWN = "FILE_TYPE_UNKNOWN";
    protected CContainerProject project;
    protected ComponentContainer container;
    protected String fileName;
    protected String fileType;
    protected boolean opened;
    protected int tabIndex;
    protected Map containerData;
    protected static final String KEY_FILE_NAME = "KEY_FILE_NAME";
    protected static final String KEY_FILE_OPENED = "KEY_FILE_OPENED";
    protected static final String KEY_TAB_INDEX = "KEY_TAB_INDEX";
    protected static final String KEY_CONTAINER_DATA = "KEY_CONTAINER_DATA";

    public ProjectFileItem(CContainerProject cContainerProject, String string) {
        this.setFileName(string);
        this.project = cContainerProject;
    }

    public static String getFileType(String string) {
        if (string.endsWith(FILE_GRAMMAR_EXTENSION)) {
            return FILE_TYPE_GRAMMAR;
        }
        if (string.endsWith(FILE_STG_EXTENSION)) {
            return FILE_TYPE_STG;
        }
        if (string.endsWith(FILE_ST_EXTENSION)) {
            return FILE_TYPE_ST;
        }
        if (string.endsWith(FILE_JAVA_EXTENSION)) {
            return FILE_TYPE_JAVA;
        }
        if (string.endsWith(FILE_MANTRA_EXTENSION)) {
            return FILE_TYPE_MANTRA;
        }
        if (string.endsWith(FILE_TEXT_EXTENSION)) {
            return FILE_TYPE_TEXT;
        }
        return FILE_TYPE_UNKNOWN;
    }

    public static String getFileTypeName(String string) {
        if (string.equals(FILE_TYPE_GRAMMAR)) {
            return "Grammar";
        }
        if (string.equals(FILE_TYPE_STG)) {
            return "ST Group";
        }
        if (string.equals(FILE_TYPE_ST)) {
            return "ST";
        }
        if (string.equals(FILE_TYPE_JAVA)) {
            return "Java";
        }
        if (string.equals(FILE_TYPE_MANTRA)) {
            return "Mantra";
        }
        if (string.equals(FILE_TYPE_TEXT)) {
            return "Text";
        }
        return "Unkown";
    }

    public void setOpened(boolean bl) {
        this.opened = bl;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setTabIndex(int n) {
        this.tabIndex = n;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public boolean isDirty() {
        if (this.container != null) {
            return this.container.getDocument().isDirty();
        }
        return false;
    }

    public boolean save() {
        if (this.container != null && this.container.getDocument().isDirty()) {
            return this.container.getDocument().performSave(false);
        }
        return false;
    }

    public void close() {
        if (this.container != null) {
            this.container.close();
        }
    }

    public void setComponentContainer(ComponentContainer componentContainer) {
        this.container = componentContainer;
        this.container.setPersistentData(this.containerData);
    }

    public ComponentContainer getComponentContainer() {
        return this.container;
    }

    public void setContainerPersistentData(Map map) {
        this.containerData = map;
    }

    public Map getContainerPersistentData() {
        if (this.container == null) {
            return null;
        }
        return this.container.getPersistentData();
    }

    public JPanel getEditorPanel() {
        if (this.container == null) {
            return null;
        }
        return this.container.getEditor().getPanel();
    }

    public void setFileName(String string) {
        this.fileName = string;
        this.fileType = ProjectFileItem.getFileType(string);
    }

    public String getFilePath() {
        return XJUtils.concatPath(this.project.getSourcePath(), this.fileName);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void windowActivated() {
        if (this.container != null) {
            this.container.getEditor().componentActivated();
        }
    }

    public boolean handleExternalModification() {
        if (this.container == null) {
            return false;
        }
        if (this.container.getDocument().isModifiedOnDisk()) {
            this.container.getEditor().componentDocumentContentChanged();
            this.container.getDocument().synchronizeLastModifiedDate();
            return true;
        }
        return false;
    }

    public void setPersistentData(Map map) {
        this.setFileName((String)map.get(KEY_FILE_NAME));
        this.setOpened((Boolean)map.get(KEY_FILE_OPENED));
        this.setTabIndex((Integer)map.get(KEY_TAB_INDEX));
        this.setContainerPersistentData((Map)map.get(KEY_CONTAINER_DATA));
    }

    public Map<String, Object> getPersistentData() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(KEY_FILE_NAME, this.fileName);
        hashMap.put(KEY_FILE_OPENED, this.opened);
        hashMap.put(KEY_TAB_INDEX, this.tabIndex);
        Map map = this.getContainerPersistentData();
        if (map != null) {
            hashMap.put(KEY_CONTAINER_DATA, map);
        }
        return hashMap;
    }

    public int hashCode() {
        return this.fileName.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ProjectFileItem) {
            ProjectFileItem projectFileItem = (ProjectFileItem)object;
            return this.fileName.equals(projectFileItem.fileName);
        }
        return false;
    }

    public int compareTo(Object object) {
        if (object instanceof ProjectFileItem) {
            ProjectFileItem projectFileItem = (ProjectFileItem)object;
            return this.fileName.compareTo(projectFileItem.fileName);
        }
        return 1;
    }

    public String toString() {
        return this.getFileName();
    }
}

