/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.project;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.works.project.ProjectExplorer;
import org.antlr.works.project.ProjectFileItem;
import org.antlr.xjlib.foundation.XJUtils;

public class ProjectExplorerLoader {
    protected Map groups = new HashMap();
    protected String sourcePath;
    protected ProjectExplorer explorer;

    public ProjectExplorerLoader(ProjectExplorer projectExplorer) {
        this.explorer = projectExplorer;
    }

    public boolean reload() {
        boolean bl = false;
        if (this.sourcePath == null || !this.sourcePath.equals(this.explorer.project.getSourcePath())) {
            this.groups.clear();
            this.sourcePath = this.explorer.project.getSourcePath();
            bl = true;
        }
        if (this.sourcePath == null) {
            return bl;
        }
        List list = this.getAllFiles();
        for (Comparable<File> comparable : XJUtils.sortedFilesInPath(this.sourcePath)) {
            String string = ((File)comparable).getName();
            String string2 = ProjectFileItem.getFileType(string);
            if (string2.equals("FILE_TYPE_UNKNOWN")) continue;
            ProjectFileItem projectFileItem = this.addFileOfType(string, string2);
            list.remove(projectFileItem);
        }
        for (Comparable<File> comparable : list) {
            this.explorer.project.closeFileItem((ProjectFileItem)comparable);
            this.removeFileOfType(((ProjectFileItem)comparable).getFileName(), ((ProjectFileItem)comparable).getFileType());
        }
        this.sortFilesInGroups();
        return bl;
    }

    public void sortFilesInGroups() {
        for (String string : this.groups.keySet()) {
            List list = (List)this.groups.get(string);
            if (list == null || list.isEmpty()) continue;
            Collections.sort(list);
        }
    }

    public ProjectFileItem addFileOfType(String string, String string2) {
        List list = this.getFiles(string2);
        for (ProjectFileItem projectFileItem : list) {
            if (!projectFileItem.getFileName().equals(string)) continue;
            return projectFileItem;
        }
        ProjectFileItem projectFileItem = new ProjectFileItem(this.explorer.project, string);
        list.add(projectFileItem);
        return projectFileItem;
    }

    public void removeFileOfType(String string, String string2) {
        List list = this.getFiles(string2);
        for (ProjectFileItem projectFileItem : list) {
            if (!projectFileItem.getFileName().equals(string)) continue;
            list.remove(projectFileItem);
            break;
        }
    }

    public List getGroups() {
        ArrayList arrayList = new ArrayList(this.groups.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    public List getAllFiles() {
        ArrayList arrayList = new ArrayList();
        for (List list : this.groups.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public ProjectFileItem getFileItemForFileName(String string) {
        for (List list : this.groups.values()) {
            for (ProjectFileItem projectFileItem : list) {
                if (!projectFileItem.getFileName().equals(string)) continue;
                return projectFileItem;
            }
        }
        return null;
    }

    public List getFiles(String string) {
        ArrayList arrayList = (ArrayList)this.groups.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.groups.put(string, arrayList);
        }
        return arrayList;
    }
}

