/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.project;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.antlr.works.components.project.CContainerProject;
import org.antlr.works.project.ProjectBuildList;
import org.antlr.works.project.ProjectExplorerLoader;
import org.antlr.works.project.ProjectFileItem;
import org.antlr.xjlib.appkit.swing.XJTree;

public class ProjectExplorer {
    protected CContainerProject project;
    protected JComponent container;
    protected ProjectExplorerLoader loader;
    protected XJTree filesTree;
    protected DefaultMutableTreeNode filesTreeRootNode;
    protected DefaultTreeModel filesTreeModel;
    public List<ProjectFileItem> openedFiles = new ArrayList<ProjectFileItem>();
    public static final String KEY_FILE_ITEMS = "KEY_FILE_ITEMS";
    public static final String KEY_EXPANDED_ITEMS = "KEY_EXPANDED_ITEMS";

    public ProjectExplorer(CContainerProject cContainerProject) {
        this.project = cContainerProject;
        this.loader = new ProjectExplorerLoader(this);
        this.create();
    }

    public void create() {
        this.filesTree = new XJTree();
        this.filesTree.setBorder(null);
        this.filesTree.setToolTipText("");
        this.filesTree.setDragEnabled(true);
        this.filesTree.setRootVisible(false);
        this.filesTree.setShowsRootHandles(true);
        this.filesTree.setCellRenderer(new CustomTableRenderer());
        this.filesTreeRootNode = new DefaultMutableTreeNode();
        this.filesTreeModel = new DefaultTreeModel(this.filesTreeRootNode);
        this.filesTree.setModel(this.filesTreeModel);
        this.filesTree.addTreeSelectionListener(new FilesTreeSelectionListener());
        this.filesTree.addMouseListener(new FilesTreeMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.filesTree);
        jScrollPane.setWheelScrollingEnabled(true);
        this.container = jScrollPane;
    }

    public Component getPanel() {
        return this.container;
    }

    public List getFileEditorItems() {
        return this.loader.getAllFiles();
    }

    public void close() {
        this.runClosureOnFileEditorItems(new FileEditorItemClosure(){

            public void process(ProjectFileItem projectFileItem) {
                projectFileItem.close();
            }
        });
    }

    public void reopen() {
        this.openedFiles.clear();
        this.runClosureOnFileEditorItems(new FileEditorItemClosure(){

            public void process(ProjectFileItem projectFileItem) {
                if (projectFileItem.isOpened()) {
                    ProjectExplorer.this.openedFiles.add(projectFileItem);
                }
            }
        });
        if (this.openedFiles.isEmpty()) {
            return;
        }
        ProjectFileItem[] projectFileItemArray = new ProjectFileItem[this.openedFiles.size()];
        Iterator<ProjectFileItem> iterator = this.openedFiles.iterator();
        while (iterator.hasNext()) {
            ProjectFileItem projectFileItem;
            projectFileItemArray[projectFileItem.getTabIndex()] = projectFileItem = iterator.next();
        }
        for (int i = 0; i < projectFileItemArray.length; ++i) {
            this.project.openFileItem(projectFileItemArray[i]);
        }
    }

    public void reload() {
        this.loader.reload();
        List list = this.getExpandedItems();
        int[] nArray = this.filesTree.getSelectionRows();
        this.filesTreeRootNode.removeAllChildren();
        for (String string : this.loader.getGroups()) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
            this.filesTreeRootNode.add(defaultMutableTreeNode);
            for (ProjectFileItem projectFileItem : this.loader.getFiles(string)) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(projectFileItem));
            }
            this.filesTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
        this.filesTreeModel.reload();
        this.expandItems(list);
        this.filesTree.setSelectionRows(nArray);
    }

    public void saveAll() {
        this.runClosureOnFileEditorItems(new FileEditorItemClosure(){

            public void process(ProjectFileItem projectFileItem) {
                if (projectFileItem.save()) {
                    ProjectExplorer.this.project.getBuildList().resetModificationDate(projectFileItem);
                }
            }
        });
    }

    public void setIgnoreFromBuild(ProjectFileItem projectFileItem, boolean bl) {
        this.project.getBuildList().setIgnoreBuild(projectFileItem, !bl);
        this.filesTree.repaint();
    }

    public void windowActivated() {
        this.reload();
        this.runClosureOnFileEditorItems(new FileEditorItemClosure(){

            public void process(ProjectFileItem projectFileItem) {
                if (projectFileItem.handleExternalModification()) {
                    ProjectExplorer.this.project.changeDone();
                }
                projectFileItem.windowActivated();
            }
        });
    }

    public void expandItems(List list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (String string : list) {
            for (int i = 0; i < this.filesTreeRootNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.filesTreeRootNode.getChildAt(i);
                if (!defaultMutableTreeNode.getUserObject().equals(string)) continue;
                this.filesTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            }
        }
    }

    public List getExpandedItems() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.filesTreeRootNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.filesTreeRootNode.getChildAt(i);
            if (!this.filesTree.isExpanded(new TreePath(defaultMutableTreeNode.getPath()))) continue;
            arrayList.add(defaultMutableTreeNode.getUserObject());
        }
        return arrayList;
    }

    public void setPersistentData(Map map) {
        this.reload();
        if (map != null) {
            this.expandItems((List)map.get(KEY_EXPANDED_ITEMS));
            Map map2 = (Map)map.get(KEY_FILE_ITEMS);
            if (map2 != null) {
                for (String string : map2.keySet()) {
                    ProjectFileItem projectFileItem = this.loader.getFileItemForFileName(string);
                    if (projectFileItem == null) continue;
                    projectFileItem.setPersistentData((Map)map2.get(string));
                }
            }
        }
        this.reopen();
    }

    public Map getPersistentData() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(KEY_EXPANDED_ITEMS, this.getExpandedItems());
        HashMap<String, Map<String, Object>> hashMap2 = new HashMap<String, Map<String, Object>>();
        for (ProjectFileItem projectFileItem : this.getFileEditorItems()) {
            hashMap2.put(projectFileItem.getFileName(), projectFileItem.getPersistentData());
        }
        hashMap.put(KEY_FILE_ITEMS, hashMap2);
        return hashMap;
    }

    public void runClosureOnFileEditorItems(FileEditorItemClosure fileEditorItemClosure) {
        for (ProjectFileItem projectFileItem : this.loader.getAllFiles()) {
            fileEditorItemClosure.process(projectFileItem);
        }
    }

    public class CustomTableRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setToolTipText("");
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (defaultMutableTreeNode.getUserObject() instanceof ProjectFileItem) {
                ProjectFileItem projectFileItem = (ProjectFileItem)defaultMutableTreeNode.getUserObject();
                ProjectBuildList.BuildFile buildFile = ProjectExplorer.this.project.getBuildList().getBuildFile(projectFileItem);
                if (buildFile != null && buildFile.isIgnore()) {
                    this.setForeground(Color.gray);
                } else {
                    this.setForeground(Color.black);
                }
            } else if (defaultMutableTreeNode.getUserObject() instanceof String) {
                this.setText(ProjectFileItem.getFileTypeName(defaultMutableTreeNode.getUserObject().toString()));
                this.setIcon(null);
            }
            return component;
        }
    }

    protected class FileContextualMenu
    implements ActionListener {
        public boolean ignore;

        public FileContextualMenu(boolean bl) {
            this.ignore = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < ProjectExplorer.this.filesTree.getSelectionPaths().length; ++i) {
                TreePath treePath = ProjectExplorer.this.filesTree.getSelectionPaths()[i];
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (!(defaultMutableTreeNode.getUserObject() instanceof ProjectFileItem)) continue;
                ProjectExplorer.this.setIgnoreFromBuild((ProjectFileItem)defaultMutableTreeNode.getUserObject(), this.ignore);
            }
        }
    }

    protected class FilesTreeMouseListener
    extends MouseAdapter {
        protected FilesTreeMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                ProjectExplorer.this.project.openFileItem(this.getFileItemAtLocation(mouseEvent.getX(), mouseEvent.getY()));
            }
        }

        public void displayPopUp(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            ProjectFileItem projectFileItem = this.getFileItemAtLocation(mouseEvent.getX(), mouseEvent.getY());
            if (projectFileItem == null) {
                return;
            }
            ProjectExplorer.this.filesTree.modifySelectionIfNecessary(mouseEvent);
            boolean bl = ProjectExplorer.this.project.getBuildList().isIgnoreBuild(projectFileItem);
            String string = bl ? "Add to build list" : "Remove from build list";
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(new FileContextualMenu(bl));
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(jMenuItem);
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.displayPopUp(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.displayPopUp(mouseEvent);
        }

        public ProjectFileItem getFileItemAtLocation(int n, int n2) {
            if (ProjectExplorer.this.filesTree.getRowForLocation(n, n2) == -1) {
                return null;
            }
            TreePath treePath = ProjectExplorer.this.filesTree.getPathForLocation(n, n2);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof ProjectFileItem) {
                return (ProjectFileItem)object;
            }
            return null;
        }
    }

    protected class FilesTreeSelectionListener
    implements TreeSelectionListener {
        protected FilesTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        }
    }

    public static interface FileEditorItemClosure {
        public void process(ProjectFileItem var1);
    }
}

