/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.project;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.antlr.works.components.project.CContainerProject;
import org.antlr.works.components.project.file.CContainerProjectGrammar;
import org.antlr.works.components.project.file.CContainerProjectJava;
import org.antlr.works.components.project.file.CContainerProjectText;
import org.antlr.works.project.ProjectFileItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectEditorZone {
    protected CContainerProject project;
    protected JPanel panel;
    protected JTabbedPane tabbedPane;
    protected JPanel emptyPanel;
    protected JPanel loadingPanel;
    public static final String KEY_SELECTED_FILE_NAME = "KEY_SELECTED_FILE_NAME";
    public static final int DIRECTION_LEFT = -1;
    public static final int DIRECTION_RIGHT = 1;

    public ProjectEditorZone(CContainerProject cContainerProject) {
        this.project = cContainerProject;
        this.emptyPanel = this.createEmptyEditorPanel();
        this.loadingPanel = this.createLoadingEditorPanel();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(new TabbedPaneChangeListener());
        this.tabbedPane.addMouseListener(new TabbedPaneMouseListener());
        this.panel = new JPanel(new BorderLayout());
        this.openFileItem(null);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JPanel createInfoPanel(String string) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(0);
        jLabel.setFont(new Font("dialog", 0, 36));
        jLabel.setForeground(Color.gray);
        jPanel.add((Component)jLabel, "Center");
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.lightGray));
        return jPanel;
    }

    public JPanel createLoadingEditorPanel() {
        return this.createInfoPanel("Loading...");
    }

    public JPanel createEmptyEditorPanel() {
        return this.createInfoPanel("No Editor");
    }

    public void setEditorZoneToEmpty() {
        this.panel.remove(this.tabbedPane);
        this.panel.add((Component)this.emptyPanel, "Center");
        this.panel.revalidate();
        this.panel.repaint();
        this.project.setDefaultMainMenuBar();
    }

    public void setEditorZoneToTab() {
        this.panel.remove(this.emptyPanel);
        this.panel.add((Component)this.tabbedPane, "Center");
        this.panel.revalidate();
        this.panel.repaint();
    }

    public void setProjectFileItem(ProjectFileItem projectFileItem) {
        if (projectFileItem == null) {
            return;
        }
        this.project.setMainMenuBar(projectFileItem.getComponentContainer().getMainMenuBar());
        this.project.setToolBar(projectFileItem.getComponentContainer().getEditor().getToolbarComponent());
        this.project.setStatusBar(projectFileItem.getComponentContainer().getEditor().getStatusComponent());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProjectEditorZone.this.getSelectedFileItem().getComponentContainer().getEditor().componentIsSelected();
            }
        });
    }

    public void openFileItem(ProjectFileItem projectFileItem) {
        if (projectFileItem == null) {
            this.setEditorZoneToEmpty();
        } else if (projectFileItem.getComponentContainer() == null) {
            new ProjectFileItemFactory(projectFileItem).create();
        } else {
            this.fileEditorItemDidLoad(projectFileItem);
        }
    }

    public void closeActiveEditor() {
        this.removeFileItemFromTab(this.getSelectedFileItem());
        this.project.refreshMainMenuBar();
    }

    public void fileEditorItemDidLoad(ProjectFileItem projectFileItem) {
        this.addFileItemToTab(projectFileItem);
        this.setEditorZoneToTab();
    }

    public void addFileItemToTab(ProjectFileItem projectFileItem) {
        int n;
        if (this.isTabbedPaneContainFileItem(projectFileItem)) {
            n = this.getIndexOfFileItemInTab(projectFileItem);
        } else {
            n = this.tabbedPane.getSelectedIndex();
            if (n == -1) {
                this.tabbedPane.addTab(projectFileItem.getFileName(), projectFileItem.getEditorPanel());
                n = this.tabbedPane.getComponentCount() - 1;
            } else {
                this.tabbedPane.insertTab(projectFileItem.getFileName(), null, projectFileItem.getEditorPanel(), null, ++n);
            }
            this.tabbedPane.setToolTipTextAt(n, projectFileItem.getFilePath());
        }
        this.tabbedPane.setSelectedIndex(n);
        projectFileItem.setOpened(true);
        projectFileItem.setTabIndex(n);
    }

    public void removeFileItemFromTab(ProjectFileItem projectFileItem) {
        int n = this.getIndexOfFileItemInTab(projectFileItem);
        if (n == -1) {
            return;
        }
        this.tabbedPane.removeTabAt(n);
        if (this.tabbedPane.getComponentCount() == 0) {
            this.setEditorZoneToEmpty();
        } else {
            if (n > 0) {
                --n;
            }
            if (this.tabbedPane.getSelectedIndex() == n) {
                this.setProjectFileItem(this.getSelectedFileItem());
            } else {
                this.tabbedPane.setSelectedIndex(n);
            }
        }
        projectFileItem.setOpened(false);
    }

    public boolean isTabbedPaneContainFileItem(ProjectFileItem projectFileItem) {
        return this.getIndexOfFileItemInTab(projectFileItem) != -1;
    }

    public int getIndexOfFileItemInTab(ProjectFileItem projectFileItem) {
        for (int i = 0; i < this.tabbedPane.getComponentCount(); ++i) {
            if (this.tabbedPane.getComponentAt(i) != projectFileItem.getEditorPanel()) continue;
            return i;
        }
        return -1;
    }

    public ProjectFileItem getFileItemForTabComponent(Component component) {
        if (component == null) {
            return null;
        }
        for (Object e : this.project.getFileEditorItems()) {
            ProjectFileItem projectFileItem = (ProjectFileItem)e;
            if (projectFileItem.getEditorPanel() != component) continue;
            return projectFileItem;
        }
        return null;
    }

    public ProjectFileItem getSelectedFileItem() {
        return this.getFileItemForTabComponent(this.tabbedPane.getSelectedComponent());
    }

    public void setPersistentData(Map map) {
        if (map == null) {
            return;
        }
        String string = (String)map.get(KEY_SELECTED_FILE_NAME);
        if (string != null) {
            for (int i = 0; i < this.tabbedPane.getComponentCount(); ++i) {
                ProjectFileItem projectFileItem = this.getFileItemForTabComponent(this.tabbedPane.getComponentAt(i));
                if (projectFileItem == null || !projectFileItem.getFileName().equals(string)) continue;
                this.tabbedPane.setSelectedIndex(i);
                break;
            }
        }
    }

    public Map<String, String> getPersistentData() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.getSelectedFileItem() != null) {
            hashMap.put(KEY_SELECTED_FILE_NAME, this.getSelectedFileItem().getFileName());
        }
        return hashMap;
    }

    public void moveActiveEditor(int n) {
        int n2 = this.tabbedPane.getSelectedIndex();
        if (n2 == -1) {
            return;
        }
        if (n == -1 && n2 <= 0) {
            return;
        }
        if (n == 1 && n2 >= this.tabbedPane.getTabCount() - 1) {
            return;
        }
        this.swapTab(n2, n2 + n);
    }

    public void swapTab(int n, int n2) {
        String string = this.tabbedPane.getTitleAt(n);
        Component component = this.tabbedPane.getComponentAt(n);
        this.tabbedPane.removeTabAt(n);
        this.tabbedPane.insertTab(string, null, component, null, n2);
        this.tabbedPane.setSelectedIndex(n2);
        this.getFileItemForTabComponent(this.tabbedPane.getComponentAt(n)).setTabIndex(n);
        this.getFileItemForTabComponent(this.tabbedPane.getComponentAt(n2)).setTabIndex(n2);
    }

    protected class ProjectFileItemFactory {
        public ProjectFileItem item;

        public ProjectFileItemFactory(ProjectFileItem projectFileItem) {
            this.item = projectFileItem;
        }

        public void create() {
            String string = ProjectFileItem.getFileType(this.item.getFilePath());
            if (string.equals("FILE_TYPE_GRAMMAR")) {
                new CContainerProjectGrammar(ProjectEditorZone.this.project, this.item);
            } else if (string.equals("FILE_TYPE_JAVA")) {
                new CContainerProjectJava(ProjectEditorZone.this.project, this.item);
            } else {
                new CContainerProjectText(ProjectEditorZone.this.project, this.item);
            }
            this.item.getComponentContainer().getDocument().performLoad(this.item.getFilePath());
            if (!this.item.isOpened()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                    }
                });
            }
            ProjectEditorZone.this.fileEditorItemDidLoad(this.item);
        }
    }

    protected class TabbedPaneMouseListener
    extends MouseAdapter {
        protected TabbedPaneMouseListener() {
        }

        public void displayPopUp(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Close");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ProjectEditorZone.this.closeActiveEditor();
                }
            });
            jPopupMenu.add(jMenuItem);
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.displayPopUp(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.displayPopUp(mouseEvent);
        }
    }

    protected class TabbedPaneChangeListener
    implements ChangeListener {
        protected TabbedPaneChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ProjectEditorZone.this.setProjectFileItem(ProjectEditorZone.this.getSelectedFileItem());
        }
    }
}

