/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.antlr.works.prefs.AWPrefs;

public class ProjectConsole {
    protected Container container;
    protected JTextArea textArea;

    public ProjectConsole() {
        this.create();
    }

    public Container getContainer() {
        return this.container;
    }

    public void create() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setTabPlacement(3);
        JPanel jPanel = new JPanel(new BorderLayout());
        Box box = Box.createHorizontalBox();
        JButton jButton = new JButton("Clear All");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectConsole.this.clear();
            }
        });
        box.add(jButton);
        box.add(Box.createHorizontalGlue());
        jPanel.add((Component)this.createTextArea(), "Center");
        jPanel.add((Component)box, "South");
        jTabbedPane.add("Project", jPanel);
        this.container = jTabbedPane;
    }

    public Container createTextArea() {
        this.textArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setWheelScrollingEnabled(true);
        this.applyFont();
        return jScrollPane;
    }

    public void applyFont() {
        this.textArea.setFont(new Font(AWPrefs.getEditorFont(), 0, AWPrefs.getEditorFontSize()));
    }

    public void clear() {
        this.textArea.setText("");
    }

    public synchronized void print(String string) {
        this.textArea.setText(this.textArea.getText() + string);
        this.textArea.setCaretPosition(this.textArea.getText().length());
    }
}

