/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.project;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.antlr.works.components.project.CContainerProject;
import org.antlr.works.engine.EngineRuntime;
import org.antlr.works.project.ProjectBuildList;
import org.antlr.works.project.ProjectFileItem;
import org.antlr.works.utils.StreamWatcherDelegate;
import org.antlr.xjlib.appkit.utils.XJDialogProgress;
import org.antlr.xjlib.appkit.utils.XJDialogProgressDelegate;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectBuilder
implements StreamWatcherDelegate,
XJDialogProgressDelegate {
    protected CContainerProject project;
    protected XJDialogProgress progress;
    protected boolean cancel;
    protected int buildingProgress;
    protected ProjectFileItem fileToBuild;
    protected ThreadExecution currentThread;

    public ProjectBuilder(CContainerProject cContainerProject) {
        this.project = cContainerProject;
        this.progress = new XJDialogProgress(cContainerProject.getXJFrame(), true);
        this.progress.setDelegate(this);
    }

    public List<ProjectBuildList.BuildFile> getListOfDirtyBuildFiles(String string) {
        return this.project.getBuildList().getDirtyBuildFilesOfType(string);
    }

    public List<ProjectBuildList.BuildFile> buildListOfBuildFilesOfType(List<String> list, String string) {
        ProjectBuildList projectBuildList = this.project.getBuildList();
        File[] fileArray = new File(this.project.getSourcePath()).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File object = fileArray[i];
            String string2 = object.getAbsolutePath();
            if (!ProjectFileItem.getFileType(string2).equals(string)) continue;
            if (projectBuildList.isFileExisting(string2, string)) {
                projectBuildList.handleExternalModification(string2, string);
                continue;
            }
            projectBuildList.addFile(string2, string);
        }
        for (ProjectBuildList.BuildFile buildFile : projectBuildList.getBuildFilesOfType(string)) {
            if (new File(buildFile.getFilePath()).exists()) continue;
            projectBuildList.removeFile(buildFile.getFilePath(), string);
        }
        return this.getListOfDirtyBuildFiles(string);
    }

    public List<ProjectBuildList.BuildFile> buildListOfGrammarBuildFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ProjectFileItem projectFileItem : this.project.getFileEditorItems()) {
            arrayList.add(projectFileItem.getFilePath());
        }
        return this.buildListOfBuildFilesOfType(arrayList, "FILE_TYPE_GRAMMAR");
    }

    public List<ProjectBuildList.BuildFile> buildListOfJavaBuildFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = new File(this.project.getSourcePath()).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            arrayList.add(file.getAbsolutePath());
        }
        return this.buildListOfBuildFilesOfType(arrayList, "FILE_TYPE_JAVA");
    }

    public boolean generateGrammarBuildFiles(List<ProjectBuildList.BuildFile> list) {
        Iterator<ProjectBuildList.BuildFile> iterator = list.iterator();
        while (iterator.hasNext() && !this.cancel) {
            ProjectBuildList.BuildFile buildFile = iterator.next();
            String string = buildFile.getFilePath();
            String string2 = buildFile.getFileFolder();
            String string3 = buildFile.getFileFolder();
            this.setProgressStepInfo("Generating \"" + XJUtils.getLastPathComponent(string) + "\"...");
            String string4 = EngineRuntime.runANTLR(null, string, string2, string3, this);
            if (string4 != null) {
                this.project.buildReportError(string4);
                return false;
            }
            buildFile.setDirty(false);
            this.project.changeDone();
        }
        return true;
    }

    public boolean compileFile(String string) {
        String string2 = this.project.getSourcePath();
        String string3 = EngineRuntime.compileFiles(null, new String[]{string}, string2, this);
        if (string3 != null) {
            this.project.buildReportError(string3);
            return false;
        }
        return true;
    }

    public boolean compileJavaBuildFiles(List<ProjectBuildList.BuildFile> list) {
        Iterator<ProjectBuildList.BuildFile> iterator = list.iterator();
        while (iterator.hasNext() && !this.cancel) {
            ProjectBuildList.BuildFile buildFile = iterator.next();
            String string = buildFile.getFilePath();
            this.setProgressStepInfo("Compiling \"" + XJUtils.getLastPathComponent(string) + "\"...");
            if (!this.compileFile(string)) {
                return false;
            }
            buildFile.setDirty(false);
            this.project.changeDone();
        }
        return true;
    }

    public void setProgressStepInfo(String string) {
        this.progress.setInfo(string);
        this.progress.setProgress(++this.buildingProgress);
    }

    public boolean performBuild() {
        List<ProjectBuildList.BuildFile> list = this.buildListOfGrammarBuildFiles();
        List<ProjectBuildList.BuildFile> list2 = this.buildListOfJavaBuildFiles();
        int n = list.size() + list2.size();
        if (n == 0) {
            return true;
        }
        this.progress.setIndeterminate(false);
        this.progress.setProgress(0);
        this.progress.setProgressMax(n);
        if (this.generateGrammarBuildFiles(list) && !this.cancel) {
            if (list.size() > 0) {
                list2 = this.buildListOfJavaBuildFiles();
                n = list.size() + list2.size();
                this.progress.setProgressMax(n);
            }
            if (this.compileJavaBuildFiles(list2)) {
                return true;
            }
        }
        return false;
    }

    public void performBuildFile() {
        List<ProjectBuildList.BuildFile> list;
        String string = this.fileToBuild.getFileType();
        if (string.equals("FILE_TYPE_GRAMMAR")) {
            list = this.buildListOfGrammarBuildFiles();
        } else if (string.equals("FILE_TYPE_JAVA")) {
            list = this.buildListOfJavaBuildFiles();
        } else {
            return;
        }
        for (ProjectBuildList.BuildFile buildFile : list) {
            if (!buildFile.getFilePath().equals(this.fileToBuild.getFilePath())) continue;
            List<ProjectBuildList.BuildFile> list2 = Collections.singletonList(buildFile);
            if (string.equals("FILE_TYPE_GRAMMAR")) {
                this.generateGrammarBuildFiles(list2);
                continue;
            }
            if (!string.equals("FILE_TYPE_JAVA")) continue;
            this.compileJavaBuildFiles(list2);
        }
    }

    public void prepare() {
        this.cancel = false;
        this.buildingProgress = 0;
        this.currentThread = null;
    }

    public void buildFile(ProjectFileItem projectFileItem) {
        this.fileToBuild = projectFileItem;
        this.progress.setCancellable(true);
        this.progress.setTitle("Build");
        this.progress.setInfo("Building...");
        this.progress.setIndeterminate(true);
        this.prepare();
        this.currentThread = new ThreadExecution(new Runnable(){

            public void run() {
                ProjectBuilder.this.performBuildFile();
                ProjectBuilder.this.progress.close();
            }
        });
        this.progress.runModal();
    }

    public void buildAll() {
        this.progress.setCancellable(true);
        this.progress.setTitle("Build");
        this.progress.setInfo("Preparing...");
        this.progress.setIndeterminate(true);
        this.prepare();
        this.currentThread = new ThreadExecution(new Runnable(){

            public void run() {
                ProjectBuilder.this.performBuild();
                ProjectBuilder.this.progress.close();
            }
        });
        this.progress.runModal();
    }

    public void performRun() {
        String string = EngineRuntime.runJava(null, this.project.getSourcePath(), this.project.getRunParameters(), this);
        if (string != null) {
            this.project.buildReportError(string);
        }
    }

    public void run() {
        this.progress.setCancellable(true);
        this.progress.setTitle("Run");
        this.progress.setInfo("Preparing...");
        this.progress.setIndeterminate(true);
        this.prepare();
        this.currentThread = new ThreadExecution(new Runnable(){

            public void run() {
                if (ProjectBuilder.this.performBuild() && !ProjectBuilder.this.cancel) {
                    ProjectBuilder.this.progress.setInfo("Running...");
                    ProjectBuilder.this.progress.setIndeterminate(true);
                    ProjectBuilder.this.performRun();
                }
                ProjectBuilder.this.progress.close();
            }
        });
        this.progress.runModal();
    }

    public void clean() {
        File[] fileArray = new File(this.project.getSourcePath()).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            String string = file.getAbsolutePath();
            if (!string.endsWith(".class")) continue;
            file.delete();
        }
        this.project.getBuildList().setAllFilesToDirty(true);
        this.project.changeDone();
    }

    @Override
    public void dialogDidCancel() {
        Process process;
        if (this.cancel && (process = EngineRuntime.getProcess(this.currentThread.t)) != null) {
            process.destroy();
        }
        this.cancel = true;
    }

    @Override
    public void streamWatcherDidStarted() {
    }

    @Override
    public synchronized void streamWatcherDidReceiveString(String string) {
        this.project.printToConsole(string);
    }

    @Override
    public synchronized void streamWatcherException(Exception exception) {
        this.project.printToConsole(exception);
    }

    protected class ThreadExecution {
        protected Runnable r;
        protected Thread t;

        public ThreadExecution(Runnable runnable) {
            this.r = runnable;
            this.launch();
        }

        public void launch() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ThreadExecution.this.t = new Thread(ThreadExecution.this.r);
                    ThreadExecution.this.t.start();
                }
            });
        }
    }
}

