/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.project;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.works.project.ProjectFileItem;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectBuildList {
    protected Map<String, Map<Object, BuildFile>> files = new HashMap<String, Map<Object, BuildFile>>();

    public void addFile(String string, String string2) {
        this.getMapForType(string2).put(string, new BuildFile(string));
    }

    public void removeFile(String string, String string2) {
        this.getMapForType(string2).remove(string);
    }

    public void setFileDirty(ProjectFileItem projectFileItem, boolean bl) {
        this.setFileDirty(projectFileItem.getFilePath(), projectFileItem.getFileType(), bl);
    }

    public void setFileDirty(String string, String string2, boolean bl) {
        BuildFile buildFile = this.getMapForType(string2).get(string);
        if (buildFile != null) {
            buildFile.setDirty(bl);
        }
    }

    public void setIgnoreBuild(ProjectFileItem projectFileItem, boolean bl) {
        this.setIgnoreBuild(projectFileItem.getFilePath(), projectFileItem.getFileType(), bl);
    }

    public void setIgnoreBuild(String string, String string2, boolean bl) {
        BuildFile buildFile = this.getMapForType(string2).get(string);
        if (buildFile != null) {
            buildFile.setIgnore(bl);
        }
    }

    public boolean isIgnoreBuild(ProjectFileItem projectFileItem) {
        return this.isIgnoreBuild(projectFileItem.getFilePath(), projectFileItem.getFileType());
    }

    public boolean isIgnoreBuild(String string, String string2) {
        BuildFile buildFile = this.getMapForType(string2).get(string);
        if (buildFile != null) {
            return buildFile.isIgnore();
        }
        return false;
    }

    public void setAllFilesToDirty(boolean bl) {
        for (Map<Object, BuildFile> map : this.files.values()) {
            for (BuildFile buildFile : map.values()) {
                buildFile.setDirty(true);
            }
        }
    }

    public boolean isFileExisting(String string, String string2) {
        return this.getMapForType(string2).containsKey(string);
    }

    public BuildFile getBuildFile(ProjectFileItem projectFileItem) {
        return this.getBuildFile(projectFileItem.getFilePath(), projectFileItem.getFileType());
    }

    public BuildFile getBuildFile(String string, String string2) {
        for (BuildFile buildFile : this.getBuildFilesOfType(string2)) {
            if (!buildFile.getFilePath().equals(string)) continue;
            return buildFile;
        }
        return null;
    }

    public List<BuildFile> getBuildFilesOfType(String string) {
        ArrayList<BuildFile> arrayList = new ArrayList<BuildFile>();
        Iterator<BuildFile> iterator = this.getMapForType(string).values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public List<BuildFile> getDirtyBuildFilesOfType(String string) {
        ArrayList<BuildFile> arrayList = new ArrayList<BuildFile>();
        for (BuildFile buildFile : this.getBuildFilesOfType(string)) {
            if (!buildFile.isDirty() || buildFile.isIgnore()) continue;
            arrayList.add(buildFile);
        }
        return arrayList;
    }

    public boolean handleExternalModification(String string, String string2) {
        BuildFile buildFile = this.getBuildFile(string, string2);
        if (buildFile == null) {
            return false;
        }
        return buildFile.handleExternalModification();
    }

    public void resetModificationDate(ProjectFileItem projectFileItem) {
        BuildFile buildFile = this.getBuildFile(projectFileItem);
        if (buildFile != null) {
            buildFile.resetModificationDate();
        }
    }

    public boolean handleExternalModification() {
        boolean bl = false;
        for (Map<Object, BuildFile> map : this.files.values()) {
            for (BuildFile buildFile : map.values()) {
                if (!buildFile.handleExternalModification()) continue;
                bl = true;
            }
        }
        return bl;
    }

    public void setPersistentData(Map<String, Map> map) {
        this.files.clear();
        for (String string : map.keySet()) {
            this.files.put(string, new HashMap());
            for (Map map2 : map.get(string).values()) {
                BuildFile buildFile = new BuildFile();
                buildFile.setPersistentData(map2);
                this.files.get(string).put(buildFile.filePath, buildFile);
            }
        }
    }

    public Map<String, Map<Object, Map<Object, Serializable>>> getPersistentData() {
        HashMap<String, Map<Object, Map<Object, Serializable>>> hashMap = new HashMap<String, Map<Object, Map<Object, Serializable>>>();
        for (String string : this.files.keySet()) {
            HashMap<String, Map<Object, Serializable>> hashMap2 = new HashMap<String, Map<Object, Serializable>>();
            for (BuildFile buildFile : this.files.get(string).values()) {
                hashMap2.put(buildFile.filePath, buildFile.getPersistentData());
            }
            hashMap.put(string, hashMap2);
        }
        return hashMap;
    }

    private Map<Object, BuildFile> getMapForType(String string) {
        Map<Object, BuildFile> map = this.files.get(string);
        if (map == null) {
            map = new HashMap<Object, BuildFile>();
            this.files.put(string, map);
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BuildFile {
        private String filePath;
        private boolean dirty;
        private boolean ignore;
        private long modificationDate;
        static final String KEY_FILE_PATH = "KEY_FILE_PATH";
        static final String KEY_DIRTY = "KEY_DIRTY";
        static final String KEY_IGNORE = "KEY_IGNORE";
        static final String KEY_MODIFICATION_DATE = "KEY_MODIFICATION_DATE";

        public BuildFile() {
            this.dirty = true;
            this.ignore = false;
            this.resetModificationDate();
        }

        public BuildFile(String string) {
            this.filePath = string;
            this.dirty = true;
            this.ignore = false;
            this.resetModificationDate();
        }

        public void setDirty(boolean bl) {
            this.dirty = bl;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setIgnore(boolean bl) {
            this.ignore = bl;
        }

        public boolean isIgnore() {
            return this.ignore;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getFileFolder() {
            return XJUtils.getPathByDeletingLastComponent(this.getFilePath());
        }

        public boolean isModifiedOnDisk() {
            return this.modificationDate != this.getDateOfModificationOnDisk();
        }

        public void resetModificationDate() {
            this.modificationDate = this.getDateOfModificationOnDisk();
        }

        public boolean handleExternalModification() {
            if (this.isModifiedOnDisk()) {
                this.setDirty(true);
                this.resetModificationDate();
                return true;
            }
            return false;
        }

        public long getDateOfModificationOnDisk() {
            File file = null;
            try {
                file = new File(this.filePath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (file == null) {
                return 0L;
            }
            return file.lastModified();
        }

        public void setPersistentData(Map map) {
            this.filePath = (String)map.get(KEY_FILE_PATH);
            this.dirty = (Boolean)map.get(KEY_DIRTY);
            this.ignore = (Boolean)map.get(KEY_IGNORE);
            this.modificationDate = (Long)map.get(KEY_MODIFICATION_DATE);
        }

        public Map<Object, Serializable> getPersistentData() {
            HashMap<Object, Serializable> hashMap = new HashMap<Object, Serializable>();
            hashMap.put(KEY_FILE_PATH, (Serializable)((Object)this.filePath));
            hashMap.put(KEY_DIRTY, Boolean.valueOf(this.dirty));
            hashMap.put(KEY_IGNORE, Boolean.valueOf(this.ignore));
            hashMap.put(KEY_MODIFICATION_DATE, new Long(this.modificationDate));
            return hashMap;
        }
    }
}

