/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.prefs;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import org.antlr.works.IDE;
import org.antlr.works.ate.syntax.generic.ATESyntaxEngine;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.utils.HelpManager;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.app.XJPreferences;
import org.antlr.xjlib.appkit.frame.XJPanel;
import org.antlr.xjlib.appkit.swing.XJLookAndFeel;
import org.antlr.xjlib.appkit.utils.XJFileChooser;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;

public class AWPrefsDialog
extends XJPanel {
    public static final String NOTIF_PREFS_APPLIED = "NOTIF_PREFS_APPLIED";
    protected ButtonGroup compilerRadioButtonGroup;
    protected int lafIndex = 0;
    private JPanel dialogPane;
    private JPanel contentPane;
    private JTabbedPane tabbedPane1;
    private JPanel tabGeneral;
    private JLabel label2;
    private JLabel label5;
    private JComboBox lafCombo;
    private JComboBox startupActionCombo;
    private JCheckBox restoreWindowsBoundButton;
    private JCheckBox desktopModeButton;
    private JLabel label25;
    private JRadioButton outputPathSameRadio;
    private JRadioButton outputPathCustomRadio;
    private JTextField outputPathField;
    private JButton browseOutputPathButton;
    private JLabel label24;
    private JTextField dotToolPathField;
    private JButton browseDotToolPathButton;
    private JLabel label37;
    private JTextField antlr3OptionsField;
    private JPanel tabEditor;
    private JLabel label3;
    private JComboBox editorFontCombo;
    private JSpinner editorFontSizeSpinner;
    private JCheckBox autoSaveButton;
    private JTextField autoSaveDelayField;
    private JLabel label11;
    private JCheckBox backupFileButton;
    private JCheckBox highlightCursorLineButton;
    private JCheckBox smoothScrollingButton;
    private JCheckBox autoIndentColonInRuleButton;
    private JCheckBox showLineNumbers;
    private JCheckBox vstyleAutocompletionButton;
    private JLabel label1;
    private JTextField tabWidthField;
    private JLabel label22;
    private JTextField parserDelayField;
    private JLabel label23;
    private JPanel tabSyntax;
    private JLabel label26;
    private JPanel parserColorPanel;
    private JCheckBox parserBoldButton;
    private JCheckBox parserItalicButton;
    private JLabel label27;
    private JPanel lexerColorPanel;
    private JCheckBox lexerBoldButton;
    private JCheckBox lexerItalicButton;
    private JLabel label28;
    private JPanel labelColorPanel;
    private JCheckBox labelsBoldButton;
    private JCheckBox labelsItalicButton;
    private JLabel label29;
    private JPanel refsActionColorPanel;
    private JCheckBox refsActionBoldButton;
    private JCheckBox refsActionItalicButton;
    private JLabel label30;
    private JPanel commentsColorPanel;
    private JCheckBox commentsBoldButton;
    private JCheckBox commentsItalicButton;
    private JLabel label31;
    private JPanel stringsColorPanel;
    private JCheckBox stringsBoldButton;
    private JCheckBox stringsItalicButton;
    private JLabel label32;
    private JPanel keywordsColorPanel;
    private JCheckBox keywordsBoldButton;
    private JButton syntaxDefaultButton;
    private JCheckBox keywordsItalicButton;
    private JPanel tabCompiler;
    private JRadioButton jikesRadio;
    private JRadioButton integratedRadio;
    private JRadioButton javacRadio;
    private JCheckBox javacCustomPathButton;
    private JTextField javacPathField;
    private JButton browseJavacPath;
    private JLabel label4;
    private JTextField jikesPathField;
    private JButton browseJikesPath;
    private JLabel label9;
    private JCheckBox classpathSystemButton;
    private JCheckBox classpathCustomButton;
    private JTextField customClasspathField;
    private JButton browseCustomClassPathButton;
    private JPanel tabDebugger;
    private JLabel label33;
    private JTextField debugDefaultLocalPortField;
    private JLabel label34;
    private JTextField debugLaunchTimeoutField;
    private JLabel label35;
    private JLabel label12;
    private JPanel debugNonConsumedColorPanel;
    private JLabel label13;
    private JPanel debugConsumedColorPanel;
    private JLabel label14;
    private JPanel debugHiddenColorPanel;
    private JLabel label15;
    private JPanel debugDeadColorPanel;
    private JLabel label16;
    private JPanel debugLTColorPanel;
    private JLabel label36;
    private JCheckBox detachablePanelChildrenButton;
    private JCheckBox askGenButton;
    private JPanel tabSCM;
    private JCheckBox enablePerforceCheckBox;
    private JLabel label18;
    private JTextField p4PortField;
    private JLabel label19;
    private JTextField p4UserField;
    private JLabel label21;
    private JPasswordField p4PasswordField;
    private JLabel label20;
    private JTextField p4ClientField;
    private JLabel label17;
    private JTextField p4ExecPathField;
    private JPanel tabUpdates;
    private JLabel label7;
    private JComboBox updateTypeCombo;
    private JButton checkForUpdatesButton;
    private JLabel label10;
    private JTextField downloadPathField;
    private JButton browseUpdateDownloadPathButton;
    private JPanel buttonBar;
    private JButton applyButton;

    public AWPrefsDialog() {
        this.initComponents();
        this.prepareGeneralTab();
        this.prepareEditorTab();
        this.prepareSyntaxTab();
        this.prepareCompilerTab();
        this.prepareDebuggerTab();
        this.prepareSCMTab();
        this.prepareUpdateTab();
        if (IDE.isPlugin()) {
            this.tabbedPane1.remove(this.tabSCM);
        }
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWPrefsDialog.this.apply();
            }
        });
    }

    public void prepareGeneralTab() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
        this.browseOutputPathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (XJFileChooser.shared().displayChooseDirectory(AWPrefsDialog.this.getJavaContainer())) {
                    AWPrefsDialog.this.outputPathField.setText(XJFileChooser.shared().getSelectedFilePath());
                    AWPrefs.setOutputPath(AWPrefsDialog.this.outputPathField.getText());
                }
            }
        });
        this.browseDotToolPathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (XJFileChooser.shared().displayOpenDialog(AWPrefsDialog.this.getJavaContainer(), false)) {
                    AWPrefsDialog.this.dotToolPathField.setText(XJFileChooser.shared().getSelectedFilePath());
                    AWPrefs.setDOTToolPath(AWPrefsDialog.this.dotToolPathField.getText());
                }
            }
        });
        this.lafCombo.removeAllItems();
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels()) {
            this.lafCombo.addItem(lookAndFeelInfo.getName());
        }
        this.lafCombo.setEnabled(!IDE.isPlugin());
        this.outputPathSameRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWPrefsDialog.this.outputPathField.setEnabled(AWPrefsDialog.this.outputPathCustomRadio.isSelected());
                AWPrefsDialog.this.browseOutputPathButton.setEnabled(AWPrefsDialog.this.outputPathCustomRadio.isSelected());
            }
        });
        this.outputPathCustomRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWPrefsDialog.this.outputPathField.setEnabled(AWPrefsDialog.this.outputPathCustomRadio.isSelected());
                AWPrefsDialog.this.browseOutputPathButton.setEnabled(AWPrefsDialog.this.outputPathCustomRadio.isSelected());
            }
        });
        AWPrefsDialog.getPreferences().bindToPreferences(this.startupActionCombo, "PREF_STARTUP_ACTION", 1);
        AWPrefsDialog.getPreferences().bindToPreferences(this.restoreWindowsBoundButton, "PREF_RESTORE_WINDOWS", true);
        AWPrefsDialog.getPreferences().bindToPreferences(this.lafCombo, "PREF_LOOK_AND_FEEL", XJLookAndFeel.getDefaultLookAndFeelName());
        AWPrefsDialog.getPreferences().bindToPreferences(this.desktopModeButton, "PREF_DESKTOP_MODE", AWPrefs.DEFAULT_DESKTOP_MODE);
        AWPrefsDialog.getPreferences().bindToPreferences(this.outputPathSameRadio, "PREF_OUTPUT_PATH_SAME", false);
        AWPrefsDialog.getPreferences().bindToPreferences(this.outputPathCustomRadio, "PREF_OUTPUT_PATH_CUSTOM", true);
        AWPrefsDialog.getPreferences().bindToPreferences(this.outputPathField, "PREF_OUTPUT_PATH", AWPrefs.DEFAULT_OUTPUT_PATH);
        AWPrefsDialog.getPreferences().bindToPreferences(this.dotToolPathField, "PREF_DOT_TOOL_PATH", AWPrefs.DEFAULT_DOT_TOOL_PATH);
        AWPrefsDialog.getPreferences().bindToPreferences(this.antlr3OptionsField, "PREF_ANTLR3_OPTIONS", "");
    }

    public void prepareEditorTab() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        this.editorFontCombo.removeAllItems();
        for (String string : stringArray) {
            this.editorFontCombo.addItem(string);
        }
        AWPrefsDialog.getPreferences().bindToPreferences(this.autoSaveButton, "PREF_AUTOSAVE_ENABLED", false);
        AWPrefsDialog.getPreferences().bindToPreferences(this.autoSaveDelayField, "PREF_AUTOSAVE_DELAY", 5);
        AWPrefsDialog.getPreferences().bindToPreferences(this.backupFileButton, "PREF_BACKUP_FILE_ENABLED", false);
        AWPrefsDialog.getPreferences().bindToPreferences(this.highlightCursorLineButton, "PREF_HIGHLIGHTCURSORLINE", true);
        AWPrefsDialog.getPreferences().bindToPreferences(this.tabWidthField, "PREF_TAB_WIDTH", 8);
        AWPrefsDialog.getPreferences().bindToPreferences(this.editorFontCombo, "PREF_EDITOR_FONT", AWPrefs.DEFAULT_EDITOR_FONT);
        AWPrefsDialog.getPreferences().bindToPreferences(this.editorFontSizeSpinner, "PREF_EDITOR_FONT_SIZE", 12);
        AWPrefsDialog.getPreferences().bindToPreferences(this.parserDelayField, "PREF_PARSER_DELAY", 250);
        AWPrefsDialog.getPreferences().bindToPreferences(this.autoIndentColonInRuleButton, "PREF_AUTO_IDENT_COLON_RULE", true);
        AWPrefsDialog.getPreferences().bindToPreferences(this.showLineNumbers, "PREF_LINE_NUMBER", false);
        AWPrefsDialog.getPreferences().bindToPreferences(this.vstyleAutocompletionButton, "PREF_VSTYLE_AUTOCOMPLETION", false);
        AWPrefsDialog.getPreferences().bindToPreferences(this.smoothScrollingButton, "PREF_SMOOTH_SCROLLING", true);
    }

    public void bindSyntax(String string, JPanel jPanel, JCheckBox jCheckBox, JCheckBox jCheckBox2) {
        AWPrefsDialog.getPreferences().bindToPreferences(jPanel, AWPrefs.getSyntaxColorKey(string), AWPrefs.getSyntaxDefaultColor(string));
        AWPrefsDialog.getPreferences().bindToPreferences(jCheckBox, AWPrefs.getSyntaxBoldKey(string), AWPrefs.getSyntaxDefaultBold(string));
        AWPrefsDialog.getPreferences().bindToPreferences(jCheckBox2, AWPrefs.getSyntaxItalicKey(string), AWPrefs.getSyntaxDefaultItalic(string));
    }

    public void defaultSyntax(String string, JPanel jPanel, JCheckBox jCheckBox, JCheckBox jCheckBox2) {
        AWPrefsDialog.getPreferences().defaultPreference(jPanel, AWPrefs.getSyntaxColorKey(string), AWPrefs.getSyntaxDefaultColor(string));
        AWPrefsDialog.getPreferences().defaultPreference(jCheckBox, AWPrefs.getSyntaxBoldKey(string), AWPrefs.getSyntaxDefaultBold(string));
        AWPrefsDialog.getPreferences().defaultPreference(jCheckBox2, AWPrefs.getSyntaxItalicKey(string), AWPrefs.getSyntaxDefaultItalic(string));
    }

    public void prepareSyntaxTab() {
        this.syntaxDefaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWPrefsDialog.this.defaultSyntax("PREF_SYNTAX_PARSER", AWPrefsDialog.this.parserColorPanel, AWPrefsDialog.this.parserBoldButton, AWPrefsDialog.this.parserItalicButton);
                AWPrefsDialog.this.defaultSyntax("PREF_SYNTAX_LEXER", AWPrefsDialog.this.lexerColorPanel, AWPrefsDialog.this.lexerBoldButton, AWPrefsDialog.this.lexerItalicButton);
                AWPrefsDialog.this.defaultSyntax("PREF_SYNTAX_LABEL", AWPrefsDialog.this.labelColorPanel, AWPrefsDialog.this.labelsBoldButton, AWPrefsDialog.this.labelsItalicButton);
                AWPrefsDialog.this.defaultSyntax("PREF_SYNTAX_REFS", AWPrefsDialog.this.refsActionColorPanel, AWPrefsDialog.this.refsActionBoldButton, AWPrefsDialog.this.refsActionItalicButton);
                AWPrefsDialog.this.defaultSyntax("PREF_SYNTAX_COMMENT", AWPrefsDialog.this.commentsColorPanel, AWPrefsDialog.this.commentsBoldButton, AWPrefsDialog.this.commentsItalicButton);
                AWPrefsDialog.this.defaultSyntax("PREF_SYNTAX_STRING", AWPrefsDialog.this.stringsColorPanel, AWPrefsDialog.this.stringsBoldButton, AWPrefsDialog.this.stringsItalicButton);
                AWPrefsDialog.this.defaultSyntax("PREF_SYNTAX_KEYWORD", AWPrefsDialog.this.keywordsColorPanel, AWPrefsDialog.this.keywordsBoldButton, AWPrefsDialog.this.keywordsItalicButton);
            }
        });
        this.bindSyntax("PREF_SYNTAX_PARSER", this.parserColorPanel, this.parserBoldButton, this.parserItalicButton);
        this.bindSyntax("PREF_SYNTAX_LEXER", this.lexerColorPanel, this.lexerBoldButton, this.lexerItalicButton);
        this.bindSyntax("PREF_SYNTAX_LABEL", this.labelColorPanel, this.labelsBoldButton, this.labelsItalicButton);
        this.bindSyntax("PREF_SYNTAX_REFS", this.refsActionColorPanel, this.refsActionBoldButton, this.refsActionItalicButton);
        this.bindSyntax("PREF_SYNTAX_COMMENT", this.commentsColorPanel, this.commentsBoldButton, this.commentsItalicButton);
        this.bindSyntax("PREF_SYNTAX_STRING", this.stringsColorPanel, this.stringsBoldButton, this.stringsItalicButton);
        this.bindSyntax("PREF_SYNTAX_KEYWORD", this.keywordsColorPanel, this.keywordsBoldButton, this.keywordsItalicButton);
    }

    public void prepareCompilerTab() {
        this.javacCustomPathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWPrefsDialog.this.javacPathField.setEnabled(AWPrefsDialog.this.javacCustomPathButton.isSelected());
                AWPrefsDialog.this.browseJavacPath.setEnabled(AWPrefsDialog.this.javacCustomPathButton.isSelected());
            }
        });
        this.browseJavacPath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (XJFileChooser.shared().displayChooseDirectory(AWPrefsDialog.this.getJavaContainer())) {
                    AWPrefsDialog.this.javacPathField.setText(XJFileChooser.shared().getSelectedFilePath());
                    AWPrefs.setJavaCPath(AWPrefsDialog.this.javacPathField.getText());
                }
            }
        });
        this.browseJikesPath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (XJFileChooser.shared().displayChooseDirectory(AWPrefsDialog.this.getJavaContainer())) {
                    AWPrefsDialog.this.jikesPathField.setText(XJFileChooser.shared().getSelectedFilePath());
                    AWPrefs.setJikesPath(AWPrefsDialog.this.jikesPathField.getText());
                }
            }
        });
        this.classpathCustomButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AWPrefsDialog.this.customClasspathField.setEnabled(AWPrefsDialog.this.classpathCustomButton.isSelected());
                AWPrefsDialog.this.browseCustomClassPathButton.setEnabled(AWPrefsDialog.this.classpathCustomButton.isSelected());
            }
        });
        this.browseCustomClassPathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (XJFileChooser.shared().displayChooseDirectory(AWPrefsDialog.this.getJavaContainer())) {
                    AWPrefsDialog.this.customClasspathField.setText(XJFileChooser.shared().getSelectedFilePath());
                    AWPrefs.setCustomClassPath(AWPrefsDialog.this.customClasspathField.getText());
                }
            }
        });
        this.compilerRadioButtonGroup = new ButtonGroup();
        this.compilerRadioButtonGroup.add(this.jikesRadio);
        this.compilerRadioButtonGroup.add(this.integratedRadio);
        this.compilerRadioButtonGroup.add(this.javacRadio);
        this.integratedRadio.setActionCommand("integrated");
        this.javacRadio.setActionCommand("javac");
        this.jikesRadio.setActionCommand("jikes");
        AWPrefsDialog.getPreferences().bindToPreferences(this.javacCustomPathButton, "PREF_JAVAC_CUSTOM_PATH", false);
        AWPrefsDialog.getPreferences().bindToPreferences(this.javacPathField, "PREF_JAVAC_PATH", "");
        AWPrefsDialog.getPreferences().bindToPreferences(this.jikesPathField, "PREF_JIKES_PATH", "");
        AWPrefsDialog.getPreferences().bindToPreferences(this.compilerRadioButtonGroup, "PREF_COMPILER", "javac");
        AWPrefsDialog.getPreferences().bindToPreferences(this.classpathSystemButton, "PREF_CLASSPATH_SYSTEM", true);
        AWPrefsDialog.getPreferences().bindToPreferences(this.classpathCustomButton, "PREF_CLASSPATH_CUSTOM", false);
        AWPrefsDialog.getPreferences().bindToPreferences(this.customClasspathField, "PREF_CUSTOM_CLASS_PATH", "");
    }

    public void prepareDebuggerTab() {
        AWPrefsDialog.getPreferences().bindToPreferences(this.debugDefaultLocalPortField, "PREF_DEBUG_LOCALPORT", 49153);
        AWPrefsDialog.getPreferences().bindToPreferences(this.debugLaunchTimeoutField, "PREF_DEBUG_LAUNCHTIMEOUT", 5);
        AWPrefsDialog.getPreferences().bindToPreferences(this.debugNonConsumedColorPanel, "PREF_NONCONSUMED_TOKEN_COLOR2", AWPrefs.DEFAULT_NONCONSUMED_TOKEN_COLOR);
        AWPrefsDialog.getPreferences().bindToPreferences(this.debugConsumedColorPanel, "PREF_CONSUMED_TOKEN_COLOR2", AWPrefs.DEFAULT_CONSUMED_TOKEN_COLOR);
        AWPrefsDialog.getPreferences().bindToPreferences(this.debugHiddenColorPanel, "PREF_HIDDEN_TOKEN_COLOR2", AWPrefs.DEFAULT_HIDDEN_TOKEN_COLOR);
        AWPrefsDialog.getPreferences().bindToPreferences(this.debugDeadColorPanel, "PREF_DEAD_TOKEN_COLOR2", AWPrefs.DEFAULT_DEAD_TOKEN_COLOR);
        AWPrefsDialog.getPreferences().bindToPreferences(this.debugLTColorPanel, "PREF_LOOKAHEAD_TOKEN_COLOR2", AWPrefs.DEFAULT_LOOKAHEAD_TOKEN_COLOR);
        AWPrefsDialog.getPreferences().bindToPreferences(this.detachablePanelChildrenButton, "PREF_DETACHABLE_CHILDREN", true);
        AWPrefsDialog.getPreferences().bindToPreferences(this.askGenButton, "PREF_DEBUGGER_ASK_GEN", false);
    }

    public void prepareSCMTab() {
        AWPrefsDialog.getPreferences().bindToPreferences(this.enablePerforceCheckBox, "PREF_SCM_ENABLE_P4", false);
        AWPrefsDialog.getPreferences().bindToPreferences(this.p4PortField, "PREF_SCM_P4_PORT", "");
        AWPrefsDialog.getPreferences().bindToPreferences(this.p4UserField, "PREF_SCM_P4_USER", "");
        AWPrefsDialog.getPreferences().bindToPreferences((JTextField)this.p4PasswordField, "PREF_SCM_P4_PASSWORD", "");
        AWPrefsDialog.getPreferences().bindToPreferences(this.p4ClientField, "PREF_SCM_P4_CLIENT", "");
        AWPrefsDialog.getPreferences().bindToPreferences(this.p4ExecPathField, "PREF_SCM_P4_EXEC", "");
    }

    public void prepareUpdateTab() {
        this.browseUpdateDownloadPathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (XJFileChooser.shared().displayChooseDirectory(AWPrefsDialog.this.getJavaContainer())) {
                    AWPrefsDialog.this.downloadPathField.setText(XJFileChooser.shared().getSelectedFilePath());
                    AWPrefs.setDownloadPath(AWPrefsDialog.this.downloadPathField.getText());
                }
            }
        });
        this.checkForUpdatesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpManager.checkUpdates(AWPrefsDialog.this.getJavaContainer(), false);
            }
        });
        AWPrefsDialog.getPreferences().bindToPreferences(this.updateTypeCombo, "PREF_UPDATE_TYPE", 3);
        AWPrefsDialog.getPreferences().bindToPreferences(this.downloadPathField, "PREF_DOWNLOAD_PATH", AWPrefs.DEFAULT_DOWNLOAD_PATH);
    }

    public void becomingVisibleForTheFirstTime() {
        this.lafIndex = this.lafCombo.getSelectedIndex();
        this.javacPathField.setEnabled(this.javacCustomPathButton.isSelected());
        this.browseJavacPath.setEnabled(this.javacCustomPathButton.isSelected());
        this.customClasspathField.setEnabled(this.classpathCustomButton.isSelected());
        this.browseCustomClassPathButton.setEnabled(this.classpathCustomButton.isSelected());
        this.outputPathField.setEnabled(this.outputPathCustomRadio.isSelected());
        this.browseOutputPathButton.setEnabled(this.outputPathCustomRadio.isSelected());
        StatisticsAW.shared().recordEvent(130);
    }

    public void close() {
        this.apply();
        super.close();
    }

    public boolean isAuxiliaryWindow() {
        return true;
    }

    public static void applyCommonPrefs() {
        ATESyntaxEngine.setDelay(AWPrefs.getParserDelay());
        XJApplication.setAutoSave(AWPrefs.getAutoSaveEnabled(), AWPrefs.getAutoSaveDelay());
    }

    public JComponent getComponent() {
        return this.tabbedPane1;
    }

    public void apply() {
        this.dialogPane.requestFocusInWindow();
        AWPrefsDialog.getPreferences().applyPreferences();
        if (this.lafIndex != this.lafCombo.getSelectedIndex()) {
            this.lafIndex = this.lafCombo.getSelectedIndex();
            if (!IDE.isPlugin()) {
                this.changeLookAndFeel();
            }
        }
        AWPrefsDialog.applyCommonPrefs();
        XJNotificationCenter.defaultCenter().postNotification(this, NOTIF_PREFS_APPLIED);
    }

    private void changeLookAndFeel() {
        XJLookAndFeel.applyLookAndFeel(AWPrefs.getLookAndFeel());
    }

    private static XJPreferences getPreferences() {
        return XJApplication.shared().getPreferences();
    }

    public boolean shouldDisplayMainMenuBar() {
        return super.shouldDisplayMainMenuBar() && !IDE.isPlugin();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPane = new JPanel();
        this.tabbedPane1 = new JTabbedPane();
        this.tabGeneral = new JPanel();
        this.label2 = new JLabel();
        this.label5 = new JLabel();
        this.lafCombo = new JComboBox();
        this.startupActionCombo = new JComboBox();
        this.restoreWindowsBoundButton = new JCheckBox();
        this.desktopModeButton = new JCheckBox();
        this.label25 = new JLabel();
        this.outputPathSameRadio = new JRadioButton();
        this.outputPathCustomRadio = new JRadioButton();
        this.outputPathField = new JTextField();
        this.browseOutputPathButton = new JButton();
        this.label24 = new JLabel();
        this.dotToolPathField = new JTextField();
        this.browseDotToolPathButton = new JButton();
        this.label37 = new JLabel();
        this.antlr3OptionsField = new JTextField();
        this.tabEditor = new JPanel();
        this.label3 = new JLabel();
        this.editorFontCombo = new JComboBox();
        this.editorFontSizeSpinner = new JSpinner();
        this.autoSaveButton = new JCheckBox();
        this.autoSaveDelayField = new JTextField();
        this.label11 = new JLabel();
        this.backupFileButton = new JCheckBox();
        this.highlightCursorLineButton = new JCheckBox();
        this.smoothScrollingButton = new JCheckBox();
        this.autoIndentColonInRuleButton = new JCheckBox();
        this.showLineNumbers = new JCheckBox();
        this.vstyleAutocompletionButton = new JCheckBox();
        this.label1 = new JLabel();
        this.tabWidthField = new JTextField();
        this.label22 = new JLabel();
        this.parserDelayField = new JTextField();
        this.label23 = new JLabel();
        this.tabSyntax = new JPanel();
        this.label26 = new JLabel();
        this.parserColorPanel = new JPanel();
        this.parserBoldButton = new JCheckBox();
        this.parserItalicButton = new JCheckBox();
        this.label27 = new JLabel();
        this.lexerColorPanel = new JPanel();
        this.lexerBoldButton = new JCheckBox();
        this.lexerItalicButton = new JCheckBox();
        this.label28 = new JLabel();
        this.labelColorPanel = new JPanel();
        this.labelsBoldButton = new JCheckBox();
        this.labelsItalicButton = new JCheckBox();
        this.label29 = new JLabel();
        this.refsActionColorPanel = new JPanel();
        this.refsActionBoldButton = new JCheckBox();
        this.refsActionItalicButton = new JCheckBox();
        this.label30 = new JLabel();
        this.commentsColorPanel = new JPanel();
        this.commentsBoldButton = new JCheckBox();
        this.commentsItalicButton = new JCheckBox();
        this.label31 = new JLabel();
        this.stringsColorPanel = new JPanel();
        this.stringsBoldButton = new JCheckBox();
        this.stringsItalicButton = new JCheckBox();
        this.label32 = new JLabel();
        this.keywordsColorPanel = new JPanel();
        this.keywordsBoldButton = new JCheckBox();
        this.syntaxDefaultButton = new JButton();
        this.keywordsItalicButton = new JCheckBox();
        this.tabCompiler = new JPanel();
        this.jikesRadio = new JRadioButton();
        this.integratedRadio = new JRadioButton();
        this.javacRadio = new JRadioButton();
        this.javacCustomPathButton = new JCheckBox();
        this.javacPathField = new JTextField();
        this.browseJavacPath = new JButton();
        this.label4 = new JLabel();
        this.jikesPathField = new JTextField();
        this.browseJikesPath = new JButton();
        this.label9 = new JLabel();
        this.classpathSystemButton = new JCheckBox();
        this.classpathCustomButton = new JCheckBox();
        this.customClasspathField = new JTextField();
        this.browseCustomClassPathButton = new JButton();
        this.tabDebugger = new JPanel();
        this.label33 = new JLabel();
        this.debugDefaultLocalPortField = new JTextField();
        this.label34 = new JLabel();
        this.debugLaunchTimeoutField = new JTextField();
        this.label35 = new JLabel();
        this.label12 = new JLabel();
        this.debugNonConsumedColorPanel = new JPanel();
        this.label13 = new JLabel();
        this.debugConsumedColorPanel = new JPanel();
        this.label14 = new JLabel();
        this.debugHiddenColorPanel = new JPanel();
        this.label15 = new JLabel();
        this.debugDeadColorPanel = new JPanel();
        this.label16 = new JLabel();
        this.debugLTColorPanel = new JPanel();
        this.label36 = new JLabel();
        this.detachablePanelChildrenButton = new JCheckBox();
        this.askGenButton = new JCheckBox();
        this.tabSCM = new JPanel();
        this.enablePerforceCheckBox = new JCheckBox();
        this.label18 = new JLabel();
        this.p4PortField = new JTextField();
        this.label19 = new JLabel();
        this.p4UserField = new JTextField();
        this.label21 = new JLabel();
        this.p4PasswordField = new JPasswordField();
        this.label20 = new JLabel();
        this.p4ClientField = new JTextField();
        this.label17 = new JLabel();
        this.p4ExecPathField = new JTextField();
        this.tabUpdates = new JPanel();
        this.label7 = new JLabel();
        this.updateTypeCombo = new JComboBox();
        this.checkForUpdatesButton = new JButton();
        this.label10 = new JLabel();
        this.downloadPathField = new JTextField();
        this.browseUpdateDownloadPathButton = new JButton();
        this.buttonBar = new JPanel();
        this.applyButton = new JButton();
        CellConstraints cellConstraints = new CellConstraints();
        this.setTitle("Preferences");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.dialogPane.setBorder(Borders.DIALOG_BORDER);
        this.dialogPane.setMinimumSize(new Dimension(540, 350));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPane.setLayout(new FormLayout("default, default:grow", "fill:default:grow"));
        this.tabGeneral.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(min;20dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(min;40dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(10))}, new RowSpec[]{new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.label2.setText("At startup:");
        this.tabGeneral.add((Component)this.label2, cellConstraints.xy(3, 3));
        this.label5.setText("Look and feel:");
        this.tabGeneral.add((Component)this.label5, cellConstraints.xy(3, 7));
        this.tabGeneral.add((Component)this.lafCombo, cellConstraints.xywh(5, 7, 3, 1));
        this.startupActionCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Create a new document", "Open the last opened document", "Open the last saved document", "Open all opened documents when ANTLRWorks was closed"}));
        this.tabGeneral.add((Component)this.startupActionCombo, cellConstraints.xywh(5, 3, 3, 1));
        this.restoreWindowsBoundButton.setText("Restore project's windows position and size");
        this.tabGeneral.add((Component)this.restoreWindowsBoundButton, cellConstraints.xywh(5, 5, 3, 1));
        this.desktopModeButton.setText("Desktop Mode");
        this.desktopModeButton.setToolTipText("This option will take effect after restarting ANTLRWorks");
        this.tabGeneral.add((Component)this.desktopModeButton, cellConstraints.xywh(5, 9, 3, 1));
        this.label25.setText("Output path:");
        this.tabGeneral.add((Component)this.label25, cellConstraints.xy(3, 11));
        this.outputPathSameRadio.setText("Same as grammar");
        this.tabGeneral.add((Component)this.outputPathSameRadio, cellConstraints.xy(5, 11));
        this.outputPathCustomRadio.setText("Custom:");
        this.tabGeneral.add((Component)this.outputPathCustomRadio, cellConstraints.xy(7, 11));
        this.outputPathField.setToolTipText("Absolute path to the DOT command-line tool");
        this.tabGeneral.add((Component)this.outputPathField, cellConstraints.xywh(5, 13, 3, 1));
        this.browseOutputPathButton.setText("Browse...");
        this.tabGeneral.add((Component)this.browseOutputPathButton, cellConstraints.xy(9, 13));
        this.label24.setText("DOT path:");
        this.tabGeneral.add((Component)this.label24, cellConstraints.xy(3, 15));
        this.dotToolPathField.setToolTipText("Absolute path to the DOT command-line tool");
        this.tabGeneral.add((Component)this.dotToolPathField, cellConstraints.xywh(5, 15, 3, 1));
        this.browseDotToolPathButton.setText("Browse...");
        this.tabGeneral.add((Component)this.browseDotToolPathButton, cellConstraints.xy(9, 15));
        this.label37.setText("ANTLR options:");
        this.tabGeneral.add((Component)this.label37, cellConstraints.xy(3, 17));
        this.tabGeneral.add((Component)this.antlr3OptionsField, cellConstraints.xywh(5, 17, 3, 1));
        this.tabbedPane1.addTab("General", this.tabGeneral);
        this.tabEditor.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(20)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(default;45dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(20)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(30)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(10))}, new RowSpec[]{new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.dluY(10))}));
        this.label3.setText("Font:");
        this.tabEditor.add((Component)this.label3, cellConstraints.xy(3, 3));
        this.editorFontCombo.setActionCommand("editorFontCombo");
        this.tabEditor.add((Component)this.editorFontCombo, cellConstraints.xywh(5, 3, 5, 1));
        this.editorFontSizeSpinner.setModel(new SpinnerNumberModel((Number)12, Integer.valueOf(8), null, (Number)1));
        this.tabEditor.add((Component)this.editorFontSizeSpinner, cellConstraints.xy(11, 3));
        this.autoSaveButton.setText("Auto-save every");
        this.tabEditor.add((Component)this.autoSaveButton, cellConstraints.xywh(5, 5, 3, 1));
        this.tabEditor.add((Component)this.autoSaveDelayField, cellConstraints.xy(9, 5));
        this.label11.setText("minutes");
        this.tabEditor.add((Component)this.label11, cellConstraints.xy(11, 5));
        this.backupFileButton.setText("Create backup file");
        this.tabEditor.add((Component)this.backupFileButton, cellConstraints.xywh(5, 7, 5, 1));
        this.highlightCursorLineButton.setText("Highlight cursor line");
        this.tabEditor.add((Component)this.highlightCursorLineButton, cellConstraints.xywh(5, 9, 5, 1));
        this.smoothScrollingButton.setText("Smooth scrolling");
        this.tabEditor.add((Component)this.smoothScrollingButton, cellConstraints.xywh(5, 11, 3, 1));
        this.autoIndentColonInRuleButton.setText("Auto-indent ':' in rule");
        this.tabEditor.add((Component)this.autoIndentColonInRuleButton, cellConstraints.xywh(5, 13, 7, 1));
        this.showLineNumbers.setText("Show line numbers");
        this.tabEditor.add((Component)this.showLineNumbers, cellConstraints.xywh(5, 15, 5, 1));
        this.vstyleAutocompletionButton.setText("Visual Studio auto-completion menu");
        this.vstyleAutocompletionButton.setToolTipText("Displayed when a space is pressed, remember previous auto-completed word, continues to auto-complete without decreasing the word choice as you type");
        this.tabEditor.add((Component)this.vstyleAutocompletionButton, cellConstraints.xywh(5, 17, 9, 1));
        this.label1.setText("Tab width:");
        this.label1.setHorizontalAlignment(4);
        this.tabEditor.add((Component)this.label1, cellConstraints.xy(3, 19));
        this.tabWidthField.setText("8");
        this.tabEditor.add((Component)this.tabWidthField, cellConstraints.xy(5, 19));
        this.label22.setText("Update delay:");
        this.tabEditor.add((Component)this.label22, cellConstraints.xy(3, 21));
        this.parserDelayField.setText("250");
        this.tabEditor.add((Component)this.parserDelayField, cellConstraints.xy(5, 21));
        this.label23.setText("ms");
        this.tabEditor.add((Component)this.label23, cellConstraints.xy(7, 21));
        this.tabbedPane1.addTab("Editor", this.tabEditor);
        this.tabSyntax.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(20)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0)}, new RowSpec[]{new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.label26.setText("Parser References:");
        this.tabSyntax.add((Component)this.label26, cellConstraints.xywh(3, 3, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.parserColorPanel.setForeground(Color.black);
        this.parserColorPanel.setPreferredSize(new Dimension(70, 20));
        this.parserColorPanel.setBackground(new Color(255, 255, 51));
        this.parserColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.parserColorPanel.setLayout(new FlowLayout());
        this.tabSyntax.add((Component)this.parserColorPanel, cellConstraints.xy(5, 3));
        this.parserBoldButton.setText("Bold");
        this.parserBoldButton.setFont(new Font("Lucida Grande", 1, 13));
        this.tabSyntax.add((Component)this.parserBoldButton, cellConstraints.xy(7, 3));
        this.parserItalicButton.setText("Italic");
        this.parserItalicButton.setFont(new Font("Lucida Grande", 2, 13));
        this.tabSyntax.add((Component)this.parserItalicButton, cellConstraints.xy(9, 3));
        this.label27.setText("Lexer References:");
        this.tabSyntax.add((Component)this.label27, cellConstraints.xy(3, 5));
        this.lexerColorPanel.setForeground(Color.black);
        this.lexerColorPanel.setPreferredSize(new Dimension(70, 20));
        this.lexerColorPanel.setBackground(new Color(255, 255, 51));
        this.lexerColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.lexerColorPanel.setLayout(new FlowLayout());
        this.tabSyntax.add((Component)this.lexerColorPanel, cellConstraints.xy(5, 5));
        this.lexerBoldButton.setText("Bold");
        this.lexerBoldButton.setFont(new Font("Lucida Grande", 1, 13));
        this.tabSyntax.add((Component)this.lexerBoldButton, cellConstraints.xy(7, 5));
        this.lexerItalicButton.setText("Italic");
        this.lexerItalicButton.setFont(new Font("Lucida Grande", 2, 13));
        this.tabSyntax.add((Component)this.lexerItalicButton, cellConstraints.xy(9, 5));
        this.label28.setText("Labels:");
        this.tabSyntax.add((Component)this.label28, cellConstraints.xy(3, 7));
        this.labelColorPanel.setForeground(Color.black);
        this.labelColorPanel.setPreferredSize(new Dimension(70, 20));
        this.labelColorPanel.setBackground(new Color(255, 255, 51));
        this.labelColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.labelColorPanel.setLayout(new FlowLayout());
        this.tabSyntax.add((Component)this.labelColorPanel, cellConstraints.xy(5, 7));
        this.labelsBoldButton.setText("Bold");
        this.labelsBoldButton.setFont(new Font("Lucida Grande", 1, 13));
        this.tabSyntax.add((Component)this.labelsBoldButton, cellConstraints.xy(7, 7));
        this.labelsItalicButton.setText("Italic");
        this.labelsItalicButton.setFont(new Font("Lucida Grande", 2, 13));
        this.tabSyntax.add((Component)this.labelsItalicButton, cellConstraints.xy(9, 7));
        this.label29.setText("References in action:");
        this.tabSyntax.add((Component)this.label29, cellConstraints.xy(3, 9));
        this.refsActionColorPanel.setForeground(Color.black);
        this.refsActionColorPanel.setPreferredSize(new Dimension(70, 20));
        this.refsActionColorPanel.setBackground(new Color(255, 255, 51));
        this.refsActionColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.refsActionColorPanel.setLayout(new FlowLayout());
        this.tabSyntax.add((Component)this.refsActionColorPanel, cellConstraints.xy(5, 9));
        this.refsActionBoldButton.setText("Bold");
        this.refsActionBoldButton.setFont(new Font("Lucida Grande", 1, 13));
        this.tabSyntax.add((Component)this.refsActionBoldButton, cellConstraints.xy(7, 9));
        this.refsActionItalicButton.setText("Italic");
        this.refsActionItalicButton.setFont(new Font("Lucida Grande", 2, 13));
        this.tabSyntax.add((Component)this.refsActionItalicButton, cellConstraints.xy(9, 9));
        this.label30.setText("Comments:");
        this.tabSyntax.add((Component)this.label30, cellConstraints.xy(3, 11));
        this.commentsColorPanel.setForeground(Color.black);
        this.commentsColorPanel.setPreferredSize(new Dimension(70, 20));
        this.commentsColorPanel.setBackground(new Color(255, 255, 51));
        this.commentsColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.commentsColorPanel.setLayout(new FlowLayout());
        this.tabSyntax.add((Component)this.commentsColorPanel, cellConstraints.xy(5, 11));
        this.commentsBoldButton.setText("Bold");
        this.commentsBoldButton.setFont(new Font("Lucida Grande", 1, 13));
        this.tabSyntax.add((Component)this.commentsBoldButton, cellConstraints.xy(7, 11));
        this.commentsItalicButton.setText("Italic");
        this.commentsItalicButton.setFont(new Font("Lucida Grande", 2, 13));
        this.tabSyntax.add((Component)this.commentsItalicButton, cellConstraints.xy(9, 11));
        this.label31.setText("Strings:");
        this.tabSyntax.add((Component)this.label31, cellConstraints.xy(3, 13));
        this.stringsColorPanel.setForeground(Color.black);
        this.stringsColorPanel.setPreferredSize(new Dimension(70, 20));
        this.stringsColorPanel.setBackground(new Color(255, 255, 51));
        this.stringsColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.stringsColorPanel.setLayout(new FlowLayout());
        this.tabSyntax.add((Component)this.stringsColorPanel, cellConstraints.xy(5, 13));
        this.stringsBoldButton.setText("Bold");
        this.stringsBoldButton.setFont(new Font("Lucida Grande", 1, 13));
        this.tabSyntax.add((Component)this.stringsBoldButton, cellConstraints.xy(7, 13));
        this.stringsItalicButton.setText("Italic");
        this.stringsItalicButton.setFont(new Font("Lucida Grande", 2, 13));
        this.tabSyntax.add((Component)this.stringsItalicButton, cellConstraints.xy(9, 13));
        this.label32.setText("Keywords:");
        this.tabSyntax.add((Component)this.label32, cellConstraints.xy(3, 15));
        this.keywordsColorPanel.setForeground(Color.black);
        this.keywordsColorPanel.setPreferredSize(new Dimension(70, 20));
        this.keywordsColorPanel.setBackground(new Color(255, 255, 51));
        this.keywordsColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.keywordsColorPanel.setLayout(new FlowLayout());
        this.tabSyntax.add((Component)this.keywordsColorPanel, cellConstraints.xy(5, 15));
        this.keywordsBoldButton.setText("Bold");
        this.keywordsBoldButton.setFont(new Font("Lucida Grande", 1, 13));
        this.tabSyntax.add((Component)this.keywordsBoldButton, cellConstraints.xy(7, 15));
        this.syntaxDefaultButton.setText("Default");
        this.tabSyntax.add((Component)this.syntaxDefaultButton, cellConstraints.xy(13, 15));
        this.keywordsItalicButton.setText("Italic");
        this.keywordsItalicButton.setFont(new Font("Lucida Grande", 2, 13));
        this.tabSyntax.add((Component)this.keywordsItalicButton, cellConstraints.xy(9, 15));
        this.tabbedPane1.addTab("Syntax", this.tabSyntax);
        this.tabCompiler.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.DEFAULT_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.DEFAULT_COLSPEC, new ColumnSpec(Sizes.dluX(10))}, new RowSpec[]{new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.jikesRadio.setText("jikes");
        this.tabCompiler.add((Component)this.jikesRadio, cellConstraints.xywh(3, 7, 2, 1));
        this.integratedRadio.setText("com.sun.tools.javac");
        this.integratedRadio.setActionCommand("integrated");
        this.tabCompiler.add((Component)this.integratedRadio, cellConstraints.xywh(3, 11, 3, 1));
        this.javacRadio.setText("javac");
        this.javacRadio.setSelected(true);
        this.tabCompiler.add((Component)this.javacRadio, cellConstraints.xywh(3, 3, 2, 1));
        this.javacCustomPathButton.setText("Path:");
        this.javacCustomPathButton.setToolTipText("Check to specify a custom path if the default system path doesn't include javac");
        this.tabCompiler.add((Component)this.javacCustomPathButton, cellConstraints.xywh(4, 5, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.tabCompiler.add((Component)this.javacPathField, cellConstraints.xy(5, 5));
        this.browseJavacPath.setText("Browse...");
        this.tabCompiler.add((Component)this.browseJavacPath, cellConstraints.xy(6, 5));
        this.label4.setText("Path:");
        this.tabCompiler.add((Component)this.label4, cellConstraints.xywh(4, 9, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.tabCompiler.add((Component)this.jikesPathField, cellConstraints.xy(5, 9));
        this.browseJikesPath.setText("Browse...");
        this.tabCompiler.add((Component)this.browseJikesPath, cellConstraints.xy(6, 9));
        this.label9.setText("Classpath:");
        this.tabCompiler.add((Component)this.label9, cellConstraints.xy(3, 15));
        this.classpathSystemButton.setText("System");
        this.tabCompiler.add((Component)this.classpathSystemButton, cellConstraints.xy(4, 15));
        this.classpathCustomButton.setText("Custom:");
        this.tabCompiler.add((Component)this.classpathCustomButton, cellConstraints.xy(4, 17));
        this.tabCompiler.add((Component)this.customClasspathField, cellConstraints.xy(5, 17));
        this.browseCustomClassPathButton.setText("Browse...");
        this.tabCompiler.add((Component)this.browseCustomClassPathButton, cellConstraints.xy(6, 17));
        this.tabbedPane1.addTab("Compiler", this.tabCompiler);
        this.tabDebugger.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(default;20dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(10))}, new RowSpec[]{new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.label33.setText("Default local port:");
        this.tabDebugger.add((Component)this.label33, cellConstraints.xy(3, 3));
        this.debugDefaultLocalPortField.setText("0xC001");
        this.tabDebugger.add((Component)this.debugDefaultLocalPortField, cellConstraints.xy(5, 3));
        this.label34.setText("Remote parser launch time-out:");
        this.tabDebugger.add((Component)this.label34, cellConstraints.xy(9, 3));
        this.debugLaunchTimeoutField.setText("5");
        this.tabDebugger.add((Component)this.debugLaunchTimeoutField, cellConstraints.xy(11, 3));
        this.label35.setText("seconds");
        this.tabDebugger.add((Component)this.label35, cellConstraints.xy(13, 3));
        this.label12.setText("Non-consumed token:");
        this.label12.setHorizontalAlignment(4);
        this.tabDebugger.add((Component)this.label12, cellConstraints.xy(3, 7));
        this.debugNonConsumedColorPanel.setForeground(Color.black);
        this.debugNonConsumedColorPanel.setPreferredSize(new Dimension(70, 20));
        this.debugNonConsumedColorPanel.setBackground(new Color(255, 255, 51));
        this.debugNonConsumedColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.debugNonConsumedColorPanel.setLayout(new FlowLayout());
        this.tabDebugger.add((Component)this.debugNonConsumedColorPanel, cellConstraints.xy(5, 7));
        this.label13.setText("Consumed token:");
        this.label13.setHorizontalAlignment(4);
        this.tabDebugger.add((Component)this.label13, cellConstraints.xy(3, 9));
        this.debugConsumedColorPanel.setForeground(Color.black);
        this.debugConsumedColorPanel.setPreferredSize(new Dimension(70, 20));
        this.debugConsumedColorPanel.setBackground(new Color(255, 255, 51));
        this.debugConsumedColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.debugConsumedColorPanel.setLayout(new FlowLayout());
        this.tabDebugger.add((Component)this.debugConsumedColorPanel, cellConstraints.xy(5, 9));
        this.label14.setText("Hidden token:");
        this.label14.setHorizontalAlignment(4);
        this.tabDebugger.add((Component)this.label14, cellConstraints.xy(3, 11));
        this.debugHiddenColorPanel.setForeground(Color.black);
        this.debugHiddenColorPanel.setPreferredSize(new Dimension(70, 20));
        this.debugHiddenColorPanel.setBackground(new Color(255, 255, 51));
        this.debugHiddenColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.debugHiddenColorPanel.setLayout(new FlowLayout());
        this.tabDebugger.add((Component)this.debugHiddenColorPanel, cellConstraints.xy(5, 11));
        this.label15.setText("Dead token:");
        this.label15.setHorizontalAlignment(4);
        this.tabDebugger.add((Component)this.label15, cellConstraints.xy(3, 13));
        this.debugDeadColorPanel.setForeground(Color.black);
        this.debugDeadColorPanel.setPreferredSize(new Dimension(70, 20));
        this.debugDeadColorPanel.setBackground(new Color(255, 255, 51));
        this.debugDeadColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.debugDeadColorPanel.setLayout(new FlowLayout());
        this.tabDebugger.add((Component)this.debugDeadColorPanel, cellConstraints.xy(5, 13));
        this.label16.setText("Lookahead token:");
        this.label16.setHorizontalAlignment(4);
        this.tabDebugger.add((Component)this.label16, cellConstraints.xy(3, 15));
        this.debugLTColorPanel.setForeground(Color.black);
        this.debugLTColorPanel.setPreferredSize(new Dimension(70, 20));
        this.debugLTColorPanel.setBackground(new Color(255, 255, 51));
        this.debugLTColorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.debugLTColorPanel.setLayout(new FlowLayout());
        this.tabDebugger.add((Component)this.debugLTColorPanel, cellConstraints.xy(5, 15));
        this.label36.setText("Detachable panels:");
        this.tabDebugger.add((Component)this.label36, cellConstraints.xy(3, 19));
        this.detachablePanelChildrenButton.setText("Children of project's window");
        this.tabDebugger.add((Component)this.detachablePanelChildrenButton, cellConstraints.xywh(5, 19, 5, 1));
        this.askGenButton.setText("Ask before generating and compiling");
        this.tabDebugger.add((Component)this.askGenButton, cellConstraints.xywh(5, 21, 5, 1));
        this.tabbedPane1.addTab("Debugger", this.tabDebugger);
        this.tabSCM.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(10))}, new RowSpec[]{new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.DLUY5), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.DLUY5), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.dluY(10))}));
        this.enablePerforceCheckBox.setText("Enable Perforce");
        this.tabSCM.add((Component)this.enablePerforceCheckBox, cellConstraints.xy(5, 3));
        this.label18.setText("Port:");
        this.tabSCM.add((Component)this.label18, cellConstraints.xy(3, 7));
        this.tabSCM.add((Component)this.p4PortField, cellConstraints.xy(5, 7));
        this.label19.setText("User:");
        this.tabSCM.add((Component)this.label19, cellConstraints.xy(3, 9));
        this.tabSCM.add((Component)this.p4UserField, cellConstraints.xy(5, 9));
        this.label21.setText("Password:");
        this.tabSCM.add((Component)this.label21, cellConstraints.xy(3, 11));
        this.tabSCM.add((Component)this.p4PasswordField, cellConstraints.xy(5, 11));
        this.label20.setText("Client:");
        this.tabSCM.add((Component)this.label20, cellConstraints.xy(3, 13));
        this.tabSCM.add((Component)this.p4ClientField, cellConstraints.xy(5, 13));
        this.label17.setText("P4 executable path:");
        this.tabSCM.add((Component)this.label17, cellConstraints.xy(3, 17));
        this.tabSCM.add((Component)this.p4ExecPathField, cellConstraints.xy(5, 17));
        this.tabbedPane1.addTab("SCM", this.tabSCM);
        this.tabUpdates.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(10))}, new RowSpec[]{new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.label7.setText("Check for ANTLRWorks updates:");
        this.label7.setHorizontalAlignment(2);
        this.tabUpdates.add((Component)this.label7, cellConstraints.xy(3, 3));
        this.updateTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Manually", "At startup", "Daily", "Weekly"}));
        this.tabUpdates.add((Component)this.updateTypeCombo, cellConstraints.xywh(3, 5, 4, 1));
        this.checkForUpdatesButton.setText("Check Now");
        this.tabUpdates.add((Component)this.checkForUpdatesButton, cellConstraints.xy(7, 5));
        this.label10.setText("Download path:");
        this.label10.setHorizontalAlignment(2);
        this.tabUpdates.add((Component)this.label10, cellConstraints.xy(3, 9));
        this.tabUpdates.add((Component)this.downloadPathField, cellConstraints.xywh(3, 11, 3, 1));
        this.browseUpdateDownloadPathButton.setText("Browse...");
        this.browseUpdateDownloadPathButton.setActionCommand("Browse");
        this.tabUpdates.add((Component)this.browseUpdateDownloadPathButton, cellConstraints.xy(7, 11));
        this.tabbedPane1.addTab("Updates", this.tabUpdates);
        this.contentPane.add((Component)this.tabbedPane1, cellConstraints.xywh(1, 1, 2, 1));
        this.dialogPane.add((Component)this.contentPane, "Center");
        this.buttonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.buttonBar.setLayout(new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs("pref")));
        this.applyButton.setText("Apply");
        this.buttonBar.add((Component)this.applyButton, cellConstraints.xy(2, 1));
        this.dialogPane.add((Component)this.buttonBar, "South");
        container.add((Component)this.dialogPane, "Center");
        this.pack();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.outputPathSameRadio);
        buttonGroup.add(this.outputPathCustomRadio);
    }
}

