/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.prefs;

import java.awt.Color;
import java.awt.Font;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.app.XJPreferences;
import org.antlr.xjlib.foundation.XJSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWPrefs {
    public static final String PREF_STARTUP_ACTION = "PREF_STARTUP_ACTION";
    public static final String PREF_LAST_SAVED_DOCUMENT = "PREF_LAST_SAVED_DOCUMENT";
    public static final String PREF_ALL_OPENED_DOCUMENTS = "PREF_ALL_OPENED_DOCUMENTS";
    public static final String PREF_RESTORE_WINDOWS = "PREF_RESTORE_WINDOWS";
    public static final String PREF_LOOK_AND_FEEL = "PREF_LOOK_AND_FEEL";
    public static final String PREF_DESKTOP_MODE = "PREF_DESKTOP_MODE";
    public static final String PREF_DEBUG_VERBOSE = "PREF_DEBUG_VERBOSE";
    public static final String PREF_DEBUG_DONT_OPTIMIZE_NFA = "PREF_DONT_OPTIMIZE_NFA";
    public static final String PREF_DOT_TOOL_PATH = "PREF_DOT_TOOL_PATH";
    public static final String PREF_ANTLR3_OPTIONS = "PREF_ANTLR3_OPTIONS";
    public static final String PREF_TOOLBAR_SORT = "PREF_TOOLBAR_SORT";
    public static final int STARTUP_NEW_DOC = 0;
    public static final int STARTUP_OPEN_LAST_OPENED_DOC = 1;
    public static final int STARTUP_OPEN_LAST_SAVED_DOC = 2;
    public static final int STARTUP_OPEN_ALL_OPENED_DOC = 3;
    public static final boolean DEFAULT_DESKTOP_MODE;
    public static final String DEFAULT_DOT_TOOL_PATH;
    public static final String DEFAULT_ANTLR3_OPTIONS = "";
    public static final boolean DEFAULT_RESTORE_WINDOWS = true;
    public static final String PREF_TAB_WIDTH = "PREF_TAB_WIDTH";
    public static final String PREF_AUTOSAVE_ENABLED = "PREF_AUTOSAVE_ENABLED";
    public static final String PREF_AUTOSAVE_DELAY = "PREF_AUTOSAVE_DELAY";
    public static final String PREF_BACKUP_FILE_ENABLED = "PREF_BACKUP_FILE_ENABLED";
    public static final String PREF_HIGHLIGHTCURSORLINE = "PREF_HIGHLIGHTCURSORLINE";
    public static final String PREF_EDITOR_FONT = "PREF_EDITOR_FONT";
    public static final String PREF_EDITOR_FONT_SIZE = "PREF_EDITOR_FONT_SIZE";
    public static final String PREF_EDITOR_FOLDING = "PREF_EDITOR_FOLDING";
    public static final String PREF_ACTIONS_ANCHORS_FOLDING = "PREF_ACTIONS_ANCHORS_FOLDING";
    public static final String PREF_AUTO_IDENT_COLON_RULE = "PREF_AUTO_IDENT_COLON_RULE";
    public static final String PREF_LINE_NUMBER = "PREF_LINE_NUMBER";
    public static final String PREF_VSTYLE_AUTOCOMPLETION = "PREF_VSTYLE_AUTOCOMPLETION";
    public static final String PREF_PARSER_DELAY = "PREF_PARSER_DELAY";
    public static final String PREF_SMOOTH_SCROLLING = "PREF_SMOOTH_SCROLLING";
    public static final int DEFAULT_TAB_WIDTH = 8;
    public static String DEFAULT_EDITOR_FONT;
    public static final int DEFAULT_EDITOR_FONT_SIZE = 12;
    public static final boolean DEFAULT_EDITOR_FOLDING = true;
    public static final boolean DEFAULT_ACTIONS_ANCHORS_FOLDING = true;
    public static final boolean DEFAULT_AUTO_INDENT_COLON_RULE = true;
    public static final int DEFAULT_PARSER_DELAY = 250;
    public static final boolean DEFAULT_SMOOTH_SCROLLING = true;
    public static final String PREF_SYNTAX_PARSER = "PREF_SYNTAX_PARSER";
    public static final String PREF_SYNTAX_LEXER = "PREF_SYNTAX_LEXER";
    public static final String PREF_SYNTAX_LABEL = "PREF_SYNTAX_LABEL";
    public static final String PREF_SYNTAX_REFS = "PREF_SYNTAX_REFS";
    public static final String PREF_SYNTAX_COMMENT = "PREF_SYNTAX_COMMENT";
    public static final String PREF_SYNTAX_STRING = "PREF_SYNTAX_STRING";
    public static final String PREF_SYNTAX_KEYWORD = "PREF_SYNTAX_KEYWORD";
    public static Map<String, Color> color;
    public static Map<String, Boolean> bold;
    public static Map<String, Boolean> italic;
    public static final String PREF_SCM_P4_ENABLED = "PREF_SCM_ENABLE_P4";
    public static final String PREF_SCM_P4_PORT = "PREF_SCM_P4_PORT";
    public static final String PREF_SCM_P4_USER = "PREF_SCM_P4_USER";
    public static final String PREF_SCM_P4_PASSWORD = "PREF_SCM_P4_PASSWORD";
    public static final String PREF_SCM_P4_CLIENT = "PREF_SCM_P4_CLIENT";
    public static final String PREF_SCM_P4_EXEC = "PREF_SCM_P4_EXEC";
    public static final String PREF_JAVAC_CUSTOM_PATH = "PREF_JAVAC_CUSTOM_PATH";
    public static final String PREF_JAVAC_PATH = "PREF_JAVAC_PATH";
    public static final String PREF_JIKES_PATH = "PREF_JIKES_PATH";
    public static final String PREF_CUSTOM_CLASS_PATH = "PREF_CUSTOM_CLASS_PATH";
    public static final String PREF_COMPILER = "PREF_COMPILER";
    public static final String PREF_CLASSPATH_SYSTEM = "PREF_CLASSPATH_SYSTEM";
    public static final String PREF_CLASSPATH_CUSTOM = "PREF_CLASSPATH_CUSTOM";
    public static final boolean DEFAULT_JAVAC_CUSTOM_PATH = false;
    public static final String DEFAULT_JAVAC_PATH = "";
    public static final String DEFAULT_JIKES_PATH = "";
    public static final String DEFAULT_PREF_CUSTOM_CLASS_PATH = "";
    public static final String DEFAULT_COMPILER = "javac";
    public static final boolean DEFAULT_CLASSPATH_SYSTEM = true;
    public static final boolean DEFAULT_CLASSPATH_CUSTOM = false;
    public static final String COMPILER_JAVAC = "javac";
    public static final String COMPILER_JIKES = "jikes";
    public static final String COMPILER_INTEGRATED = "integrated";
    public static final String PREF_UPDATE_TYPE = "PREF_UPDATE_TYPE";
    public static final String PREF_DOWNLOAD_PATH = "PREF_DOWNLOAD_PATH";
    public static final String PREF_UPDATE_NEXT_DATE = "PREF_UPDATE_NEXT_DATE";
    public static final int UPDATE_MANUALLY = 0;
    public static final int UPDATE_AT_STARTUP = 1;
    public static final int UPDATE_DAILY = 2;
    public static final int UPDATE_WEEKLY = 3;
    public static final int DEFAULT_UPDATE_TYPE = 3;
    public static final String DEFAULT_DOWNLOAD_PATH;
    public static final String PREF_NONCONSUMED_TOKEN_COLOR = "PREF_NONCONSUMED_TOKEN_COLOR2";
    public static final Color DEFAULT_NONCONSUMED_TOKEN_COLOR;
    public static final String PREF_CONSUMED_TOKEN_COLOR = "PREF_CONSUMED_TOKEN_COLOR2";
    public static final Color DEFAULT_CONSUMED_TOKEN_COLOR;
    public static final String PREF_HIDDEN_TOKEN_COLOR = "PREF_HIDDEN_TOKEN_COLOR2";
    public static final Color DEFAULT_HIDDEN_TOKEN_COLOR;
    public static final String PREF_DEAD_TOKEN_COLOR = "PREF_DEAD_TOKEN_COLOR2";
    public static final Color DEFAULT_DEAD_TOKEN_COLOR;
    public static final String PREF_LOOKAHEAD_TOKEN_COLOR = "PREF_LOOKAHEAD_TOKEN_COLOR2";
    public static final Color DEFAULT_LOOKAHEAD_TOKEN_COLOR;
    public static final String PREF_DEBUG_LOCALPORT = "PREF_DEBUG_LOCALPORT";
    public static final int DEFAULT_DEBUG_LOCALPORT = 49153;
    public static final String PREF_DEBUG_LAUNCHTIMEOUT = "PREF_DEBUG_LAUNCHTIMEOUT";
    public static final int DEFAULT_DEBUG_LAUNCHTIMEOUT = 5;
    public static final String PREF_DETACHABLE_CHILDREN = "PREF_DETACHABLE_CHILDREN";
    public static final boolean DEFAULT_DETACHABLE_CHILDREN = true;
    public static final String PREF_DEBUGGER_ASK_GEN = "PREF_DEBUGGER_ASK_GEN";
    public static final boolean DEFAULT_DEBUGGER_ASK_GEN = false;
    public static final String PREF_USER_REGISTERED = "PREF_USER_REGISTERED";
    public static final String PREF_SERVER_ID = "PREF_SERVER_ID";
    public static final String PREF_OUTPUT_PATH_SAME = "PREF_OUTPUT_PATH_SAME";
    public static final String PREF_OUTPUT_PATH_CUSTOM = "PREF_OUTPUT_PATH_CUSTOM";
    public static final String PREF_OUTPUT_PATH = "PREF_OUTPUT_PATH";
    public static final String PREF_START_SYMBOL = "PREF_START_SYMBOL";
    public static final String PREF_DEBUGGER_INPUT_TEXT = "PREF_DEBUGGER_INPUT_TEXT";
    public static final String PREF_DEBUGGER_EOL = "PREF_DEBUGGER_EOL";
    public static final String PREF_DEBUGGER_INPUT_FILE = "PREF_DEBUGGER_INPUT_FILE";
    public static final String PREF_DEBUGGER_INPUT_MODE = "PREF_DEBUGGER_INPUT_MODE";
    public static final String PREF_DEBUG_BREAK_ALL = "PREF_DEBUG_BREAK_ALL";
    public static final String PREF_DEBUG_BREAK_LOCATION = "PREF_DEBUG_BREAK_LOCATION";
    public static final String PREF_DEBUG_BREAK_CONSUME = "PREF_DEBUG_BREAK_CONSUME";
    public static final String PREF_DEBUG_BREAK_LT = "PREF_DEBUG_BREAK_LT";
    public static final String PREF_DEBUG_BREAK_EXCEPTION = "PREF_DEBUG_BREAK_EXCEPTION";
    public static final String PREF_PERSONAL_INFO = "PREF_OUTPUT_DEV_DATE";
    public static final String PREF_PRIVATE_MENU = "PREF_PRIVATE_MENU";
    public static final String PREF_PROJET_DOCUMENT = "PREF_PROJET_DOCUMENT";
    public static final String DEFAULT_OUTPUT_PATH;

    public static void addSyntax(String string, Color color, boolean bl, boolean bl2) {
        AWPrefs.color.put(string, color);
        bold.put(string, bl);
        italic.put(string, bl2);
    }

    public static String getSyntaxColorKey(String string) {
        return string + "_COLOR";
    }

    public static String getSyntaxBoldKey(String string) {
        return string + "_BOLD";
    }

    public static String getSyntaxItalicKey(String string) {
        return string + "_ITALIC";
    }

    public static Color getSyntaxDefaultColor(String string) {
        return color.get(string);
    }

    public static boolean getSyntaxDefaultBold(String string) {
        return bold.get(string);
    }

    public static boolean getSyntaxDefaultItalic(String string) {
        return italic.get(string);
    }

    public static Color getSyntaxColor(String string) {
        return AWPrefs.getPreferences().getColor(AWPrefs.getSyntaxColorKey(string), AWPrefs.getSyntaxDefaultColor(string));
    }

    public static boolean getSyntaxBold(String string) {
        return AWPrefs.getPreferences().getBoolean(AWPrefs.getSyntaxBoldKey(string), AWPrefs.getSyntaxDefaultBold(string));
    }

    public static boolean getSyntaxItalic(String string) {
        return AWPrefs.getPreferences().getBoolean(AWPrefs.getSyntaxItalicKey(string), AWPrefs.getSyntaxDefaultItalic(string));
    }

    public static boolean getDebugVerbose() {
        return AWPrefs.getPreferences().getBoolean(PREF_DEBUG_VERBOSE, false);
    }

    public static boolean getDebugDontOptimizeNFA() {
        return AWPrefs.getPreferences().getBoolean(PREF_DEBUG_DONT_OPTIMIZE_NFA, false);
    }

    public static int getDebugDefaultLocalPort() {
        return AWPrefs.getPreferences().getInt(PREF_DEBUG_LOCALPORT, 49153);
    }

    public static int getDebugLaunchTimeout() {
        return AWPrefs.getPreferences().getInt(PREF_DEBUG_LAUNCHTIMEOUT, 5);
    }

    public static void setOutputPath(String string) {
        AWPrefs.getPreferences().setString(PREF_OUTPUT_PATH, string);
    }

    public static boolean getOutputPathSameAsDocument() {
        return AWPrefs.getPreferences().getBoolean(PREF_OUTPUT_PATH_SAME, false);
    }

    public static String getOutputPath() {
        return AWPrefs.getPreferences().getString(PREF_OUTPUT_PATH, DEFAULT_OUTPUT_PATH);
    }

    public static void setStartSymbol(String string) {
        AWPrefs.getPreferences().setString(PREF_START_SYMBOL, string);
    }

    public static String getStartSymbol() {
        return AWPrefs.getPreferences().getString(PREF_START_SYMBOL, "");
    }

    public static void setDebuggerInputText(String string) {
        AWPrefs.getPreferences().setString(PREF_DEBUGGER_INPUT_TEXT, string);
    }

    public static String getDebuggerInputText() {
        return AWPrefs.getPreferences().getString(PREF_DEBUGGER_INPUT_TEXT, "");
    }

    public static int getStartupAction() {
        return AWPrefs.getPreferences().getInt(PREF_STARTUP_ACTION, 1);
    }

    public static boolean getRestoreWindows() {
        return AWPrefs.getPreferences().getBoolean(PREF_RESTORE_WINDOWS, true);
    }

    public static boolean getAutoSaveEnabled() {
        return AWPrefs.getPreferences().getBoolean(PREF_AUTOSAVE_ENABLED, false);
    }

    public static int getAutoSaveDelay() {
        return AWPrefs.getPreferences().getInt(PREF_AUTOSAVE_DELAY, 5);
    }

    public static boolean getBackupFileEnabled() {
        return AWPrefs.getPreferences().getBoolean(PREF_BACKUP_FILE_ENABLED, false);
    }

    public static boolean getHighlightCursorEnabled() {
        return AWPrefs.getPreferences().getBoolean(PREF_HIGHLIGHTCURSORLINE, true);
    }

    public static int getEditorTabSize() {
        return AWPrefs.getPreferences().getInt(PREF_TAB_WIDTH, 8);
    }

    public static String getEditorFont() {
        return AWPrefs.getPreferences().getString(PREF_EDITOR_FONT, DEFAULT_EDITOR_FONT);
    }

    public static int getEditorFontSize() {
        return AWPrefs.getPreferences().getInt(PREF_EDITOR_FONT_SIZE, 12);
    }

    public static boolean getSmoothScrolling() {
        return AWPrefs.getPreferences().getBoolean(PREF_SMOOTH_SCROLLING, true);
    }

    public static boolean getFoldingEnabled() {
        return AWPrefs.getPreferences().getBoolean(PREF_EDITOR_FOLDING, true);
    }

    public static boolean getDisplayActionsAnchorsFolding() {
        return AWPrefs.getPreferences().getBoolean(PREF_ACTIONS_ANCHORS_FOLDING, true);
    }

    public static boolean autoIndentColonInRule() {
        return AWPrefs.getPreferences().getBoolean(PREF_AUTO_IDENT_COLON_RULE, true);
    }

    public static boolean getLineNumberEnabled() {
        return AWPrefs.getPreferences().getBoolean(PREF_LINE_NUMBER, false);
    }

    public static boolean isVStyleAutoCompletion() {
        return AWPrefs.getPreferences().getBoolean(PREF_VSTYLE_AUTOCOMPLETION, false);
    }

    public static int getParserDelay() {
        return AWPrefs.getPreferences().getInt(PREF_PARSER_DELAY, 250);
    }

    public static void setLookAndFeel(String string) {
        AWPrefs.getPreferences().setString(PREF_LOOK_AND_FEEL, string);
    }

    public static String getLookAndFeel() {
        return AWPrefs.getPreferences().getString(PREF_LOOK_AND_FEEL, null);
    }

    public static boolean getUseDesktopMode() {
        return AWPrefs.getPreferences().getBoolean(PREF_DESKTOP_MODE, DEFAULT_DESKTOP_MODE);
    }

    public static void setDOTToolPath(String string) {
        AWPrefs.getPreferences().setString(PREF_DOT_TOOL_PATH, string);
    }

    public static String getDOTToolPath() {
        return AWPrefs.getPreferences().getString(PREF_DOT_TOOL_PATH, DEFAULT_DOT_TOOL_PATH);
    }

    public static String[] getANTLR3Options() {
        String string = AWPrefs.getPreferences().getString(PREF_ANTLR3_OPTIONS, "");
        if (string != null && string.trim().length() > 0) {
            return string.split(" ");
        }
        return new String[0];
    }

    public static boolean getP4Enabled() {
        return AWPrefs.getPreferences().getBoolean(PREF_SCM_P4_ENABLED, false);
    }

    public static String getP4Port() {
        return AWPrefs.getPreferences().getString(PREF_SCM_P4_PORT, "");
    }

    public static String getP4User() {
        return AWPrefs.getPreferences().getString(PREF_SCM_P4_USER, "");
    }

    public static String getP4Password() {
        return AWPrefs.getPreferences().getString(PREF_SCM_P4_PASSWORD, "");
    }

    public static String getP4Client() {
        return AWPrefs.getPreferences().getString(PREF_SCM_P4_CLIENT, "");
    }

    public static String getP4ExecPath() {
        return AWPrefs.getPreferences().getString(PREF_SCM_P4_EXEC, "");
    }

    public static boolean getJavaCCustomPath() {
        return AWPrefs.getPreferences().getBoolean(PREF_JAVAC_CUSTOM_PATH, false);
    }

    public static void setJavaCPath(String string) {
        AWPrefs.getPreferences().setString(PREF_JAVAC_PATH, string);
    }

    public static String getJavaCPath() {
        return AWPrefs.getPreferences().getString(PREF_JAVAC_PATH, "");
    }

    public static void setJikesPath(String string) {
        AWPrefs.getPreferences().setString(PREF_JIKES_PATH, string);
    }

    public static String getJikesPath() {
        return AWPrefs.getPreferences().getString(PREF_JIKES_PATH, "");
    }

    public static void setCustomClassPath(String string) {
        AWPrefs.getPreferences().setString(PREF_CUSTOM_CLASS_PATH, string);
    }

    public static String getCustomClassPath() {
        return AWPrefs.getPreferences().getString(PREF_CUSTOM_CLASS_PATH, "");
    }

    public static String getCompiler() {
        return AWPrefs.getPreferences().getString(PREF_COMPILER, "javac");
    }

    public static boolean getUseSystemClassPath() {
        return AWPrefs.getPreferences().getBoolean(PREF_CLASSPATH_SYSTEM, true);
    }

    public static boolean getUseCustomClassPath() {
        return AWPrefs.getPreferences().getBoolean(PREF_CLASSPATH_CUSTOM, false);
    }

    public static int getUpdateType() {
        return AWPrefs.getPreferences().getInt(PREF_UPDATE_TYPE, 3);
    }

    public static void setUpdateNextDate(Calendar calendar) {
        AWPrefs.getPreferences().setObject(PREF_UPDATE_NEXT_DATE, calendar);
    }

    public static Calendar getUpdateNextDate() {
        return (Calendar)AWPrefs.getPreferences().getObject(PREF_UPDATE_NEXT_DATE, null);
    }

    public static void setDownloadPath(String string) {
        AWPrefs.getPreferences().setString(PREF_DOWNLOAD_PATH, string);
    }

    public static String getDownloadPath() {
        return AWPrefs.getPreferences().getString(PREF_DOWNLOAD_PATH, DEFAULT_DOWNLOAD_PATH);
    }

    public static void setUserRegistered(boolean bl) {
        AWPrefs.getPreferences().setBoolean(PREF_USER_REGISTERED, bl);
    }

    public static boolean isUserRegistered() {
        return AWPrefs.getPreferences().getBoolean(PREF_USER_REGISTERED, false);
    }

    public static void removeUserRegistration() {
        AWPrefs.getPreferences().remove(PREF_USER_REGISTERED);
    }

    public static void setServerID(String string) {
        AWPrefs.getPreferences().setString(PREF_SERVER_ID, string);
    }

    public static String getServerID() {
        return AWPrefs.getPreferences().getString(PREF_SERVER_ID, null);
    }

    public static void setPersonalInfo(Map<String, Object> map) {
        AWPrefs.getPreferences().setObject(PREF_PERSONAL_INFO, map);
    }

    public static Map getPersonalInfo() {
        return (Map)AWPrefs.getPreferences().getObject(PREF_PERSONAL_INFO, null);
    }

    public static boolean getPrivateMenu() {
        return AWPrefs.getPreferences().getBoolean(PREF_PRIVATE_MENU, false);
    }

    public static Color getNonConsumedTokenColor() {
        return AWPrefs.getPreferences().getColor(PREF_NONCONSUMED_TOKEN_COLOR, DEFAULT_NONCONSUMED_TOKEN_COLOR);
    }

    public static Color getConsumedTokenColor() {
        return AWPrefs.getPreferences().getColor(PREF_CONSUMED_TOKEN_COLOR, DEFAULT_CONSUMED_TOKEN_COLOR);
    }

    public static Color getHiddenTokenColor() {
        return AWPrefs.getPreferences().getColor(PREF_HIDDEN_TOKEN_COLOR, DEFAULT_HIDDEN_TOKEN_COLOR);
    }

    public static Color getDeadTokenColor() {
        return AWPrefs.getPreferences().getColor(PREF_DEAD_TOKEN_COLOR, DEFAULT_DEAD_TOKEN_COLOR);
    }

    public static Color getLookaheadTokenColor() {
        return AWPrefs.getPreferences().getColor(PREF_LOOKAHEAD_TOKEN_COLOR, DEFAULT_LOOKAHEAD_TOKEN_COLOR);
    }

    public static boolean getDetachableChildren() {
        return AWPrefs.getPreferences().getBoolean(PREF_DETACHABLE_CHILDREN, true);
    }

    public static boolean getDebuggerAskGen() {
        return AWPrefs.getPreferences().getBoolean(PREF_DEBUGGER_ASK_GEN, false);
    }

    public static boolean getEnableProjectDocument() {
        return AWPrefs.getPreferences().getBoolean(PREF_PROJET_DOCUMENT, false);
    }

    public static XJPreferences getPreferences() {
        return XJApplication.shared().getPreferences();
    }

    public static void setLastSavedDocument(String string) {
        if (string != null) {
            AWPrefs.getPreferences().setString(PREF_LAST_SAVED_DOCUMENT, string);
        }
    }

    public static String getLastSavedDocument() {
        return AWPrefs.getPreferences().getString(PREF_LAST_SAVED_DOCUMENT, null);
    }

    public static void setAllOpenedDocuments(List<String> list) {
        if (list != null) {
            AWPrefs.getPreferences().setObject(PREF_ALL_OPENED_DOCUMENTS, list);
        }
    }

    public static List<String> getAllOpenedDocuments() {
        return (List)AWPrefs.getPreferences().getObject(PREF_ALL_OPENED_DOCUMENTS, null);
    }

    public static void setDebuggerEOL(int n) {
        AWPrefs.getPreferences().setInt(PREF_DEBUGGER_EOL, n);
    }

    public static int getDebuggerEOL() {
        return AWPrefs.getPreferences().getInt(PREF_DEBUGGER_EOL, 0);
    }

    public static void setDebuggerInputMode(int n) {
        AWPrefs.getPreferences().setInt(PREF_DEBUGGER_INPUT_MODE, n);
    }

    public static int getDebuggerInputMode() {
        return AWPrefs.getPreferences().getInt(PREF_DEBUGGER_INPUT_MODE, 0);
    }

    public static void setDebuggerInputFile(String string) {
        AWPrefs.getPreferences().setString(PREF_DEBUGGER_INPUT_FILE, string);
    }

    public static String getDebuggerInputFile() {
        return AWPrefs.getPreferences().getString(PREF_DEBUGGER_INPUT_FILE, "");
    }

    static {
        color = new HashMap<String, Color>();
        bold = new HashMap<String, Boolean>();
        italic = new HashMap<String, Boolean>();
        AWPrefs.addSyntax(PREF_SYNTAX_PARSER, new Color(0.42f, 0.0f, 0.42f), true, false);
        AWPrefs.addSyntax(PREF_SYNTAX_LEXER, new Color(0.0f, 0.0f, 0.5f), true, false);
        AWPrefs.addSyntax(PREF_SYNTAX_LABEL, Color.black, false, true);
        AWPrefs.addSyntax(PREF_SYNTAX_REFS, new Color(0, 153, 153), true, false);
        AWPrefs.addSyntax(PREF_SYNTAX_COMMENT, Color.lightGray, false, true);
        AWPrefs.addSyntax(PREF_SYNTAX_STRING, new Color(0.0f, 0.5f, 0.0f), true, false);
        AWPrefs.addSyntax(PREF_SYNTAX_KEYWORD, new Color(0.0f, 0.0f, 0.5f), true, false);
        DEFAULT_DOWNLOAD_PATH = System.getProperty("user.home");
        DEFAULT_NONCONSUMED_TOKEN_COLOR = Color.lightGray;
        DEFAULT_CONSUMED_TOKEN_COLOR = Color.black;
        DEFAULT_HIDDEN_TOKEN_COLOR = Color.lightGray;
        DEFAULT_DEAD_TOKEN_COLOR = Color.red;
        DEFAULT_LOOKAHEAD_TOKEN_COLOR = Color.blue;
        DEFAULT_EDITOR_FONT = "Courier New";
        if (XJSystem.isMacOS()) {
            DEFAULT_OUTPUT_PATH = "/tmp/antlrworks/";
            DEFAULT_DOT_TOOL_PATH = "/Applications/Graphviz.app/Contents/MacOS/dot";
            if (Font.getFont("Monospaced") != null) {
                DEFAULT_EDITOR_FONT = "Monospaced";
            }
        } else if (XJSystem.isWindows()) {
            DEFAULT_OUTPUT_PATH = "\\tmp\\antlrworks\\";
            DEFAULT_DOT_TOOL_PATH = "";
            if (Font.getFont("Tahoma") != null) {
                DEFAULT_EDITOR_FONT = "Tahoma";
            }
        } else if (XJSystem.isLinux()) {
            DEFAULT_OUTPUT_PATH = "/tmp/antlrworks/";
            DEFAULT_DOT_TOOL_PATH = "/usr/bin/dot";
            if (Font.getFont("Monospaced") != null) {
                DEFAULT_EDITOR_FONT = "Monospaced";
            }
        } else {
            DEFAULT_OUTPUT_PATH = "/tmp/antlrworks/";
            DEFAULT_DOT_TOOL_PATH = "/usr/bin/dot";
            if (Font.getFont("Courier") != null) {
                DEFAULT_EDITOR_FONT = "Courier";
            }
        }
        DEFAULT_DESKTOP_MODE = !XJSystem.isMacOS();
    }
}

