/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.navigation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.works.utils.OverlayObject;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;

public class GoToRule
extends OverlayObject {
    public JTextField ruleNameField;
    public JList matchingRuleList;
    public DefaultListModel matchingRuleListModel;
    public JScrollPane matchingRuleScrollPane;
    public CEditorGrammar editor;
    public static final int VISIBLE_MATCHING_RULES = 15;

    public GoToRule(CEditorGrammar cEditorGrammar, XJFrameInterface xJFrameInterface, JComponent jComponent) {
        super(xJFrameInterface, jComponent);
        this.editor = cEditorGrammar;
    }

    public void close() {
        super.close();
        this.editor = null;
    }

    public JComponent overlayCreateInterface() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Go To Rule:"), "North");
        this.ruleNameField = new JTextField();
        this.ruleNameField.addKeyListener(new TextFieldKeyAdapter());
        this.ruleNameField.getDocument().addDocumentListener(new TextFieldDocumentListener());
        this.matchingRuleListModel = new DefaultListModel();
        this.matchingRuleList = new JList(this.matchingRuleListModel);
        this.matchingRuleList.setSelectionMode(0);
        this.matchingRuleList.setBackground(new Color(235, 244, 254));
        this.matchingRuleList.setPrototypeCellValue("This is a rule name g");
        this.matchingRuleList.addKeyListener(new ListKeyAdapter());
        this.matchingRuleList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    GoToRule.this.goToRule();
                    GoToRule.this.hide();
                }
            }
        });
        this.matchingRuleScrollPane = new JScrollPane(this.matchingRuleList, 20, 31);
        this.matchingRuleScrollPane.setBorder(BorderFactory.createBevelBorder(0));
        this.matchingRuleScrollPane.setVisible(false);
        this.parentFrame.getLayeredPane().add((Component)this.matchingRuleScrollPane, JLayeredPane.MODAL_LAYER);
        jPanel.add((Component)this.ruleNameField, "South");
        return jPanel;
    }

    public boolean overlayWillDisplay() {
        this.ruleNameField.setText("");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GoToRule.this.ruleNameField.requestFocusInWindow();
            }
        });
        this.updateAutoCompletionList();
        return true;
    }

    public void hide() {
        super.hide();
        this.matchingRuleScrollPane.setVisible(false);
    }

    public void resize() {
        super.resize();
        this.resizeMatchingRules();
    }

    public void resizeMatchingRules() {
        Rectangle rectangle = this.content.getBounds();
        int n = this.matchingRuleList.getFixedCellHeight();
        int n2 = this.matchingRuleListModel.size();
        if (n2 > 0) {
            n = n * Math.min(15, n2) + 5;
            this.matchingRuleScrollPane.setBounds(rectangle.x, rectangle.y + rectangle.height, rectangle.width, n);
        }
    }

    public void updateAutoCompletionList() {
        this.matchingRuleListModel.removeAllElements();
        List<String> list = this.editor.rules.getRulesStartingWith(this.ruleNameField.getText().toLowerCase());
        if (list.isEmpty()) {
            this.matchingRuleScrollPane.setVisible(false);
            this.ruleNameField.setForeground(Color.red);
            return;
        }
        this.ruleNameField.setForeground(Color.black);
        for (String string : list) {
            this.matchingRuleListModel.addElement(string);
        }
        this.matchingRuleList.setSelectedIndex(0);
        this.resizeMatchingRules();
        this.matchingRuleScrollPane.setVisible(true);
    }

    public void selectNextListElement(int n) {
        int n2 = this.matchingRuleList.getSelectedIndex();
        n2 += n;
        n2 = Math.min(Math.max(0, n2), this.matchingRuleListModel.size() - 1);
        this.matchingRuleList.setSelectedIndex(n2);
        this.matchingRuleList.scrollRectToVisible(this.matchingRuleList.getCellBounds(n2, n2));
    }

    public void goToRule() {
        ElementRule elementRule;
        if (this.matchingRuleListModel.isEmpty()) {
            return;
        }
        int n = this.matchingRuleList.getSelectedIndex();
        if (n >= 0 && (elementRule = this.editor.rules.selectRuleNameInTree((String)this.matchingRuleListModel.get(n))) != null) {
            this.editor.goToHistoryRememberCurrentPosition();
            this.editor.rules.goToRule(elementRule);
        }
    }

    public class TextFieldDocumentListener
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            GoToRule.this.updateAutoCompletionList();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            GoToRule.this.updateAutoCompletionList();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            GoToRule.this.updateAutoCompletionList();
        }
    }

    public class TextFieldKeyAdapter
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            if (!GoToRule.this.content.isVisible()) {
                return;
            }
            switch (keyEvent.getKeyCode()) {
                case 27: {
                    GoToRule.this.hide();
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    GoToRule.this.goToRule();
                    GoToRule.this.hide();
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    GoToRule.this.selectNextListElement(-1);
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    GoToRule.this.selectNextListElement(1);
                    keyEvent.consume();
                }
            }
        }
    }

    public class ListKeyAdapter
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            if (!GoToRule.this.content.isVisible()) {
                return;
            }
            switch (keyEvent.getKeyCode()) {
                case 27: {
                    GoToRule.this.hide();
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    GoToRule.this.goToRule();
                    GoToRule.this.hide();
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    GoToRule.this.selectNextListElement(-1);
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    GoToRule.this.selectNextListElement(1);
                    keyEvent.consume();
                }
            }
        }
    }
}

