/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.menu;

import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.menu.MenuAbstract;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.scm.SCM;
import org.antlr.works.scm.SCMDelegate;
import org.antlr.works.scm.p4.P4;
import org.antlr.works.scm.p4.P4SubmitDialog;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgress;

public class MenuSCM
extends MenuAbstract
implements SCMDelegate {
    protected XJDialogProgress progress;
    protected SCM scm;
    protected boolean silent;

    public MenuSCM(CEditorGrammar cEditorGrammar) {
        super(cEditorGrammar);
    }

    public void awake() {
        this.scm = new P4(this, this.editor.console);
    }

    public void setSilent(boolean bl) {
        this.silent = bl;
    }

    public void queryFileStatus() {
        if (this.getFilePath() != null && AWPrefs.getP4Enabled()) {
            this.scm.queryFileStatus(this.getFilePath());
        }
    }

    public boolean isFileWritable() {
        return this.scm.isFileWritable();
    }

    public void editFile() {
        StatisticsAW.shared().recordEvent(100);
        if (this.check()) {
            this.showProgress("Open for Edit");
            this.scm.editFile(this.getFilePath());
        }
    }

    public void addFile() {
        StatisticsAW.shared().recordEvent(101);
        if (this.check()) {
            this.showProgress("Mark for Add");
            this.scm.addFile(this.getFilePath());
        }
    }

    public void deleteFile() {
        StatisticsAW.shared().recordEvent(103);
        if (this.check()) {
            this.showProgress("Mark for Delete");
            this.scm.deleteFile(this.getFilePath());
        }
    }

    public void revertFile() {
        StatisticsAW.shared().recordEvent(102);
        if (this.check() && XJAlert.displayAlertYESNO(this.editor.getWindowContainer(), "Revert", "Are you sure you want to discard your changes to the file ?") == 0) {
            this.showProgress("Revert");
            this.scm.revertFile(this.getFilePath());
        }
    }

    public void submitFile() {
        P4SubmitDialog p4SubmitDialog;
        StatisticsAW.shared().recordEvent(104);
        if (this.check() && (p4SubmitDialog = new P4SubmitDialog(this.editor.getWindowContainer())).runModal() == 1) {
            this.showProgress("Submit");
            this.scm.submitFile(this.getFilePath(), p4SubmitDialog.getDescription(), p4SubmitDialog.getRemainOpen());
        }
    }

    public void sync() {
        StatisticsAW.shared().recordEvent(105);
        if (this.check()) {
            this.showProgress("Sync");
            this.scm.sync();
        }
    }

    protected boolean check() {
        if (this.getFilePath() == null) {
            XJAlert.display(this.editor.getWindowContainer(), "SCM Error", "The file must be saved to the disk before any SCM command can be executed.");
            return false;
        }
        return true;
    }

    protected void displayErrors() {
        if (this.scm.hasErrors()) {
            XJAlert.display(this.editor.getWindowContainer(), "SCM Error", this.scm.getErrorsDescription());
            this.scm.resetErrors();
        }
    }

    protected void showProgress(String string) {
        if (this.progress == null) {
            this.progress = new XJDialogProgress(this.editor.getWindowContainer());
        }
        this.progress.setInfo(string);
        this.progress.setCancellable(false);
        this.progress.setIndeterminate(true);
        this.progress.display();
        this.setSilent(false);
    }

    protected void hideProgress() {
        this.progress.close();
    }

    protected String getFilePath() {
        return this.editor.getFilePath();
    }

    public void scmCommandsDidComplete() {
        if (!this.silent) {
            this.hideProgress();
            this.displayErrors();
        }
        this.editor.scmCommandsDidComplete();
    }

    public void scmFileStatusDidChange(String string) {
        this.editor.updateSCMStatus(string);
    }

    public void scmLog(String string) {
        this.editor.console.println(string);
    }
}

