/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.menu;

import java.awt.Point;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.undo.AbstractUndoableEdit;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.grammar.RefactorEngine;
import org.antlr.works.grammar.RefactorMutator;
import org.antlr.works.menu.MenuAbstract;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.syntax.element.ElementReference;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.works.utils.Utils;
import org.antlr.xjlib.appkit.undo.XJUndo;
import org.antlr.xjlib.appkit.utils.XJAlert;

public class MenuRefactor
extends MenuAbstract {
    private RefactorEngine engine = new RefactorEngine();
    private EditorTextMutator mutator;

    public MenuRefactor(CEditorGrammar cEditorGrammar) {
        super(cEditorGrammar);
    }

    public void rename() {
        StatisticsAW.shared().recordEvent(60);
        ATEToken aTEToken = this.editor.getCurrentToken();
        if (aTEToken == null) {
            return;
        }
        String string = (String)JOptionPane.showInputDialog(this.editor.getJavaContainer(), "Rename '" + aTEToken.getAttribute() + "' and its usages to:", "Rename", 3, null, null, aTEToken.getAttribute());
        if (string != null && !string.equals(aTEToken.getAttribute())) {
            this.beginRefactor("Rename");
            this.engine.renameToken(aTEToken, string);
            this.endRefactor();
        }
    }

    public boolean canReplaceLiteralWithTokenLabel() {
        ATEToken aTEToken = this.editor.getCurrentToken();
        return aTEToken != null && (aTEToken.type == 1 || aTEToken.type == 2);
    }

    public void replaceLiteralWithTokenLabel() {
        StatisticsAW.shared().recordEvent(61);
        ATEToken aTEToken = this.editor.getCurrentToken();
        if (aTEToken == null) {
            return;
        }
        if (aTEToken.type != 1 && aTEToken.type != 2) {
            XJAlert.display(this.editor.getJavaContainer(), "Cannot Replace Literal With Token Label", "The current token is not a literal.");
            return;
        }
        this.editor.selectTextRange(aTEToken.getStartIndex(), aTEToken.getEndIndex());
        String string = (String)JOptionPane.showInputDialog(this.editor.getJavaContainer(), "Replace Literal '" + aTEToken.getAttribute() + "' with token label:", "Replace Literal With Token Label", 3, null, null, "");
        if (string != null && !string.equals(aTEToken.getAttribute())) {
            this.beginRefactor("Replace Literal With Token Label");
            this.replaceLiteralTokenWithTokenLabel(aTEToken, string);
            this.endRefactor();
        }
    }

    public void replaceLiteralTokenWithTokenLabel(ATEToken aTEToken, String string) {
        this.mutator.insert(this.editor.getText().length(), "\n\n" + string + "\n\t:\t" + aTEToken.getAttribute() + "\n\t;");
        List<ATEToken> list = this.editor.getTokens();
        String string2 = aTEToken.getAttribute();
        for (int i = list.size() - 1; i > 0; --i) {
            ATEToken aTEToken2 = list.get(i);
            if (aTEToken2.type != 1 && aTEToken2.type != 2 || !aTEToken2.getAttribute().equals(string2)) continue;
            this.mutator.replace(aTEToken2.getStartIndex(), aTEToken2.getEndIndex(), string);
        }
    }

    public void convertLiteralsToSingleQuote() {
        StatisticsAW.shared().recordEvent(66);
        this.beginRefactor("Convert Literals To Single Quote Literals");
        this.convertLiteralsToSpecifiedQuote(2, '\'', '\"');
        this.endRefactor();
    }

    public void convertLiteralsToDoubleQuote() {
        StatisticsAW.shared().recordEvent(67);
        this.beginRefactor("Convert Literals To Double Quote Literals");
        this.convertLiteralsToSpecifiedQuote(1, '\"', '\'');
        this.endRefactor();
    }

    public void convertLiteralsToCStyleQuote() {
        StatisticsAW.shared().recordEvent(68);
        this.beginRefactor("Convert Literals To C-style Quote Literals");
        List<ATEToken> list = this.editor.getTokens();
        for (int i = list.size() - 1; i > 0; --i) {
            ATEToken aTEToken = list.get(i);
            String string = null;
            if (aTEToken.type != 1 && aTEToken.type != 2) continue;
            String string2 = aTEToken.getAttribute();
            String string3 = string2.substring(1, string2.length() - 1);
            if (aTEToken.type == 1) {
                if (string3.length() == 1 || string3.length() == 2 && string3.charAt(0) == '\\') continue;
                if (string3.indexOf(34) != -1 || string3.indexOf(39) != -1) {
                    string3 = this.escapeStringQuote(string3, '\"', '\'');
                }
                string = '\"' + string3 + '\"';
            } else if (aTEToken.type == 2) {
                if (string3.length() > 1 && string3.charAt(0) != '\\') continue;
                if (string3.indexOf(39) != -1 || string3.indexOf(34) != -1) {
                    string3 = this.escapeStringQuote(string3, '\'', '\"');
                }
                string = '\'' + string3 + '\'';
            }
            this.mutator.replace(aTEToken.getStartIndex(), aTEToken.getEndIndex(), string);
        }
        this.endRefactor();
    }

    protected void convertLiteralsToSpecifiedQuote(int n, char c, char c2) {
        List<ATEToken> list = this.editor.getTokens();
        for (int i = list.size() - 1; i > 0; --i) {
            ATEToken aTEToken = list.get(i);
            if (aTEToken.type != n || RefactorEngine.ignoreScopeForDoubleQuoteLiteral(aTEToken.scope)) continue;
            String string = aTEToken.getAttribute();
            String string2 = string.substring(1, string.length() - 1);
            if (string2.indexOf(c) != -1 || string2.indexOf(c2) != -1) {
                string2 = this.escapeStringQuote(string2, c, c2);
            }
            this.mutator.replace(aTEToken.getStartIndex(), aTEToken.getEndIndex(), c + string2 + c);
        }
    }

    protected String escapeStringQuote(String string, char c, char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c3 = string.charAt(i);
            if (c3 == '\\') {
                char c4;
                if ((c4 = string.charAt(++i)) == c2) {
                    stringBuffer.append(c4);
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(c4);
                continue;
            }
            if (c3 == c) {
                stringBuffer.append('\\');
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    public void removeLeftRecursion() {
        StatisticsAW.shared().recordEvent(62);
        ElementRule elementRule = this.editor.rules.getEnclosingRuleAtPosition(this.editor.getCaretPosition());
        if (elementRule == null) {
            XJAlert.display(this.editor.getWindowContainer(), "Remove Left Recursion", "There is no rule at cursor position.");
            return;
        }
        if (!elementRule.hasLeftRecursion()) {
            XJAlert.display(this.editor.getWindowContainer(), "Remove Left Recursion", "The rule doesn't have a left recursion.");
            return;
        }
        this.beginRefactor("Remove Left Recursion");
        String string = elementRule.getTextRuleAfterRemovingLeftRecursion();
        this.mutator.replace(elementRule.getInternalTokensStartIndex(), elementRule.getInternalTokensEndIndex(), string);
        this.endRefactor();
    }

    public void removeAllLeftRecursion() {
        StatisticsAW.shared().recordEvent(63);
        this.beginRefactor("Remove All Left Recursion");
        List<ElementRule> list = this.editor.rules.getRules();
        for (int i = list.size() - 1; i >= 0; --i) {
            ElementRule elementRule = list.get(i);
            if (!elementRule.hasLeftRecursion()) continue;
            String string = elementRule.getTextRuleAfterRemovingLeftRecursion();
            this.mutator.replace(elementRule.getInternalTokensStartIndex(), elementRule.getInternalTokensEndIndex(), string);
        }
        this.endRefactor();
    }

    public boolean canExtractRule() {
        int n = this.editor.getSelectionLeftIndexOnTokenBoundary();
        int n2 = this.editor.getSelectionRightIndexOnTokenBoundary();
        return n != -1 && n2 != -1;
    }

    public void extractRule() {
        StatisticsAW.shared().recordEvent(64);
        if (!this.canExtractRule()) {
            XJAlert.display(this.editor.getWindowContainer(), "Extract Rule", "At least one token must be selected.");
            return;
        }
        int n = this.editor.getSelectionLeftIndexOnTokenBoundary();
        int n2 = this.editor.getSelectionRightIndexOnTokenBoundary();
        this.editor.selectTextRange(n, n2);
        String string = (String)JOptionPane.showInputDialog(this.editor.getJavaContainer(), "Rule name:", "Extract Rule", 3, null, null, "");
        if (string != null && string.length() > 0) {
            this.beginRefactor("Extract Rule");
            boolean bl = ATEToken.isLexerName(string);
            int n3 = this.insertionIndexForRule(bl);
            String string2 = this.editor.getText().substring(n, n2);
            if (n3 > this.editor.getCaretPosition()) {
                this.insertRuleAtIndex(this.createRule(string, string2), n3);
                this.mutator.replace(n, n2, string);
            } else {
                this.mutator.replace(n, n2, string);
                this.insertRuleAtIndex(this.createRule(string, string2), n3);
            }
            this.endRefactor();
        }
    }

    public boolean canInlineRule() {
        return this.editor.rules.getEnclosingRuleAtPosition(this.editor.getCaretPosition()) != null;
    }

    public void inlineRule() {
        StatisticsAW.shared().recordEvent(65);
        ElementRule elementRule = this.editor.rules.getEnclosingRuleAtPosition(this.editor.getCaretPosition());
        if (elementRule == null) {
            XJAlert.display(this.editor.getWindowContainer(), "Inline Rule", "There is no rule at cursor position.");
            return;
        }
        this.inlineRule(elementRule);
    }

    protected void inlineRule(ElementRule elementRule) {
        String string = this.editor.getText();
        this.beginRefactor("Inline");
        String string2 = elementRule.name;
        String string3 = Utils.trimString(string.substring(elementRule.colon.getEndIndex(), elementRule.end.getStartIndex()));
        List<ElementRule> list = this.editor.rules.getRules();
        if (elementRule.end.index - elementRule.colon.index > 2) {
            string3 = "(" + string3 + ")";
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            ElementRule elementRule2 = list.get(i);
            if (elementRule2 == elementRule) {
                this.mutator.delete(elementRule.getStartIndex(), elementRule.getEndIndex() + 1);
                continue;
            }
            List<ElementReference> list2 = elementRule2.getReferences();
            if (list2 == null) continue;
            for (int j = list2.size() - 1; j >= 0; --j) {
                ElementReference elementReference = list2.get(j);
                if (!elementReference.token.getAttribute().equals(string2)) continue;
                this.mutator.replace(elementReference.token.getStartIndex(), elementReference.token.getEndIndex(), string3);
            }
        }
        this.endRefactor();
    }

    public void createRuleAtIndex(boolean bl, String string, String string2) {
        this.beginRefactor("Create Rule");
        int n = this.insertionIndexForRule(bl);
        this.insertRuleAtIndex(this.createRule(string, string2), n);
        this.setCaretPosition(n);
        this.endRefactor();
    }

    public void deleteRuleAtIndex(int n) {
        ElementRule elementRule = this.editor.rules.getEnclosingRuleAtPosition(n);
        if (elementRule != null) {
            this.editor.replaceText(elementRule.getStartIndex(), elementRule.getEndIndex(), "");
        }
    }

    public int insertionIndexForRule(boolean bl) {
        Point point = this.editor.getTextEditor().getLineTextPositionsAtTextPosition(this.getCaretPosition());
        int n = point.y;
        ElementRule elementRule = this.editor.rules.getEnclosingRuleAtPosition(this.getCaretPosition());
        if (elementRule != null) {
            if (elementRule.lexer) {
                if (bl) {
                    n = elementRule.getEndIndex();
                } else {
                    ElementRule elementRule2 = this.editor.rules.getLastParserRule();
                    if (elementRule2 != null) {
                        n = elementRule2.getEndIndex();
                    }
                }
            } else if (bl) {
                ElementRule elementRule3 = this.editor.rules.getLastLexerRule();
                if (elementRule3 != null) {
                    n = elementRule3.getEndIndex();
                } else {
                    elementRule3 = this.editor.rules.getLastRule();
                    if (elementRule3 != null) {
                        n = elementRule3.getEndIndex();
                    }
                }
            } else {
                n = elementRule.getEndIndex();
            }
        }
        return n;
    }

    public String createRule(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append(string);
        if (string.length() >= AWPrefs.getEditorTabSize()) {
            stringBuffer.append("\n");
        }
        stringBuffer.append("\t:");
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append("\t");
            stringBuffer.append(string2);
        }
        stringBuffer.append("\n\t;");
        return stringBuffer.toString();
    }

    protected void insertRuleAtIndex(String string, int n) {
        this.mutator.insertAtLinesBoundary(n, string);
    }

    protected void beginRefactor(String string) {
        this.editor.beginGroupChange(string);
        this.mutator = new EditorTextMutator();
        this.engine.setMutator(this.mutator);
        this.engine.setTokens(this.editor.getTokens());
    }

    protected void endRefactor() {
        this.mutator.apply();
        this.mutator = null;
        this.editor.endGroupChange();
    }

    protected void refactorReplaceEditorText(String string) {
        int n = this.editor.getCaretPosition();
        this.editor.disableTextPaneUndo();
        this.editor.setText(string);
        this.editor.enableTextPaneUndo();
        this.editor.getTextEditor().setCaretPosition(Math.min(n, string.length()), false, false);
    }

    protected class UndoableRefactoringEdit
    extends AbstractUndoableEdit {
        public String oldContent;
        public String newContent;

        public UndoableRefactoringEdit(String string, String string2) {
            this.oldContent = string;
            this.newContent = string2;
        }

        public void redo() {
            super.redo();
            MenuRefactor.this.refactorReplaceEditorText(this.newContent);
        }

        public void undo() {
            super.undo();
            MenuRefactor.this.refactorReplaceEditorText(this.oldContent);
        }
    }

    public class EditorTextMutator
    implements RefactorMutator {
        public StringBuffer mutableText;

        public EditorTextMutator() {
            this.mutableText = new StringBuffer(MenuRefactor.this.editor.getText());
        }

        public void replace(int n, int n2, String string) {
            this.mutableText.replace(n, n2, string);
        }

        public void insert(int n, String string) {
            this.mutableText.insert(n, string);
        }

        public void insertAtLinesBoundary(int n, String string) {
            if (this.mutableText.charAt(n) != '\n' || this.mutableText.charAt(n - 1) != '\n') {
                this.mutableText.insert(n++, '\n');
            }
            this.mutableText.insert(n, string);
            int n2 = n + string.length();
            if (this.mutableText.charAt(n2) != '\n' || n2 + 1 >= this.mutableText.length() || this.mutableText.charAt(n2 + 1) != '\n') {
                this.mutableText.insert(n2, '\n');
            }
        }

        public void delete(int n, int n2) {
            this.mutableText.delete(n, n2);
        }

        public void apply() {
            String string = this.mutableText.toString();
            String string2 = MenuRefactor.this.editor.getText();
            MenuRefactor.this.refactorReplaceEditorText(string);
            XJUndo xJUndo = MenuRefactor.this.editor.getXJFrame().getUndo(MenuRefactor.this.getTextPane());
            xJUndo.addEditEvent(new UndoableRefactoringEdit(string2, string));
        }
    }
}

