/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.menu;

import java.util.List;
import javax.swing.JOptionPane;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.grammar.CheckGrammar;
import org.antlr.works.grammar.CheckGrammarDelegate;
import org.antlr.works.grammar.EngineGrammarResult;
import org.antlr.works.grammar.RulesDependency;
import org.antlr.works.grammar.TokensDFA;
import org.antlr.works.grammar.decisiondfa.DecisionDFA;
import org.antlr.works.menu.MenuAbstract;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.syntax.element.ElementGroup;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgressDelegate;

public class MenuGrammar
extends MenuAbstract
implements CheckGrammarDelegate,
XJDialogProgressDelegate {
    protected CheckGrammar checkGrammar;
    protected boolean checkingGrammar;

    public MenuGrammar(CEditorGrammar cEditorGrammar) {
        super(cEditorGrammar);
        this.checkGrammar = new CheckGrammar(cEditorGrammar, this);
    }

    public void close() {
        super.close();
        this.checkGrammar.close();
    }

    public void showTokensSD() {
        StatisticsAW.shared().recordEvent(40);
        this.editor.visual.setRule(new ElementRule("Tokens"), true);
        this.editor.makeBottomComponentVisible();
    }

    public void showTokensDFA() {
        StatisticsAW.shared().recordEvent(41);
        TokensDFA tokensDFA = new TokensDFA(this.editor);
        tokensDFA.launch();
    }

    public void showDecisionDFA() {
        DecisionDFA decisionDFA = new DecisionDFA(this.editor);
        decisionDFA.launch();
    }

    public void highlightDecisionDFA() {
        StatisticsAW.shared().recordEvent(42);
        try {
            if (this.editor.decisionDFAEngine.getDecisionDFACount() == 0) {
                this.editor.decisionDFAEngine.discoverAllDecisions();
            } else {
                this.editor.decisionDFAEngine.reset();
            }
            this.editor.decisionDFAEngine.refresh();
            this.editor.decisionDFAEngine.refreshMenu();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            XJAlert.display(this.editor.getWindowContainer(), "Error", "Cannot show the DFA:\n" + exception.toString());
        }
    }

    public void showDependency() {
        StatisticsAW.shared().recordEvent(44);
        RulesDependency rulesDependency = new RulesDependency(this.editor);
        rulesDependency.launch();
    }

    public void insertRuleFromTemplate() {
        StatisticsAW.shared().recordEvent(45);
        this.editor.ruleTemplates.display();
    }

    public void group() {
        List<ElementRule> list;
        StatisticsAW.shared().recordEvent(45);
        String string = (String)JOptionPane.showInputDialog(this.editor.getWindowContainer(), "Group Name:", "Group", 3, null, null, "Group");
        if (string != null && string.length() > 0 && !(list = this.editor.rules.getSelectedRules()).isEmpty()) {
            this.editor.beginGroupChange("Group");
            ElementRule elementRule = list.get(0);
            ElementRule elementRule2 = list.get(list.size() - 1);
            int n = elementRule2.getEndIndex();
            this.editor.textEditor.insertText(n + 1, "\n// $>\n");
            int n2 = elementRule.getStartIndex();
            this.editor.textEditor.insertText(n2 - 1, "\n// $<" + string + "\n");
            this.editor.endGroupChange();
        }
    }

    public void ungroup() {
        ATEToken aTEToken;
        StatisticsAW.shared().recordEvent(46);
        ElementGroup elementGroup = this.editor.rules.getSelectedGroup();
        if (elementGroup == null && (elementGroup = this.editor.rules.findOpenGroupClosestToLocation(this.editor.getTextPane().getSelectionStart())) == null) {
            XJAlert.display(this.editor.getWindowContainer(), "Ungroup", "Cannot ungroup because no enclosing group has been found.");
            return;
        }
        ElementGroup elementGroup2 = this.editor.rules.findClosingGroupForGroup(elementGroup);
        this.editor.beginGroupChange("Ungroup");
        if (elementGroup2 != null) {
            aTEToken = elementGroup2.token;
            this.editor.replaceText(aTEToken.getStartIndex() - 1, aTEToken.getEndIndex(), "");
        }
        aTEToken = elementGroup.token;
        this.editor.replaceText(aTEToken.getStartIndex() - 1, aTEToken.getEndIndex(), "");
        this.editor.endGroupChange();
    }

    public void ignore() {
        this.editor.rules.ignoreSelectedRules(true);
    }

    public void consider() {
        this.editor.rules.ignoreSelectedRules(false);
    }

    public void checkGrammar() {
        this.editor.showProgress("Checking Grammar...", this);
        this.editor.console.makeCurrent();
        this.editor.console.println("Checking Grammar...");
        this.checkGrammar.check();
        StatisticsAW.shared().recordEvent(47);
    }

    public void checkGrammarDidBegin() {
        this.checkingGrammar = true;
    }

    public void checkGrammarDidEnd(EngineGrammarResult engineGrammarResult) {
        this.checkingGrammar = false;
        this.editor.hideProgress();
        if (engineGrammarResult.isSuccess()) {
            XJAlert.display(this.editor.getWindowContainer(), "Success", "Check Grammar succeeded.");
        } else if (engineGrammarResult.getErrorCount() > 0) {
            XJAlert.display(this.editor.getWindowContainer(), "Error", "Check Grammar reported some errors:\n" + engineGrammarResult.getFirstErrorMessage() + "\nConsult the console for more information.");
        } else if (engineGrammarResult.getWarningCount() > 0) {
            XJAlert.display(this.editor.getWindowContainer(), "Warning", "Check Grammar reported some warnings:\n" + engineGrammarResult.getFirstWarningMessage() + "\nConsult the console for more information.");
        } else {
            XJAlert.display(this.editor.getWindowContainer(), "Error", "Check Grammar reported some errors.\nConsult the console for more information.");
        }
    }

    public void dialogDidCancel() {
        if (this.checkingGrammar) {
            this.checkGrammar.cancel();
        }
    }
}

