/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.menu;

import java.util.Set;
import javax.swing.JOptionPane;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.menu.MenuAbstract;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.syntax.element.ElementReference;

public class MenuGoTo
extends MenuAbstract {
    public MenuGoTo(CEditorGrammar cEditorGrammar) {
        super(cEditorGrammar);
    }

    public void goToRule() {
        StatisticsAW.shared().recordEvent(20);
        this.editor.goToRule.display();
    }

    public void goToDeclaration() {
        StatisticsAW.shared().recordEvent(21);
        ElementReference elementReference = this.editor.getCurrentReference();
        if (elementReference == null) {
            return;
        }
        for (ATEToken aTEToken : this.editor.parserEngine.getDecls()) {
            if (!aTEToken.getAttribute().equals(elementReference.token.getAttribute())) continue;
            this.editor.goToHistoryRememberCurrentPosition();
            this.setCaretPosition(aTEToken.start);
            break;
        }
    }

    public void goToBreakpoint(int n) {
        if (n == -1) {
            StatisticsAW.shared().recordEvent(26);
        } else {
            StatisticsAW.shared().recordEvent(27);
        }
        Set<Integer> set = this.editor.breakpointManager.getBreakpoints();
        int n2 = this.editor.getTextEditor().getLineIndexAtTextPosition(this.getCaretPosition());
        if (n2 == -1) {
            return;
        }
        while ((n2 += n) >= 0 && n2 <= this.editor.parserEngine.getMaxLines() - 1) {
            if (!set.contains(n2)) continue;
            this.moveCursorToLine(n2);
            break;
        }
    }

    public void goToLine() {
        StatisticsAW.shared().recordEvent(22);
        String string = (String)JOptionPane.showInputDialog(this.editor.getJavaContainer(), "Line number:", "Go To Line", 3, null, null, null);
        if (string != null) {
            this.moveCursorToLine(Integer.parseInt(string) - 1);
        }
    }

    public void goToCharacter() {
        StatisticsAW.shared().recordEvent(23);
        String string = (String)JOptionPane.showInputDialog(this.editor.getJavaContainer(), "Character number:", "Go To Character", 3, null, null, null);
        if (string != null) {
            int n = Integer.parseInt(string);
            if (n < 0 || n > this.getTextPane().getDocument().getLength() - 1) {
                return;
            }
            this.editor.goToHistoryRememberCurrentPosition();
            this.setCaretPosition(n);
        }
    }

    public void goToBackward() {
        StatisticsAW.shared().recordEvent(24);
        if (this.editor.goToHistory.canGoBack()) {
            this.setCaretPosition(this.editor.goToHistory.getBackPosition(this.getCaretPosition()));
            this.editor.refreshMainMenuBar();
        }
    }

    public void goToForward() {
        StatisticsAW.shared().recordEvent(25);
        if (this.editor.goToHistory.canGoForward()) {
            this.setCaretPosition(this.editor.goToHistory.getForwardPosition());
            this.editor.refreshMainMenuBar();
        }
    }

    public void moveCursorToLine(int n) {
        if (n < 0 || n > this.editor.getLines().size() - 1) {
            return;
        }
        ATELine aTELine = this.editor.getLines().get(n);
        this.editor.goToHistoryRememberCurrentPosition();
        this.setCaretPosition(aTELine.position);
    }
}

