/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.menu;

import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.generate.CodeDisplay;
import org.antlr.works.generate.CodeGenerate;
import org.antlr.works.generate.CodeGenerateDelegate;
import org.antlr.works.grammar.CheckGrammar;
import org.antlr.works.grammar.CheckGrammarDelegate;
import org.antlr.works.grammar.EngineGrammarResult;
import org.antlr.works.menu.MenuAbstract;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.xjlib.appkit.utils.XJAlert;

public class MenuGenerate
extends MenuAbstract
implements CodeGenerateDelegate,
CheckGrammarDelegate {
    public CodeGenerate generateCode;
    protected CheckGrammar checkGrammar;
    protected String actionShowCodeRule;
    protected int actionShowCodeType;
    protected boolean actionShowCodeAfterGeneration = false;

    public MenuGenerate(CEditorGrammar cEditorGrammar) {
        super(cEditorGrammar);
        this.generateCode = new CodeGenerate(cEditorGrammar, this);
        this.checkGrammar = new CheckGrammar(cEditorGrammar, this);
    }

    public void close() {
        super.close();
        this.generateCode.close();
        this.checkGrammar.close();
    }

    public void generateCode() {
        this.actionShowCodeRule = null;
        this.generateCodeProcess();
    }

    protected void generateCodeProcess() {
        StatisticsAW.shared().recordEvent(80);
        if (!this.editor.ensureDocumentSaved()) {
            return;
        }
        this.checkGrammar.check();
    }

    protected void generateCodeProcessContinued() {
        if (!this.editor.getDocument().performAutoSave()) {
            return;
        }
        this.generateCode.setDebug(false);
        this.generateCode.generateInThread(this.editor.getJavaContainer());
    }

    public boolean checkLanguage() {
        if (!this.isKnownLanguage()) {
            XJAlert.display(this.editor.getWindowContainer(), "Error", "Can only show generated grammar for Java language");
            return false;
        }
        return true;
    }

    public boolean isKnownLanguage() {
        String string = this.generateCode.getGrammarLanguage();
        return string != null && string.equals("Java");
    }

    public void showGeneratedCode(int n) {
        StatisticsAW.shared().recordEvent(n == 2 ? 82 : 81);
        if (n == 2) {
            if (!this.generateCode.supportsLexer()) {
                XJAlert.display(this.editor.getWindowContainer(), "Error", "Cannot generate the lexer because there is no lexer in this grammar.");
                return;
            }
        } else if (!this.generateCode.supportsParser()) {
            XJAlert.display(this.editor.getWindowContainer(), "Error", "Cannot generate the parser because there is no parser in this grammar.");
            return;
        }
        this.checkAndShowGeneratedCode(null, n);
    }

    public void showRuleGeneratedCode() {
        StatisticsAW.shared().recordEvent(83);
        if (this.editor.getCurrentRule() == null) {
            XJAlert.display(this.editor.getWindowContainer(), "Error", "A rule must be selected first.");
        } else {
            ElementRule elementRule = this.editor.getCurrentRule();
            this.checkAndShowGeneratedCode(elementRule.name, elementRule.lexer ? 2 : 1);
        }
    }

    public void checkAndShowGeneratedCode(String string, int n) {
        if (!this.checkLanguage()) {
            return;
        }
        if (!this.generateCode.isGeneratedTextFileExisting(n) || this.generateCode.isFileModifiedSinceLastGeneration() || this.editor.getDocument().isDirty()) {
            this.actionShowCodeRule = string;
            this.actionShowCodeType = n;
            this.actionShowCodeAfterGeneration = true;
            this.generateCodeProcess();
            return;
        }
        this.showGeneratedCode(string, n);
    }

    private void showGeneratedCode(String string, int n) {
        String string2;
        String string3;
        CodeDisplay codeDisplay = new CodeDisplay(this.editor.getXJFrame());
        try {
            string3 = this.generateCode.getGeneratedClassName(n) + ".java";
        }
        catch (Exception exception) {
            XJAlert.display(this.editor.getWindowContainer(), "Error", "Cannot cannot get the name of the generated file:\n" + exception.toString());
            return;
        }
        try {
            string2 = this.generateCode.getGeneratedText(n);
        }
        catch (Exception exception) {
            XJAlert.display(this.editor.getWindowContainer(), "Error", "Exception while reading the generated file:\n" + exception.toString());
            return;
        }
        if (string != null) {
            int n2;
            int n3 = string2.indexOf("$ANTLR start " + string);
            n3 = string2.indexOf("\n", n3) + 1;
            for (n2 = string2.indexOf(new StringBuilder().append("$ANTLR end ").append(string).toString()); n2 > 0 && string2.charAt(n2) != '\n'; --n2) {
            }
            if (n3 >= 0 && n2 >= 0) {
                string2 = string2.substring(n3, n2);
                string3 = string;
            } else {
                XJAlert.display(this.editor.getWindowContainer(), "Error", "Cannot find markers for rule \"" + string + "\"");
                return;
            }
        }
        codeDisplay.setText(string2);
        codeDisplay.setTitle(string3);
        this.editor.addTab(codeDisplay);
        this.editor.makeBottomComponentVisible();
    }

    public boolean codeGenerateDisplaySuccess() {
        return !this.actionShowCodeAfterGeneration;
    }

    public void codeGenerateDidComplete() {
        if (this.actionShowCodeAfterGeneration) {
            this.actionShowCodeAfterGeneration = false;
            this.showGeneratedCode(this.actionShowCodeRule, this.actionShowCodeType);
        }
    }

    public void checkGrammarDidBegin() {
    }

    public void checkGrammarDidEnd(EngineGrammarResult engineGrammarResult) {
        if (engineGrammarResult.getErrorCount() == 0) {
            this.generateCodeProcessContinued();
        } else {
            XJAlert.display(this.editor.getWindowContainer(), "Error", "Check Grammar reported some errors:\n" + engineGrammarResult.getFirstErrorMessage() + "\nConsult the console for more information.");
        }
    }
}

