/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.menu;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.editor.EditorTab;
import org.antlr.works.menu.MenuAbstract;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.works.visualization.SDGenerator;
import org.antlr.works.visualization.Visual;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.GEngine;
import org.antlr.works.visualization.graphics.GEnginePS;
import org.antlr.works.visualization.graphics.graph.GGraphAbstract;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJFileChooser;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuExport
extends MenuAbstract {
    public MenuExport(CEditorGrammar cEditorGrammar) {
        super(cEditorGrammar);
    }

    public void exportEventsAsTextFile() {
        StatisticsAW.shared().recordEvent(3);
        if (!XJFileChooser.shared().displaySaveDialog((Component)this.editor.getWindowContainer(), "txt", "Text file", false)) {
            return;
        }
        String string = XJFileChooser.shared().getSelectedFilePath();
        if (string == null) {
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(this.editor.debugger.getEventsAsString());
            fileWriter.close();
        }
        catch (IOException iOException) {
            XJAlert.display(this.editor.getWindowContainer(), "Error", "Cannot save text file: " + string + "\nError: " + iOException);
        }
    }

    public void exportAsImage() {
        StatisticsAW.shared().recordEvent(0);
        EditorTab editorTab = this.editor.getSelectedTab();
        if (!editorTab.canExportToBitmap()) {
            return;
        }
        if (editorTab instanceof Visual) {
            this.exportRuleAsImage();
        } else {
            this.exportGViewAsImage(editorTab.getExportableGView());
        }
    }

    public void exportAllRulesAsImage() {
        this.exportAllRules(true);
    }

    public void exportAllRulesAsEPS() {
        this.exportAllRules(false);
    }

    public void exportAllRules(boolean bl) {
        List<String> list = null;
        if (bl) {
            list = MenuExport.lookupAvailableImageFormat();
        }
        if (!XJFileChooser.shared().displayChooseDirectory(this.editor.getWindowContainer(), list, list, !bl)) {
            return;
        }
        String string = XJFileChooser.shared().getSelectedFilePath();
        String string2 = XJFileChooser.shared().getSelectedFileExtension();
        SDGenerator sDGenerator = new SDGenerator(this.editor.getEngineGrammar());
        for (ElementRule elementRule : this.editor.getRules()) {
            try {
                if (bl) {
                    sDGenerator.renderRuleToBitmapFile(elementRule.name, string2, XJUtils.concatPath(string, elementRule.name + "." + string2));
                    continue;
                }
                sDGenerator.renderRuleToEPSFile(elementRule.name, XJUtils.concatPath(string, elementRule.name + ".eps"));
            }
            catch (Exception exception) {
                XJAlert.display(this.editor.getWindowContainer(), "Error", "Images cannot be saved because:\n" + exception);
            }
        }
    }

    public void exportRuleAsImage() {
        if (!this.editor.visual.canSaveImage()) {
            XJAlert.display(this.editor.getWindowContainer(), "Export Rule to Bitmap Image", "There is no rule at cursor position.");
            return;
        }
        this.saveImageToDisk(this.editor.visual.getImage());
    }

    public void exportGViewAsImage(GView gView) {
        this.saveImageToDisk(gView.getImage());
    }

    public void saveImageToDisk(BufferedImage bufferedImage) {
        List<String> list = MenuExport.lookupAvailableImageFormat();
        if (XJFileChooser.shared().displaySaveDialog((Component)this.editor.getWindowContainer(), list, list, false)) {
            String string = XJFileChooser.shared().getSelectedFilePath();
            try {
                ImageIO.write((RenderedImage)bufferedImage, string.substring(string.lastIndexOf(".") + 1), new File(string));
            }
            catch (IOException iOException) {
                XJAlert.display(this.editor.getWindowContainer(), "Error", "Image \"" + string + "\" cannot be saved because:\n" + iOException);
            }
        }
    }

    private static List<String> lookupAvailableImageFormat() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < ImageIO.getWriterFormatNames().length; ++i) {
            String string = ImageIO.getWriterFormatNames()[i].toLowerCase();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public void exportAsEPS() {
        StatisticsAW.shared().recordEvent(1);
        EditorTab editorTab = this.editor.getSelectedTab();
        if (!editorTab.canExportToEPS()) {
            return;
        }
        if (editorTab instanceof Visual) {
            this.exportRuleAsEPS();
        } else {
            this.exportGViewAsEPS(editorTab.getExportableGView());
        }
    }

    protected void exportRuleAsEPS() {
        if (this.editor.rules.getEnclosingRuleAtPosition(this.editor.getCaretPosition()) == null) {
            XJAlert.display(this.editor.getWindowContainer(), "Export Rule to EPS", "There is no rule at cursor position.");
            return;
        }
        GGraphAbstract gGraphAbstract = this.editor.visual.getCurrentGraph();
        if (gGraphAbstract == null) {
            XJAlert.display(this.editor.getWindowContainer(), "Export Rule to EPS", "There is no graphical visualization.");
            return;
        }
        if (!XJFileChooser.shared().displaySaveDialog((Component)this.editor.getWindowContainer(), "eps", "EPS file", false)) {
            return;
        }
        String string = XJFileChooser.shared().getSelectedFilePath();
        if (string == null) {
            return;
        }
        try {
            GEnginePS gEnginePS = new GEnginePS();
            GContext gContext = gGraphAbstract.getContext();
            GEngine gEngine = gContext.engine;
            gContext.setEngine(gEnginePS);
            gGraphAbstract.draw();
            gContext.setEngine(gEngine);
            XJUtils.writeStringToFile(gEnginePS.getPSText(), string);
        }
        catch (Exception exception) {
            this.editor.console.print(exception);
            XJAlert.display(this.editor.getWindowContainer(), "Error", "Cannot export to EPS file: " + string + "\nError: " + exception);
        }
    }

    protected void exportGViewAsEPS(GView gView) {
        if (!XJFileChooser.shared().displaySaveDialog((Component)this.editor.getWindowContainer(), "eps", "EPS file", false)) {
            return;
        }
        String string = XJFileChooser.shared().getSelectedFilePath();
        if (string == null) {
            return;
        }
        try {
            XJUtils.writeStringToFile(gView.getEPS(), string);
        }
        catch (Exception exception) {
            this.editor.console.print(exception);
            XJAlert.display(this.editor.getWindowContainer(), "Error", "Cannot export to EPS file: " + string + "\nError: " + exception);
        }
    }

    public void exportAsDOT() {
        StatisticsAW.shared().recordEvent(2);
        EditorTab editorTab = this.editor.getSelectedTab();
        if (!editorTab.canExportToDOT()) {
            return;
        }
        if (!XJFileChooser.shared().displaySaveDialog((Component)this.editor.getWindowContainer(), "dot", "DOT file", false)) {
            return;
        }
        String string = XJFileChooser.shared().getSelectedFilePath();
        if (string == null) {
            return;
        }
        try {
            XJUtils.writeStringToFile(editorTab.getDOTString(), string);
        }
        catch (Exception exception) {
            this.editor.console.print(exception);
            XJAlert.display(this.editor.getWindowContainer(), "Error", "Cannot export to DOT file: " + string + "\nError: " + exception);
        }
    }
}

