/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.interpreter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.tree.ParseTree;
import org.antlr.tool.Grammar;
import org.antlr.tool.Interpreter;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.awtree.AWTreePanel;
import org.antlr.works.awtree.AWTreePanelDelegate;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.editor.EditorTab;
import org.antlr.works.grammar.EngineGrammar;
import org.antlr.works.interpreter.EditorInterpreterTreeModel;
import org.antlr.works.menu.ContextualMenuFactory;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.swing.Toolbar;
import org.antlr.works.syntax.element.ElementRule;
import org.antlr.works.utils.IconManager;
import org.antlr.works.utils.TextUtils;
import org.antlr.works.utils.Utils;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.utils.XJDialogProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorInterpreter
extends EditorTab
implements Runnable,
AWTreePanelDelegate {
    protected JPanel panel;
    protected JSplitPane splitPane;
    protected JTextPane textPane;
    protected JScrollPane textScrollPane;
    protected EditorInterpreterTreeModel treeModel;
    protected AWTreePanel awTreePanel;
    protected JComboBox rulesCombo;
    protected JComboBox eolCombo;
    protected JLabel tokensToIgnoreLabel;
    protected XJDialogProgress progress;
    protected String startSymbol = null;
    protected CEditorGrammar editor;
    public static final String KEY_SPLITPANE_A = "KEY_SPLITPANE_A";

    public EditorInterpreter(CEditorGrammar cEditorGrammar) {
        this.editor = cEditorGrammar;
    }

    public void close() {
        this.awTreePanel.setDelegate(null);
        this.editor = null;
    }

    public void awake() {
        this.panel = new JPanel(new BorderLayout());
        this.textPane = new JTextPane();
        this.textPane.setBackground(Color.white);
        this.textPane.setBorder(null);
        this.textPane.setPreferredSize(new Dimension(300, 100));
        this.textPane.setFont(new Font(AWPrefs.getEditorFont(), 0, AWPrefs.getEditorFontSize()));
        TextUtils.createTabs(this.textPane);
        TextUtils.setDefaultTextPaneProperties(this.textPane);
        this.textScrollPane = new JScrollPane(this.textPane);
        this.textScrollPane.setWheelScrollingEnabled(true);
        this.treeModel = new EditorInterpreterTreeModel();
        this.awTreePanel = new AWTreePanel(this.treeModel);
        this.awTreePanel.setDelegate(this);
        this.splitPane = new JSplitPane();
        this.splitPane.setBorder(null);
        this.splitPane.setOrientation(1);
        this.splitPane.setLeftComponent(this.textScrollPane);
        this.splitPane.setRightComponent(this.awTreePanel);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setOneTouchExpandable(true);
        this.panel.add((Component)this.createControlPanel(), "North");
        this.panel.add((Component)this.splitPane, "Center");
        this.editor.getXJFrame().registerUndo(null, this.textPane);
    }

    public void componentShouldLayout() {
        this.splitPane.setDividerLocation(0.2);
    }

    public Box createControlPanel() {
        Toolbar toolbar = Toolbar.createHorizontalToolbar();
        toolbar.addElement(this.createRunButton());
        toolbar.addElement(this.createRulesPopUp());
        toolbar.addGroupSeparator();
        toolbar.addElement(new JLabel("Line Endings:"));
        toolbar.addElement(this.createEOLCombo());
        toolbar.addGroupSeparator();
        this.createTokensToIgnoreField(toolbar);
        return toolbar;
    }

    public JButton createRunButton() {
        JButton jButton = new JButton(IconManager.shared().getIconRun());
        jButton.setToolTipText("Run");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatisticsAW.shared().recordEvent(91);
                EditorInterpreter.this.interpret();
            }
        });
        return jButton;
    }

    public JComboBox createRulesPopUp() {
        this.rulesCombo = new JComboBox();
        this.rulesCombo.setFocusable(false);
        this.rulesCombo.setMaximumSize(new Dimension(Short.MAX_VALUE, this.rulesCombo.getPreferredSize().height));
        this.rulesCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)EditorInterpreter.this.rulesCombo.getSelectedItem();
                if (string != null) {
                    EditorInterpreter.this.startSymbol = string;
                }
            }
        });
        return this.rulesCombo;
    }

    public JComboBox createEOLCombo() {
        this.eolCombo = new JComboBox();
        this.eolCombo.setFocusable(false);
        this.eolCombo.setMaximumSize(new Dimension(Short.MAX_VALUE, this.eolCombo.getPreferredSize().height));
        Utils.fillComboWithEOL(this.eolCombo);
        return this.eolCombo;
    }

    public Box createTokensToIgnoreField(Toolbar toolbar) {
        toolbar.addElement(new JLabel("Ignore rules:"));
        this.tokensToIgnoreLabel = new JLabel();
        this.tokensToIgnoreLabel.setFont(this.tokensToIgnoreLabel.getFont().deriveFont(2));
        toolbar.addElement(this.tokensToIgnoreLabel);
        JButton jButton = new JButton("Guess");
        jButton.setFocusable(false);
        jButton.setToolTipText("Find the name of all rules containing an action with channel=99");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorInterpreter.this.editor.findTokensToIgnore(true);
            }
        });
        toolbar.add(Box.createHorizontalGlue());
        toolbar.addElement(jButton);
        return toolbar;
    }

    public Container getContainer() {
        return this.panel;
    }

    public void setRules(List<ElementRule> list) {
        this.updateRulesCombo(list);
        this.updateIgnoreTokens(list);
    }

    public void updateRulesCombo(List<ElementRule> list) {
        Object object = this.rulesCombo.getSelectedItem();
        this.rulesCombo.removeAllItems();
        if (list != null) {
            for (ElementRule elementRule : list) {
                this.rulesCombo.addItem(elementRule.toString());
            }
        }
        if (object != null) {
            this.rulesCombo.setSelectedItem(object);
        }
    }

    public void updateIgnoreTokens(List<ElementRule> list) {
        StringBuffer stringBuffer = new StringBuffer();
        if (list != null) {
            for (ElementRule elementRule : list) {
                if (!elementRule.ignored) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(elementRule.name);
            }
        }
        if (stringBuffer.length() == 0) {
            this.tokensToIgnoreLabel.setText("-");
        } else {
            this.tokensToIgnoreLabel.setText(stringBuffer.toString());
        }
    }

    public void interpret() {
        this.editor.console.makeCurrent();
        if (this.progress == null) {
            this.progress = new XJDialogProgress(this.editor.getXJFrame());
        }
        this.progress.setInfo("Interpreting...");
        this.editor.findTokensToIgnore(false);
        this.progress.setCancellable(false);
        this.progress.setIndeterminate(true);
        this.progress.display();
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.editor.getEngineGrammar().analyze();
            this.process();
        }
        catch (Exception exception) {
            this.editor.console.print(exception);
        }
        finally {
            this.runEnded();
        }
    }

    public void runEnded() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditorInterpreter.this.progress.close();
            }
        });
    }

    protected void process() {
        Object object;
        this.progress.setInfo("Interpreting...");
        this.editor.console.println("Interpreting...");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream(Utils.convertRawTextWithEOL(this.textPane.getText(), this.eolCombo));
        EngineGrammar engineGrammar = this.editor.getEngineGrammar();
        try {
            engineGrammar.createGrammars();
        }
        catch (Exception exception) {
            this.editor.console.print(exception);
            return;
        }
        Grammar grammar = engineGrammar.getParserGrammar();
        Grammar grammar2 = engineGrammar.getLexerGrammar();
        if (grammar2 == null) {
            throw new RuntimeException("Lexer is null. Check the grammar before running the interpreter.");
        }
        Interpreter interpreter = new Interpreter(grammar2, aNTLRStringStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream(interpreter);
        StringTokenizer stringTokenizer = new StringTokenizer(this.tokensToIgnoreLabel.getText(), " ");
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            commonTokenStream.setTokenTypeChannel(grammar2.getTokenType((String)object), 99);
        }
        object = new Interpreter(grammar, commonTokenStream);
        ParseTree parseTree = null;
        try {
            parseTree = ATEToken.isLexerName(this.startSymbol) ? interpreter.parse(this.startSymbol) : ((Interpreter)object).parse(this.startSymbol);
        }
        catch (Exception exception) {
            this.editor.console.print(exception);
        }
        if (grammar != null && parseTree != null) {
            SwingUtilities.invokeLater(new Refresh(grammar, parseTree));
        }
    }

    @Override
    public boolean canExportToBitmap() {
        return true;
    }

    @Override
    public boolean canExportToEPS() {
        return true;
    }

    @Override
    public GView getExportableGView() {
        return this.awTreePanel.getGraphView();
    }

    @Override
    public String getTabName() {
        return "Interpreter";
    }

    @Override
    public Component getTabComponent() {
        return this.getContainer();
    }

    @Override
    public void awTreeDidSelectTreeNode(TreeNode treeNode, boolean bl) {
    }

    @Override
    public JPopupMenu awTreeGetContextualMenu() {
        ContextualMenuFactory contextualMenuFactory = new ContextualMenuFactory(this.editor.editorMenu);
        contextualMenuFactory.addItem(111);
        contextualMenuFactory.addItem(110);
        return contextualMenuFactory.menu;
    }

    public void setPersistentData(Map map) {
        if (map == null) {
            return;
        }
        Integer n = (Integer)map.get(KEY_SPLITPANE_A);
        if (n != null) {
            this.splitPane.setDividerLocation(n);
        }
    }

    public Map<String, Integer> getPersistentData() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put(KEY_SPLITPANE_A, this.splitPane.getDividerLocation());
        return hashMap;
    }

    public class Refresh
    implements Runnable {
        Grammar g;
        ParseTree t;

        public Refresh(Grammar grammar, ParseTree parseTree) {
            this.g = grammar;
            this.t = parseTree;
        }

        public void run() {
            EditorInterpreter.this.treeModel.setGrammar(this.g);
            EditorInterpreter.this.treeModel.setTree(this.t);
            EditorInterpreter.this.awTreePanel.setRoot((TreeNode)EditorInterpreter.this.treeModel.getRoot());
            EditorInterpreter.this.awTreePanel.refresh();
        }
    }
}

