/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.idea;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.TextLayout;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.idea.IdeaAction;
import org.antlr.works.utils.IconManager;
import org.antlr.works.utils.OverlayObject;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdeaOverlay
extends OverlayObject {
    protected static final int VISIBLE_IDEAS = 10;
    protected CEditorGrammar editor;
    protected DefaultListModel ideasModel;
    protected JList ideasList;
    protected JScrollPane ideasScrollPane;
    protected JToggleButton ideaButton;
    protected List<IdeaAction> ideas;

    public IdeaOverlay(CEditorGrammar cEditorGrammar, XJFrameInterface xJFrameInterface, JComponent jComponent) {
        super(xJFrameInterface, jComponent);
        this.editor = cEditorGrammar;
    }

    @Override
    public void close() {
        super.close();
        this.editor = null;
    }

    public void setIdeas(List<IdeaAction> list) {
        this.ideas = list;
    }

    @Override
    public JComponent overlayCreateInterface() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        this.ideaButton = new JToggleButton();
        this.ideaButton.setIcon(IconManager.shared().getIconIdea());
        this.ideaButton.setContentAreaFilled(false);
        this.ideaButton.setBorder(null);
        this.ideaButton.setFocusable(false);
        this.ideaButton.addActionListener(new IdeaActionListener());
        this.ideaButton.setToolTipText("Click to display ideas");
        this.ideaButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                IdeaOverlay.this.ideaButton.setBorder(BorderFactory.createLineBorder(Color.darkGray));
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (IdeaOverlay.this.ideaButton.isSelected()) {
                    return;
                }
                IdeaOverlay.this.ideaButton.setBorder(null);
            }
        });
        jPanel.add((Component)this.ideaButton, "Center");
        this.ideasModel = new DefaultListModel();
        this.ideasList = new JList(this.ideasModel);
        this.ideasList.setSelectionMode(0);
        this.ideasList.setBackground(new Color(235, 244, 254));
        this.ideasList.setPrototypeCellValue("This is a rule name g");
        this.ideasList.addKeyListener(new ListKeyAdapter());
        this.ideasList.addMouseListener(new ListMouseAdapter());
        this.ideasList.addMouseMotionListener(new ListMouseMotionAdapter());
        this.ideasScrollPane = new JScrollPane(this.ideasList, 20, 31);
        this.ideasScrollPane.setBorder(BorderFactory.createBevelBorder(0));
        this.ideasScrollPane.setVisible(false);
        this.parentFrame.getLayeredPane().add((Component)this.ideasScrollPane, JLayeredPane.MODAL_LAYER);
        return jPanel;
    }

    @Override
    public int overlayDefaultWidth() {
        return 20;
    }

    @Override
    public int overlayDefaultHeight() {
        return 20;
    }

    @Override
    public int overlayDefaultAlignment() {
        return 2;
    }

    @Override
    public Point overlayCustomPosition() {
        Point point = this.editor.getTextEditor().getLineTextPositionsAtTextPosition(this.editor.getCaretPosition());
        int n = 0;
        int n2 = 0;
        try {
            n2 = this.editor.getTextPane().modelToView((int)point.y).y;
            n = this.editor.getTextPane().modelToView((int)this.editor.getCaretPosition()).x;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Point point2 = new Point(0, 0);
        if (n < 50) {
            point2.x += 50;
        }
        Point point3 = SwingUtilities.convertPoint(this.parentComponent, point2, this.parentFrame.getRootPane());
        return new Point(point3.x + 5, point3.y + n2);
    }

    @Override
    public void hide() {
        super.hide();
        this.ideasScrollPane.setVisible(false);
    }

    @Override
    public void resize() {
        super.resize();
        this.resizeIdeas();
    }

    public void resizeIdeas() {
        Rectangle rectangle = this.content.getBounds();
        int n = this.ideasList.getFixedCellHeight();
        int n2 = this.ideasModel.size();
        if (n2 > 0) {
            int n3 = 0;
            for (int i = 0; i < this.ideasModel.size(); ++i) {
                IdeaAction ideaAction = (IdeaAction)this.ideasModel.getElementAt(i);
                TextLayout textLayout = new TextLayout(ideaAction.name, this.ideasList.getFont(), ((Graphics2D)this.ideasList.getGraphics()).getFontRenderContext());
                n3 = Math.max(n3, (int)textLayout.getBounds().getWidth());
            }
            n = n * Math.min(10, n2) + 5;
            this.ideasScrollPane.setBounds(rectangle.x, rectangle.y + rectangle.height, n3 + 10, n);
        }
    }

    public void updateIdeasList() {
        this.ideasModel.clear();
        Iterator<IdeaAction> iterator = this.ideas.iterator();
        while (iterator.hasNext()) {
            this.ideasModel.addElement(iterator.next());
        }
        this.ideasList.setSelectedIndex(0);
    }

    @Override
    public boolean overlayWillDisplay() {
        this.updateIdeasList();
        this.ideaButton.setSelected(false);
        this.ideaButton.setBorder(null);
        return true;
    }

    public void applyIdea(int n) {
        IdeaAction ideaAction = this.ideas.get(n);
        ideaAction.run();
    }

    public class ListKeyAdapter
    extends KeyAdapter {
        public void selectNextListElement(int n) {
            int n2 = IdeaOverlay.this.ideasList.getSelectedIndex();
            n2 += n;
            n2 = Math.min(Math.max(0, n2), IdeaOverlay.this.ideasModel.size() - 1);
            IdeaOverlay.this.ideasList.setSelectedIndex(n2);
            IdeaOverlay.this.ideasList.scrollRectToVisible(IdeaOverlay.this.ideasList.getCellBounds(n2, n2));
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            if (!IdeaOverlay.this.content.isVisible()) {
                return;
            }
            switch (keyEvent.getKeyCode()) {
                case 27: {
                    IdeaOverlay.this.hide();
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    IdeaOverlay.this.applyIdea(IdeaOverlay.this.ideasList.getSelectedIndex());
                    IdeaOverlay.this.hide();
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    this.selectNextListElement(-1);
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    this.selectNextListElement(1);
                    keyEvent.consume();
                }
            }
        }
    }

    public class ListMouseAdapter
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            IdeaOverlay.this.applyIdea(IdeaOverlay.this.ideasList.getSelectedIndex());
            IdeaOverlay.this.hide();
        }
    }

    public class ListMouseMotionAdapter
    extends MouseMotionAdapter {
        public void mouseMoved(MouseEvent mouseEvent) {
            IdeaOverlay.this.ideasList.setSelectedIndex(IdeaOverlay.this.ideasList.locationToIndex(mouseEvent.getPoint()));
        }
    }

    public class IdeaActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            IdeaOverlay.this.ideasScrollPane.setVisible(IdeaOverlay.this.ideaButton.isSelected());
        }
    }
}

